<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exslt="http://exslt.org/common">

	<xsl:template match="*" mode="scroller.content.set">
		<xsl:param name="parent" />
		<xsl:param name="level"
			select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="name()='variation'" />
			<xsl:otherwise>
				<xsl:value-of
					select="concat($indentation, 'elm_object_content_set(vc->', $parent,',','vc->',@id,');', $newline)" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>

	<xsl:template match="scroller">
		<xsl:param name="parent" />
		<xsl:param name="fromView" />
		<xsl:param name="view_configuration_id" />
		<xsl:param name="is_version_rm_support" />
		<xsl:param name="profile" />
		<xsl:param name="level"
			select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:choose>
			<xsl:when test="$fromView = 'true'">
				<xsl:value-of
					select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
				<xsl:value-of
					select="concat($indentation1, 'vc->', @id, '= elm_scroller_add(parent);', $newline)" />
				<xsl:if test="$profile='wearable-circle'">
					<xsl:value-of
						select="concat($indentation1, 'vc->circle_object_', @id, '= eext_circle_object_scroller_add(vc->', @id, ', uib_views_get_instance()->get_window_obj()->circle_surface);', $newline)" />
					<xsl:value-of
						select="concat($indentation1, 'eext_rotary_object_event_activated_set(vc->circle_object_', @id, ', EINA_TRUE);', $newline)" />
				</xsl:if>
				<xsl:value-of
					select="concat($indentation1, 'vc->root_container = vc->', @id, ';', $newline)" />
				<xsl:value-of select="concat($indentation,'}', $newline)" />
			</xsl:when>
			<xsl:otherwise>
				<xsl:if test="string-length($fromView) = 0">
					<xsl:value-of
						select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
					<xsl:value-of
						select="concat($indentation1, 'vc->', @id, '= elm_scroller_add(vc->',$parent,');', $newline)" />
					<xsl:if test="$profile='wearable-circle'">
						<xsl:value-of
							select="concat($indentation1, 'vc->circle_object_', @id, '= eext_circle_object_scroller_add(vc->', @id, ', uib_views_get_instance()->get_window_obj()->circle_surface);', $newline)" />
						<xsl:value-of
							select="concat($indentation1, 'eext_rotary_object_event_activated_set(vc->circle_object_', @id, ', EINA_TRUE);', $newline)" />
					</xsl:if>
					<xsl:value-of select="concat($indentation,'}', $newline)" />
				</xsl:if>

				<xsl:value-of
					select="concat($indentation, 'if(vc->', @id, ') {', $newline)" />
				<xsl:if test="string-length(@style) != 0">
					<xsl:value-of
						select="concat($indentation1, 'elm_object_style_set(vc->' , @id, ',', '&#34;', @style, '&#34;', ');', $newline)" />
				</xsl:if>

				<xsl:call-template name="size_hint_align_set">
					<xsl:with-param name="align_h" select="@align_h" />
					<xsl:with-param name="align_v" select="@align_v" />
					<xsl:with-param name="indentation" select="$indentation1" />
					<xsl:with-param name="id" select="@id" />
				</xsl:call-template>

				<xsl:call-template name="size_hint_weight_set">
					<xsl:with-param name="weight_h" select="@weight_h" />
					<xsl:with-param name="weight_v" select="@weight_v" />
					<xsl:with-param name="indentation" select="$indentation1" />
					<xsl:with-param name="id" select="@id" />
				</xsl:call-template>

				<xsl:param name="content_min_w">
					<xsl:call-template name="eina_bool">
						<xsl:with-param name="bool" select="@content_min_w" />
					</xsl:call-template>
				</xsl:param>
				<xsl:param name="content_min_h">
					<xsl:call-template name="eina_bool">
						<xsl:with-param name="bool" select="@content_min_h" />
					</xsl:call-template>
				</xsl:param>

				<xsl:value-of
					select="concat($indentation1, 'elm_scroller_content_min_limit(vc->', @id, ', ', $content_min_w, ', ', $content_min_h , '); ', $newline)" />

				<xsl:if
					test="string-length(@scrollbar_h) != 0 and string-length(@scrollbar_v) != 0">
					<xsl:variable name="scrollbar_h_key"
						select="concat('scrollbar_h', ':', @scrollbar_h)" />
					<xsl:variable name="scrollbar_h_value"
						select="exslt:node-set($value_map)//entry[@key=$scrollbar_h_key]" />
					<xsl:variable name="scrollbar_v_key"
						select="concat('scrollbar_v', ':', @scrollbar_v)" />
					<xsl:variable name="scrollbar_v_value"
						select="exslt:node-set($value_map)//entry[@key=$scrollbar_v_key]" />
					<xsl:choose>
						<xsl:when
							test="string-length($scrollbar_h_value) != 0 and string-length($scrollbar_v_value) !=0">
							<xsl:value-of
								select="concat($indentation1, 'elm_scroller_policy_set(vc->', @id, ', (Elm_Scroller_Policy)', $scrollbar_h_value, ', (Elm_Scroller_Policy)', $scrollbar_v_value, ');', $newline)" />
						</xsl:when>
						<xsl:when
							test="string-length($scrollbar_h_value) = 0 and string-length($scrollbar_v_value) !=0">
							<xsl:value-of
								select="concat($indentation1, 'elm_scroller_policy_set(vc->', @id, ', ', @scrollbar_h, ', (Elm_Scroller_Policy)', $scrollbar_v_value, ');', $newline)" />
						</xsl:when>
						<xsl:when
							test="string-length($scrollbar_h_value) != 0 and string-length($scrollbar_v_value) =0">
							<xsl:value-of
								select="concat($indentation1, 'elm_scroller_policy_set(vc->', @id, ', (Elm_Scroller_Policy)', $scrollbar_h_value, ', ', @scrollbar_v, ');', $newline)" />
						</xsl:when>
						<xsl:when
							test="string-length($scrollbar_h_value) = 0 and string-length($scrollbar_v_value) =0">
							<xsl:value-of
								select="concat($indentation1, 'elm_scroller_policy_set(vc->', @id, ', ', @scrollbar_h, ', ', @scrollbar_v, ');', $newline)" />
						</xsl:when>
					</xsl:choose>
				</xsl:if>

				<xsl:if test="string-length(@single_direction) != 0">
					<xsl:choose>
						<xsl:when test="string(number(@single_direction)) = 'NaN'">
							<xsl:value-of
								select="concat($indentation1, 'elm_scroller_single_direction_set(vc->', @id, ', ', @single_direction, ');', $newline)" />
						</xsl:when>
						<xsl:otherwise>
							<xsl:value-of
								select="concat($indentation1, 'elm_scroller_single_direction_set(vc->', @id, ', (Elm_Scroller_Single_Direction)', @single_direction, ');', $newline)" />
						</xsl:otherwise>
					</xsl:choose>
				</xsl:if>

				<xsl:if test="string-length(@propagate_events) != 0">
					<xsl:if test="@propagate_events = 'true'">
						<xsl:value-of
							select="concat($indentation1, 'elm_scroller_propagate_events_set(vc->', @id, ', EINA_TRUE);', $newline)" />
					</xsl:if>
					<xsl:if test="@horizontal = 'false'">
						<xsl:value-of
							select="concat($indentation1, 'elm_gengrid_horizontal_set(vc->', @id, ', EINA_FALSE);', $newline)" />
					</xsl:if>
				</xsl:if>

				<xsl:apply-templates select="*">
					<xsl:with-param name="parent" select="@id" />
					<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
					<xsl:with-param name="is_version_rm_support" select="$is_version_rm_support" />
					<xsl:with-param name="profile" select="$profile" />
				</xsl:apply-templates>
				<xsl:apply-templates mode="scroller.content.set"
					select="*">
					<xsl:with-param name="parent" select="@id" />
				</xsl:apply-templates>
				<xsl:apply-templates mode="visible" select="current()">
					<xsl:with-param name="parent" select="@id" />
					<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
				</xsl:apply-templates>
				<xsl:value-of select="concat($indentation,'}', $newline)" />
			</xsl:otherwise>
		</xsl:choose>
	</xsl:template>
</xsl:stylesheet>
