<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template match="spinner">
		<xsl:param name="parent" />
		<xsl:param name="view_configuration_id" />
		<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
		<xsl:param name="indentation">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level" />
			</xsl:call-template>
		</xsl:param>
		<xsl:param name="indentation1">
			<xsl:call-template name="dup">
				<xsl:with-param name="input" select="$indent" />
				<xsl:with-param name="count" select="$level+1" />
			</xsl:call-template>
		</xsl:param>
		<xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
		<xsl:value-of select="concat($indentation1, 'vc->', @id, '= elm_spinner_add(vc->',$parent,');', $newline)" />
		<xsl:value-of select="concat($indentation,'}', $newline)" />

		<xsl:value-of select="concat($indentation,'if(vc->', @id, ') {', $newline)" />


		<xsl:call-template name="size_hint_align_set">
			<xsl:with-param name="align_h" select="@align_h" />
			<xsl:with-param name="align_v" select="@align_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:call-template name="size_hint_weight_set">
			<xsl:with-param name="weight_h" select="@weight_h" />
			<xsl:with-param name="weight_v" select="@weight_v" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:call-template name="style">
			<xsl:with-param name="style" select="@style" />
			<xsl:with-param name="indentation" select="$indentation1" />
			<xsl:with-param name="id" select="@id" />
		</xsl:call-template>

		<xsl:if test="string-length(@label_format) != 0">
			<xsl:value-of select="concat($indentation1, 'elm_spinner_label_format_set(vc->', @id, ',', '&quot;', @label_format, '&quot;', ');', $newline)" />
		</xsl:if>
		<xsl:if test="string-length(@min) != 0 and string-length(@max) != 0">
			<xsl:value-of select="concat($indentation1, 'elm_spinner_min_max_set(vc->', @id, ',', @min, ',', @max, ');', $newline)" />
		</xsl:if>
		<xsl:if test="string-length(@step) != 0">
			<xsl:value-of select="concat($indentation1, 'elm_spinner_step_set(vc->', @id, ',', @step, ');', $newline)" />
		</xsl:if>
		<xsl:if test="string-length(@value) != 0">
			<xsl:value-of select="concat($indentation1, 'elm_spinner_value_set(vc->', @id, ',', @value, ');', $newline)" />
		</xsl:if>
		<xsl:if test="@wrap = 'true'">
			<xsl:value-of select="concat($indentation1, 'elm_spinner_wrap_set(vc->', @id, ', EINA_TRUE);', $newline)" />
		</xsl:if>
		<xsl:if test="@editable = 'false'">
			<xsl:value-of select="concat($indentation1, 'elm_spinner_editable_set(vc->', @id, ', EINA_FALSE);', $newline)" />
		</xsl:if>
		<xsl:if test="string-length(@interval) != 0">
			<xsl:value-of select="concat($indentation1, 'elm_spinner_interval_set(vc->', @id, ',', @interval, ');', $newline)" />
		</xsl:if>
		<xsl:if test="string-length(@base) != 0">
			<xsl:value-of select="concat($indentation1, 'elm_spinner_base_set(vc->', @id, ',', @base, ');', $newline)" />
		</xsl:if>
		<xsl:if test="string-length(@round) != 0">
			<xsl:value-of select="concat($indentation1, 'elm_spinner_round_set(vc->', @id, ',', @round, ');', $newline)" />
		</xsl:if>

		<xsl:if test="@disable = 'true'">
			<xsl:value-of select="concat($indentation1, 'elm_object_disabled_set(vc->', @id, ', EINA_TRUE);', $newline)" />
		</xsl:if>
		<xsl:apply-templates mode="visible" select="current()">
			<xsl:with-param name="parent" select="@id" />
			<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
		</xsl:apply-templates>
		<xsl:value-of select="concat($indentation,'}', $newline)" />
	</xsl:template>
</xsl:stylesheet>
