<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exslt="http://exslt.org/common">
    <xsl:template match="entry">
        <xsl:param name="parent" />
        <xsl:param name="view_configuration_id" />
        <xsl:param name="is_version_rm_support" />
        <xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
        <xsl:param name="indentation">
            <xsl:call-template name="dup">
                <xsl:with-param name="input" select="$indent" />
                <xsl:with-param name="count" select="$level" />
            </xsl:call-template>
        </xsl:param>
        <xsl:param name="indentation1">
            <xsl:call-template name="dup">
                <xsl:with-param name="input" select="$indent" />
                <xsl:with-param name="count" select="$level+1" />
            </xsl:call-template>
        </xsl:param>
        <xsl:param name="indentation2">
            <xsl:call-template name="dup">
                <xsl:with-param name="input" select="$indent" />
                <xsl:with-param name="count" select="$level+2" />
            </xsl:call-template>
        </xsl:param>
        <xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
        <xsl:value-of select="concat($indentation1, 'vc->', @id, '= elm_entry_add(vc->',$parent,');', $newline)" />
        <xsl:value-of select="concat($indentation,'}', $newline)" />
        <xsl:value-of select="concat($indentation, 'if(vc->', @id, ') {', $newline)" />
        <xsl:if test="string-length(@text) != 0">
            <xsl:value-of select="concat($indentation1, 'elm_object_text_set(vc->', @id, ',_UIB_LOCALE(', '&quot;', @text, '&quot;', '));', $newline)" />
        </xsl:if>
        <xsl:if test="string-length(@single_line) != 0">
            <xsl:choose>
                <xsl:when test="@single_line = 'true'">
                    <xsl:value-of select="concat($indentation1, 'elm_entry_single_line_set(vc->', @id, ', EINA_TRUE);', $newline)" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat($indentation1, 'elm_entry_single_line_set(vc->', @id, ', EINA_FALSE);', $newline)" />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:if test="string-length(@password) != 0">
            <xsl:choose>
                <xsl:when test="@password = 'true'">
                    <xsl:value-of select="concat($indentation1, 'elm_entry_password_set(vc->', @id, ', EINA_TRUE);', $newline)" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat($indentation1, 'elm_entry_password_set(vc->', @id, ', EINA_FALSE);', $newline)" />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:if test="string-length(@editable) != 0">
            <xsl:choose>
                <xsl:when test="@editable = 'false'">
                    <xsl:value-of select="concat($indentation1, 'elm_entry_editable_set(vc->', @id, ', EINA_FALSE);', $newline)" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat($indentation1, 'elm_entry_editable_set(vc->', @id, ', EINA_TRUE);', $newline)" />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:if test="string-length(@context_menu) != 0">
            <xsl:choose>
                <xsl:when test="@context_menu = 'false'">
                    <xsl:value-of select="concat($indentation1, 'elm_entry_context_menu_disabled_set(vc->', @id, ', EINA_TRUE);', $newline)" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat($indentation1, 'elm_entry_context_menu_disabled_set(vc->', @id, ', EINA_FALSE);', $newline)" />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:if test="string-length(@scroll) != 0">
            <xsl:choose>
                <xsl:when test="@scroll = 'true'">
                    <xsl:value-of select="concat($indentation1, 'elm_entry_scrollable_set(vc->', @id, ', EINA_TRUE);', $newline)" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat($indentation1, 'elm_entry_scrollable_set(vc->', @id, ', EINA_FALSE);', $newline)" />
                </xsl:otherwise>
            </xsl:choose>
        </xsl:if>
        <xsl:if test="string-length(@src) != 0">
            <xsl:variable name="escapedSrc">
                <xsl:call-template name="escapeStr">
                    <xsl:with-param name="str" select="@src" />
                </xsl:call-template>
            </xsl:variable>
            <xsl:value-of select="concat($indentation1, 'char *resource_path = NULL;', $newline)" />
            <xsl:choose>
                <xsl:when test="$is_version_rm_support='true'">
                    <xsl:value-of select="concat($indentation1, 'uib_util_rm_get_resource_path(APP_RESOURCE_TYPE_IMAGE, &quot;', $escapedSrc, '&quot;, &amp;resource_path);', $newline)" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat($indentation1, 'uib_util_rm_get_resource_path(-1, &quot;', $escapedSrc, '&quot;, &amp;resource_path);', $newline)" />
                </xsl:otherwise>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="string-length(@file_text_format) != 0">
                    <xsl:variable name="rconv_key" select="concat('file_text_format', ':', @file_text_format)" />
                    <xsl:variable name="rconv_value" select="exslt:node-set($value_map)//entry[@key=$rconv_key]" />
                    <xsl:choose>
                        <xsl:when test="string-length($rconv_value) != 0">
                            <xsl:value-of select="concat($indentation1, 'elm_entry_file_set(vc->', @id, ', resource_path, (Elm_Text_Format)', $rconv_value, ');', $newline)" />
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="concat($indentation1, 'elm_entry_file_set(vc->', @id, ', resource_path, @file_text_format);', $newline)" />
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat($indentation1, 'elm_entry_file_set(vc->', @id, ', resource_path, ELM_TEXT_FORMAT_PLAIN_UTF8);', $newline)" />
                </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="concat($indentation1, 'if(resource_path) {', $newline)" />
            <xsl:value-of select="concat($indentation2, 'free(resource_path);', $newline)" />
            <xsl:value-of select="concat($indentation1, '}', $newline)" />
            <xsl:if test="string-length(@autosave) != 0">
                <xsl:choose>
                    <xsl:when test="@autosave = 'true'">
                        <xsl:value-of select="concat($indentation1, 'elm_entry_autosave_set(vc->', @id, ', EINA_TRUE);', $newline)" />
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="concat($indentation1, 'elm_entry_autosave_set(vc->', @id, ', EINA_FALSE);', $newline)" />
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
        </xsl:if>

        <xsl:call-template name="size_hint_align_set">
            <xsl:with-param name="align_h" select="@align_h" />
            <xsl:with-param name="align_v" select="@align_v" />
            <xsl:with-param name="indentation" select="$indentation1" />
            <xsl:with-param name="id" select="@id" />
        </xsl:call-template>
        <xsl:value-of select="$newline" />

        <xsl:call-template name="size_hint_weight_set">
            <xsl:with-param name="weight_h" select="@weight_h" />
            <xsl:with-param name="weight_v" select="@weight_v" />
            <xsl:with-param name="indentation" select="$indentation1" />
            <xsl:with-param name="id" select="@id" />
        </xsl:call-template>
        <xsl:value-of select="$newline" />

        <xsl:call-template name="disable">
            <xsl:with-param name="disable" select="@disable" />
            <xsl:with-param name="indentation" select="$indentation1" />
            <xsl:with-param name="id" select="@id" />
        </xsl:call-template>

        <xsl:apply-templates mode="visible" select="current()">
            <xsl:with-param name="parent" select="@id" />
            <xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
        </xsl:apply-templates>
        <xsl:value-of select="concat($indentation,'}', $newline)" />

    </xsl:template>
</xsl:stylesheet>
