<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:exslt="http://exslt.org/common">
    <xsl:template match="gengriditem">
        <xsl:param name="parent" />
        <xsl:param name="is_version_rm_support" />
        <xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
        <xsl:param name="indentation">
            <xsl:call-template name="dup">
                <xsl:with-param name="input" select="$indent" />
                <xsl:with-param name="count" select="$level" />
            </xsl:call-template>
        </xsl:param>
        <xsl:param name="indentation1">
            <xsl:call-template name="dup">
                <xsl:with-param name="input" select="$indent" />
                <xsl:with-param name="count" select="$level+1" />
            </xsl:call-template>
        </xsl:param>
        <xsl:variable name="escapedSrc">
            <xsl:call-template name="escapeStr">
                <xsl:with-param name="str" select="@src" />
            </xsl:call-template>
        </xsl:variable>
        <xsl:value-of
            select="concat($indentation, 'vc->', @id, '= create_gengrid_item(vc->', $parent, ', &quot;', @style, '&quot;', ', _UIB_LOCALE(&quot;', @text, '&quot;), ','&#34;', $escapedSrc, '&#34;,' )" />
        <xsl:variable name="callback">
            <xsl:apply-templates select="event" mode="item_event">
                <xsl:with-param name="parent" select="@id" />
                <xsl:with-param name="view" select="./ancestor::view/@id" />
                <!-- Storyboard_START -->
                <xsl:with-param name="target" select="event/@target" />
                <!-- Storyboard_END -->
            </xsl:apply-templates>
        </xsl:variable>
        <xsl:choose>
            <xsl:when test="string-length($callback) != 0">
                <xsl:value-of select="concat(' (Evas_Smart_Cb)', $callback, ', vc);', $newline)" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat( ' NULL, NULL);', $newline)" />
            </xsl:otherwise>
        </xsl:choose>
        <!-- selection check -->
        <xsl:if test="string-length(@selected) != 0"><!-- default: true -->
            <xsl:if test="@selected = 'true'">
                <xsl:value-of select="concat($indentation, 'elm_gengrid_item_selected_set(vc->', @id, ', EINA_TRUE);', $newline)" />
            </xsl:if>
        </xsl:if>
        <!-- disability check -->
        <xsl:if test="string-length(@disabled) != 0"><!-- default: true -->
            <xsl:if test="@disabled = 'true'">
                <xsl:value-of select="concat($indentation, 'elm_object_item_disabled_set(vc->', @id, ', EINA_TRUE);', $newline)" />
            </xsl:if>
        </xsl:if>
        <xsl:if test="string-length(@align) != 0">
            <xsl:variable name="rconv_key" select="concat('gengrid:align', ':', @align)" />
            <xsl:variable name="rconv_value" select="exslt:node-set($value_map)//entry[@key=$rconv_key]" />
            <xsl:if test="string-length($rconv_value) != 0">
                <xsl:value-of select="concat($indentation, 'elm_gengrid_item_show(vc->', @id, ', ', $rconv_value, ');', $newline)" />
            </xsl:if>
        </xsl:if>
    </xsl:template>
</xsl:stylesheet>
