<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="icon">
        <xsl:param name="parent" />
        <xsl:param name="view_configuration_id" />
        <xsl:param name="is_version_rm_support" />
        <xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
        <xsl:param name="indentation">
            <xsl:call-template name="dup">
                <xsl:with-param name="input" select="$indent" />
                <xsl:with-param name="count" select="$level" />
            </xsl:call-template>
        </xsl:param>
        <xsl:param name="indentation1">
            <xsl:call-template name="dup">
                <xsl:with-param name="input" select="$indent" />
                <xsl:with-param name="count" select="$level+1" />
            </xsl:call-template>
        </xsl:param>
        <xsl:param name="indentation2">
            <xsl:call-template name="dup">
                <xsl:with-param name="input" select="$indent" />
                <xsl:with-param name="count" select="$level+2" />
            </xsl:call-template>
        </xsl:param>
        <xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
        <xsl:value-of select="concat($indentation1, 'vc->', @id, ' = elm_icon_add(','vc->' ,$parent, ');', $newline)" />
        <xsl:value-of select="concat($indentation,'}', $newline)" />

        <xsl:value-of select="concat($indentation, 'if(vc->', @id, ') {', $newline)" />
        <xsl:if test="string-length(@image-path) != 0">
            <xsl:variable name="escapedSrc">
                <xsl:call-template name="escapeStr">
                    <xsl:with-param name="str" select="@image-path" />
                </xsl:call-template>
            </xsl:variable>
            <xsl:value-of select="concat($indentation1, 'char *resource_path = NULL;', $newline)" />
            <xsl:choose>
                <xsl:when test="$is_version_rm_support='true'">
                    <xsl:value-of
                        select="concat($indentation1, 'uib_util_rm_get_resource_path(APP_RESOURCE_TYPE_IMAGE, &quot;', $escapedSrc, '&quot;, &amp;resource_path);', $newline)" />
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat($indentation1, 'uib_util_rm_get_resource_path(-1, &quot;', $escapedSrc, '&quot;, &amp;resource_path);', $newline)" />
                </xsl:otherwise>
            </xsl:choose>
            <xsl:value-of select="concat($indentation1, 'elm_image_file_set(vc->', @id, ', resource_path, NULL);', $newline)" />
            <xsl:value-of select="concat($indentation1, 'if(resource_path) {', $newline)" />
            <xsl:value-of select="concat($indentation2, 'free(resource_path);', $newline)" />
            <xsl:value-of select="concat($indentation1, '}', $newline)" />
        </xsl:if>
        <xsl:if test="string-length(@standard) != 0">
            <xsl:value-of select="concat($indentation1, 'elm_icon_standard_set(vc->', @id, ',', '&quot;', @standard, '&quot;', ');', $newline)" />
            <xsl:if test="string-length(@order-lookup) != 0">
                <xsl:choose>
                    <xsl:when test="string(number(@order-lookup))='NaN'">
                        <xsl:value-of select="concat($indentation1, 'elm_icon_order_lookup_set(vc->', @id, ', ', @order-lookup, ');', $newline)" />
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="concat($indentation1, 'elm_icon_order_lookup_set(vc->', @id, ', (Elm_Icon_Lookup_Order)', @order-lookup, ');', $newline)" />
                    </xsl:otherwise>
                </xsl:choose>
            </xsl:if>
        </xsl:if>

        <xsl:choose>
            <xsl:when test="name(parent::node())='listitem'">
                <xsl:value-of select="concat($indentation1, 'evas_object_size_hint_aspect_set(vc->', @id, ', EVAS_ASPECT_CONTROL_VERTICAL, 1, 1);', $newline)" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:call-template name="size_hint_align_set">
                    <xsl:with-param name="align_h" select="@align_h" />
                    <xsl:with-param name="align_v" select="@align_v" />
                    <xsl:with-param name="indentation" select="$indentation1" />
                    <xsl:with-param name="id" select="@id" />
                </xsl:call-template>
                <xsl:value-of select="$newline" />

                <xsl:call-template name="size_hint_weight_set">
                    <xsl:with-param name="weight_h" select="@weight_h" />
                    <xsl:with-param name="weight_v" select="@weight_v" />
                    <xsl:with-param name="indentation" select="$indentation1" />
                    <xsl:with-param name="id" select="@id" />
                </xsl:call-template>
                <xsl:value-of select="$newline" />
            </xsl:otherwise>
        </xsl:choose>

        <xsl:apply-templates mode="visible" select="current()">
            <xsl:with-param name="parent" select="@id" />
            <xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
        </xsl:apply-templates>
        <xsl:value-of select="concat($indentation,'}', $newline)" />
    </xsl:template>

    <xsl:template match="icon" mode="listitem_icon">
        <xsl:value-of select="concat('vc->', @id)" />
    </xsl:template>
</xsl:stylesheet>
