/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.codegenerator;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Platform;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.TizenProjectDescription;
import org.tizen.common.util.Assert;
import org.tizen.common.util.ProjectUtil;
import org.tizen.efluibuilder.codegenerator.CodeGeneratorException;
import org.tizen.efluibuilder.codegenerator.ViewCodeGenerator;
import org.tizen.efluibuilder.utility.XMLUtil;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class CodeGenerator {
    protected static Logger logger = LoggerFactory.getLogger(CodeGenerator.class);
    private static final String UI_APP_MANAGER_HEADER = "res/app_manager_header.xsl";
    private static final String UI_APP_MANAGER_SOURCE = "res/app_manager_source.xsl";
    private static final String UI_VIEW_MANAGER_HEADER = "res/view_manager_header.xsl";
    private static final String UI_VIEW_MANAGER_SOURCE = "res/view_manager_source.xsl";
    private static final String UI_GLOBAL_INC_HEADER = "res/g_inc_header.xsl";
    private static final String UI_UTIL_HEADER = "res/uib_util_header.xsl";
    private static final String UI_UTIL_SOURCE = "res/uib_util_source.xsl";
    private static final String UI_VIEWS_INC_HEADER = "res/uib_views_inc_header.xsl";
    private static final String UI_VIEWS_HEADER = "res/uib_views_header.xsl";
    private static final String UI_VIEWS_SOURCE = "res/uib_views_source.xsl";
    private static final String UI_VIEW_DATA_HEADER = "res/view_data.xsl";
    private static final String PATH_APP_MANAGER_HEADER = "src/managed/inc/uib_app_manager.h";
    private static final String PATH_APP_MANAGER_SOURCE = "src/managed/src/manager/uib_app_manager.c";
    private static final String PATH_VIEW_MANAGER_HEADER = "src/managed/inc/uib_view_manager.h";
    private static final String PATH_VIEW_MANAGER_SOURCE = "src/managed/src/manager/uib_view_manager.c";
    private static final String PATH_GLOBAL_INC_HEADER = "src/managed/inc/g_inc_uib.h";
    private static final String PATH_UTIL_HEADER = "src/managed/inc/uib_util.h";
    private static final String PATH_UTIL_SOURCE = "src/managed/src/utils/uib_util.c";
    private static final String PATH_VIEWS_INC_HEADER = "src/managed/inc/uib_views_inc.h";
    private static final String PATH_VIEWS_HEADER = "src/managed/inc/uib_views.h";
    private static final String PATH_VIEWS_SOURCE = "src/managed/src/view/uib_views.c";
    private static final String PATH_VIEW_DATA_HEADER = "src/managed/inc/view_data.h";
    private static final float SUPPORT_RM_VERSION = 2.4f;
    private static final String FILE_PROJECT_META = ".uproject";
    public static final String FILE_LAYOUT_META = "layout/layout.xml";
    private IProject project = null;
    private File targetDirectory = null;
    private File appFile = null;
    private String profile = null;
    private String isRMSupportVersion = null;
    private boolean isWidgetProject = false;
    private String version = null;

    public CodeGenerator(IProject iProject) throws CodeGeneratorException {
        this.project = iProject;
        try {
            this.profile = this.createProfile();
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new CodeGeneratorException(xPathExpressionException.getMessage());
        }
        catch (SAXException sAXException) {
            throw new CodeGeneratorException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new CodeGeneratorException(iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new CodeGeneratorException(parserConfigurationException.getMessage());
        }
        TizenProjectDescription tizenProjectDescription = ProjectUtil.getTizenProjectDescription((IProject)iProject);
        this.version = tizenProjectDescription.getVersion();
        this.isRMSupportVersion = String.valueOf(this.isVersionRMSupport(this.version));
        this.targetDirectory = new File(iProject.getLocation().toString());
        this.isWidgetProject = ProjectUtil.getTizenProjectType((IProject)iProject).isNativeWidgetApplicationProject();
    }

    public String getProfile() {
        return this.profile;
    }

    private String createProfile() throws SAXException, IOException, ParserConfigurationException, XPathExpressionException {
        IFile iFile = this.project.getFile(FILE_PROJECT_META);
        this.appFile = new File(iFile.getLocation().toString());
        Document document = this.loadXML(this.appFile);
        Assert.notNull((Object)document);
        String string = XMLUtil.getValue((Document)document, (String)"/properties/shape");
        TizenProjectDescription tizenProjectDescription = ProjectUtil.getTizenProjectDescription((IProject)this.project);
        String string2 = tizenProjectDescription.getProfileName();
        if (string.equals("circle")) {
            string2 = "wearable-circle";
        }
        return string2;
    }

    public void generate() throws CodeGeneratorException {
        IFile iFile = this.project.getFile(FILE_LAYOUT_META);
        File file = new File(iFile.getLocation().toString());
        try {
            Document document = this.loadXML(file);
            Assert.notNull((Object)document);
            this.deleteOldFilesAndCreateDirectories(this.targetDirectory);
            this.generateAppManagerHeader(document, this.getDestinationWriterForAppManagerHeader());
            this.generateAppManagerSource(document, this.getDestinationWriterForAppManagerSource());
            this.generateViewManagerHeader(document, this.getDestinationWriterForViewManagerHeader());
            this.generateViewManagerSource(document, this.getDestinationWriterForViewManagerSource());
            this.generateGlobalInc(document, this.getDestinationWriterForGlobalInc());
            this.generateUtilHeader(document, this.getDestinationWriterForUtilHeader());
            this.generateUtilSource(document, this.getDestinationWriterForUtilSource());
            this.generateViewsIncHeader(document, this.getDestinationWriterForViewsIncHeader());
            this.generateViewsHeader(document, this.getDestinationWriterForViewsHeader());
            this.generateViewsSource(document, this.getDestinationWriterForViewsSource());
            this.generateViewDataHeader(document, this.getDestinationWriterForViewDataHeader());
            NodeList nodeList = this.getViews(document);
            this.generateViewsFiles(nodeList, document);
            this.refreshManaged();
        }
        catch (SAXException sAXException) {
            throw new CodeGeneratorException(sAXException.getMessage());
        }
        catch (IOException iOException) {
            throw new CodeGeneratorException(iOException.getMessage());
        }
        catch (ParserConfigurationException parserConfigurationException) {
            throw new CodeGeneratorException(parserConfigurationException.getMessage());
        }
        catch (TransformerException transformerException) {
            throw new CodeGeneratorException(transformerException.getMessage());
        }
        catch (XPathExpressionException xPathExpressionException) {
            throw new CodeGeneratorException(xPathExpressionException.getMessage());
        }
        catch (CoreException coreException) {
            throw new CodeGeneratorException(coreException.getMessage());
        }
    }

    private InputStream openStream(String string) throws IOException {
        Bundle bundle = Platform.getBundle((String)"org.tizen.efluibuilder.codegenerator");
        URL uRL = bundle.getResource(string);
        if (uRL == null) {
            throw new IOException();
        }
        InputStream inputStream = uRL.openStream();
        return inputStream;
    }

    private Writer getDestinationWriterForAppManagerHeader() throws IOException {
        File file = new File(this.targetDirectory, PATH_APP_MANAGER_HEADER);
        FileWriter fileWriter = new FileWriter(file);
        return fileWriter;
    }

    private Writer getDestinationWriterForAppManagerSource() throws IOException {
        File file = new File(this.targetDirectory, PATH_APP_MANAGER_SOURCE);
        FileWriter fileWriter = new FileWriter(file);
        return fileWriter;
    }

    private Writer getDestinationWriterForViewManagerHeader() throws IOException {
        File file = new File(this.targetDirectory, PATH_VIEW_MANAGER_HEADER);
        FileWriter fileWriter = new FileWriter(file);
        return fileWriter;
    }

    private Writer getDestinationWriterForViewManagerSource() throws IOException {
        File file = new File(this.targetDirectory, PATH_VIEW_MANAGER_SOURCE);
        FileWriter fileWriter = new FileWriter(file);
        return fileWriter;
    }

    private Writer getDestinationWriterForGlobalInc() throws IOException {
        File file = new File(this.targetDirectory, PATH_GLOBAL_INC_HEADER);
        FileWriter fileWriter = new FileWriter(file);
        return fileWriter;
    }

    private Writer getDestinationWriterForUtilHeader() throws IOException {
        File file = new File(this.targetDirectory, PATH_UTIL_HEADER);
        FileWriter fileWriter = new FileWriter(file);
        return fileWriter;
    }

    private Writer getDestinationWriterForUtilSource() throws IOException {
        File file = new File(this.targetDirectory, PATH_UTIL_SOURCE);
        FileWriter fileWriter = new FileWriter(file);
        return fileWriter;
    }

    private Writer getDestinationWriterForViewsIncHeader() throws IOException {
        File file = new File(this.targetDirectory, PATH_VIEWS_INC_HEADER);
        FileWriter fileWriter = new FileWriter(file);
        return fileWriter;
    }

    private Writer getDestinationWriterForViewsHeader() throws IOException {
        File file = new File(this.targetDirectory, PATH_VIEWS_HEADER);
        FileWriter fileWriter = new FileWriter(file);
        return fileWriter;
    }

    private Writer getDestinationWriterForViewsSource() throws IOException {
        File file = new File(this.targetDirectory, PATH_VIEWS_SOURCE);
        FileWriter fileWriter = new FileWriter(file);
        return fileWriter;
    }

    private Writer getDestinationWriterForViewDataHeader() throws IOException {
        File file = new File(this.targetDirectory, PATH_VIEW_DATA_HEADER);
        FileWriter fileWriter = new FileWriter(file);
        return fileWriter;
    }

    private NodeList getViews(Document document) throws XPathExpressionException {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
            thread.setContextClassLoader(classLoader);
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        String string = "/document/views/view";
        NodeList nodeList = (NodeList)xPath.evaluate(string, document, XPathConstants.NODESET);
        return nodeList;
    }

    protected Document loadXML(File file) throws SAXException, IOException, ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        return document;
    }

    private String findStartupView(Document document) throws XPathExpressionException {
        Thread thread = Thread.currentThread();
        ClassLoader classLoader = thread.getContextClassLoader();
        if (classLoader == null) {
            classLoader = this.getClass().getClassLoader();
            thread.setContextClassLoader(classLoader);
        }
        XPath xPath = XPathFactory.newInstance().newXPath();
        String string = "/document/views/@startup";
        Object object = xPath.evaluate(string, document, XPathConstants.NODE);
        Assert.notNull((Object)object);
        Assert.isTrue((boolean)(object instanceof Node));
        Node node = (Node)object;
        String string2 = node.getTextContent();
        return string2;
    }

    private void generateViewsFiles(NodeList nodeList, Document document) throws TransformerException, IOException {
        int n = 0;
        while (n < nodeList.getLength()) {
            Node node = nodeList.item(n);
            ViewCodeGenerator viewCodeGenerator = new ViewCodeGenerator(this.targetDirectory, this.isRMSupportVersion, this.profile);
            viewCodeGenerator.generate(document, node);
            ++n;
        }
    }

    public void generateAppManagerHeader(Document document, Writer writer) throws TransformerException, IOException {
        InputStream inputStream = this.openStream(UI_APP_MANAGER_HEADER);
        StreamSource streamSource = new StreamSource(inputStream);
        this.generateCode(document, writer, streamSource, null);
        inputStream.close();
    }

    public void generateAppManagerSource(Document document, Writer writer) throws TransformerException, IOException {
        InputStream inputStream = this.openStream(UI_APP_MANAGER_SOURCE);
        StreamSource streamSource = new StreamSource(inputStream);
        this.generateCode(document, writer, streamSource, null);
        inputStream.close();
    }

    public void generateViewManagerHeader(Document document, Writer writer) throws TransformerException, IOException {
        InputStream inputStream = this.openStream(UI_VIEW_MANAGER_HEADER);
        StreamSource streamSource = new StreamSource(inputStream);
        this.generateCode(document, writer, streamSource, null);
        inputStream.close();
    }

    public void generateViewManagerSource(Document document, Writer writer) throws TransformerException, IOException {
        InputStream inputStream = this.openStream(UI_VIEW_MANAGER_SOURCE);
        StreamSource streamSource = new StreamSource(inputStream);
        this.generateCode(document, writer, streamSource, null);
        inputStream.close();
    }

    public void generateGlobalInc(Document document, Writer writer) throws TransformerException, IOException {
        InputStream inputStream = this.openStream(UI_GLOBAL_INC_HEADER);
        StreamSource streamSource = new StreamSource(inputStream);
        this.generateCode(document, writer, streamSource, null);
        inputStream.close();
    }

    public void generateUtilHeader(Document document, Writer writer) throws TransformerException, IOException {
        InputStream inputStream = this.openStream(UI_UTIL_HEADER);
        StreamSource streamSource = new StreamSource(inputStream);
        this.generateCode(document, writer, streamSource, null);
        inputStream.close();
    }

    public void generateUtilSource(Document document, Writer writer) throws TransformerException, IOException {
        InputStream inputStream = this.openStream(UI_UTIL_SOURCE);
        StreamSource streamSource = new StreamSource(inputStream);
        this.generateCode(document, writer, streamSource, null);
        inputStream.close();
    }

    public void generateViewsIncHeader(Document document, Writer writer) throws TransformerException, IOException {
        InputStream inputStream = this.openStream(UI_VIEWS_INC_HEADER);
        StreamSource streamSource = new StreamSource(inputStream);
        this.generateCode(document, writer, streamSource, null);
        inputStream.close();
    }

    public void generateViewsHeader(Document document, Writer writer) throws TransformerException, IOException {
        InputStream inputStream = this.openStream(UI_VIEWS_HEADER);
        StreamSource streamSource = new StreamSource(inputStream);
        this.generateCode(document, writer, streamSource, null);
        inputStream.close();
    }

    public void generateViewsSource(Document document, Writer writer) throws TransformerException, IOException, XPathExpressionException {
        InputStream inputStream = this.openStream(UI_VIEWS_SOURCE);
        String string = this.findStartupView(document);
        StreamSource streamSource = new StreamSource(inputStream);
        this.generateCode(document, writer, streamSource, string);
        inputStream.close();
    }

    public void generateViewDataHeader(Document document, Writer writer) throws TransformerException, IOException {
        InputStream inputStream = this.openStream(UI_VIEW_DATA_HEADER);
        StreamSource streamSource = new StreamSource(inputStream);
        this.generateCode(document, writer, streamSource, null);
        inputStream.close();
    }

    private void deleteOldFilesAndCreateDirectories(File file) throws IOException, CoreException {
        this.clean();
        this.createDirectories(file);
    }

    private void createDirectories(File file) {
        File file2 = new File(file, "src/managed/inc/");
        file2.mkdirs();
        File file3 = new File(file, "src/managed/src/view/");
        file3.mkdirs();
        File file4 = new File(file, "src/managed/src/utils/");
        file4.mkdirs();
        File file5 = new File(file, "src/managed/src/manager/");
        file5.mkdirs();
        File file6 = new File(file, "src/managed/src/connection");
        file6.mkdirs();
    }

    private boolean isVersionRMSupport(String string) {
        float f = Float.parseFloat(string = string.substring(0, 3));
        return f >= 2.4f;
    }

    private void generateCode(Node node, Writer writer, StreamSource streamSource, String string) throws TransformerException, IOException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer(streamSource);
        transformer.setOutputProperty("encoding", "UTF-8");
        transformer.setOutputProperty("method", "text");
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        if (string != null) {
            transformer.setParameter("startup_view", string);
        }
        if (this.profile != null) {
            transformer.setParameter("profile", this.profile);
        }
        if (this.isRMSupportVersion != null) {
            transformer.setParameter("is_version_rm_support", this.isRMSupportVersion);
        }
        transformer.setParameter("is_widget_project", this.isWidgetProject);
        if (this.version != null) {
            transformer.setParameter("version", this.version);
        }
        DOMSource dOMSource = new DOMSource(node);
        StreamResult streamResult = new StreamResult(writer);
        transformer.transform(dOMSource, streamResult);
        writer.close();
    }

    public void clean() throws IOException, CoreException {
        File file = new File(this.targetDirectory, "src/managed/");
        if (file.exists()) {
            FileUtils.deleteDirectory((File)file);
        }
        this.refreshManaged();
    }

    public void refreshManaged() throws CoreException {
        IFolder iFolder = this.project.getFolder("src/managed/");
        if (iFolder != null) {
            iFolder.refreshLocal(2, null);
        }
    }

    public static boolean checkDirectories(IProject iProject) {
        return iProject.findMember("src/managed/") != null && iProject.findMember("src/managed/src/") != null && iProject.findMember("src/managed/inc/") != null && iProject.findMember("src/managed/src/manager/") != null && iProject.findMember("src/managed/src/utils/") != null && iProject.findMember("src/managed/src/view/") != null;
    }
}

