/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.internal.connector;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.tizen.efluibuilder.internal.connector.Connector;
import org.tizen.efluibuilder.internal.connector.IConnector;
import org.tizen.efluibuilder.internal.connector.IService;
import org.tizen.efluibuilder.internal.connector.Service;
import org.tizen.efluibuilder.internal.connector.ServiceFactory;

public final class ConnectorFactory {
    private static ConnectorFactory instance = null;
    private Map<String, IConnector> connectors = new HashMap<String, IConnector>();
    private Map<String, Integer> references = new HashMap<String, Integer>();

    public static synchronized ConnectorFactory getDefault() {
        if (instance == null) {
            instance = new ConnectorFactory();
        }
        return instance;
    }

    private ConnectorFactory() {
    }

    private String createId(String string, String string2) {
        String string3 = String.valueOf(string) + "-" + string2;
        return string3;
    }

    private int getReference(String string) {
        return this.references.get(string);
    }

    private void addReference(String string) {
        if (!this.references.containsKey(string)) {
            this.references.put(string, 1);
            return;
        }
        int n = this.getReference(string);
        this.references.put(string, n + 1);
    }

    private void removeReference(String string) {
        int n = this.getReference(string);
        this.references.put(string, n - 1);
    }

    public IConnector create(String string, String string2) throws IOException {
        String string3 = this.createId(string, string2);
        if (this.connectors.containsKey(string3)) {
            this.addReference(string3);
            return this.connectors.get(string3);
        }
        ServiceFactory serviceFactory = ServiceFactory.getDefault();
        IService iService = serviceFactory.create(string, string2);
        Connector connector = null;
        if (iService instanceof Service && ((Service)iService).isConnected) {
            connector = new Connector(iService);
            connector.setId(string3);
            this.addReference(string3);
            this.connectors.put(string3, connector);
        }
        return connector;
    }

    public void destroy(String string, String string2) {
        String string3 = this.createId(string, string2);
        this.removeReference(string3);
        int n = this.getReference(string3);
        if (n != 0) {
            return;
        }
        IConnector iConnector = this.connectors.get(string3);
        this.connectors.remove(string3);
        ((Connector)iConnector).destroy();
        ServiceFactory serviceFactory = ServiceFactory.getDefault();
        serviceFactory.destroy(string, string2);
    }
}

