<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

    <xsl:template match="layout">
        <xsl:param name="parent" />
        <xsl:param name="view_configuration_id" />
        <xsl:param name="is_version_rm_support" />
        <xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
        <xsl:param name="indentation">
            <xsl:call-template name="dup">
                <xsl:with-param name="input" select="$indent" />
                <xsl:with-param name="count" select="$level" />
            </xsl:call-template>
        </xsl:param>
        <xsl:param name="indentation1">
            <xsl:call-template name="dup">
                <xsl:with-param name="input" select="$indent" />
                <xsl:with-param name="count" select="$level+1" />
            </xsl:call-template>
        </xsl:param>
        <xsl:param name="indentation2">
            <xsl:call-template name="dup">
                <xsl:with-param name="input" select="$indent" />
                <xsl:with-param name="count" select="$level+2" />
            </xsl:call-template>
        </xsl:param>
        <xsl:choose>
            <xsl:when test="name(parent::node())='view'">
                <xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
                <xsl:value-of select="concat($indentation1, 'vc->', @id, '= elm_layout_add(parent);', $newline)" />
                <xsl:value-of select="concat($indentation1, 'vc->root_container = vc->', @id, ';', $newline)" />
                <xsl:value-of select="concat($indentation,'}', $newline)" />
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="concat($indentation, 'if (!vc->', @id, ') {', $newline)" />
                <xsl:value-of select="concat($indentation1, 'vc->', @id, '= elm_layout_add(vc->', $parent, ');', $newline)" />
                <xsl:value-of select="concat($indentation,'}', $newline)" />
            </xsl:otherwise>
        </xsl:choose>

        <xsl:value-of select="$indentation" />
        <xsl:value-of select="concat('if(vc->', @id, ') {')" />
        <xsl:value-of select="$newline" />
        <xsl:choose>
            <xsl:when test="string-length(@src) != 0">
                <xsl:variable name="escapedSrc">
                    <xsl:call-template name="escapeStr">
                        <xsl:with-param name="str" select="@src" />
                    </xsl:call-template>
                </xsl:variable>
                <!-- <xsl:variable name="file_path">
                    <xsl:choose>
                        <xsl:when test="contains($escapedSrc, '.edc')">
                            <xsl:value-of select="substring-before($escapedSrc, '.edc')" />
                            <xsl:text>.edj</xsl:text>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$escapedSrc" />
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable> -->
                <!-- <xsl:value-of select="concat($indentation1, 'char ', @id, '_resource_path[PATH_MAX] = {0, };', $newline)"/> -->
                <xsl:value-of select="concat($indentation1, 'char *resource_path = NULL;', $newline)" />
                <xsl:choose>
                    <xsl:when test="$is_version_rm_support='true'">
                        <xsl:value-of select="concat($indentation1, 'uib_util_rm_get_resource_path(APP_RESOURCE_TYPE_IMAGE, &quot;', $escapedSrc, '&quot;, &amp;resource_path);', $newline)" />
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="concat($indentation1, 'uib_util_rm_get_resource_path(-1, &quot;', $escapedSrc, '&quot;, &amp;resource_path);', $newline)" />
                    </xsl:otherwise>
                </xsl:choose>
                <xsl:value-of select="concat($indentation1, 'elm_layout_file_set(vc->', @id, ', resource_path', ', &quot;', @group, '&quot;);')" />
                <xsl:value-of select="$newline" />
                <xsl:value-of select="concat($indentation1, 'if(resource_path) {', $newline)" />
                <xsl:value-of select="concat($indentation2, 'free(resource_path);', $newline)" />
                <xsl:value-of select="concat($indentation1, '}', $newline)" />

                <!-- <xsl:value-of select="concat($indentation1 , 'app_get_resource(&quot;', $file_path, '&quot; , ', @id, '_resource_path, (int)PATH_MAX);', $newline)" /> <xsl:value-of 
                    select="concat($indentation1 , 'elm_layout_file_set(vc->', @id, ', ', @id, '_resource_path' , ', &quot;', @group, '&quot;);')" /> -->
                <xsl:value-of select="$newline" />
            </xsl:when>
            <xsl:otherwise>
            </xsl:otherwise>
        </xsl:choose>
        <xsl:value-of select="$newline" />

        <xsl:call-template name="size_hint_align_set">
            <xsl:with-param name="align_h" select="@align_h" />
            <xsl:with-param name="align_v" select="@align_v" />
            <xsl:with-param name="indentation" select="$indentation1" />
            <xsl:with-param name="id" select="@id" />
        </xsl:call-template>
        <xsl:value-of select="$newline" />

        <xsl:call-template name="size_hint_weight_set">
            <xsl:with-param name="weight_h" select="@weight_h" />
            <xsl:with-param name="weight_v" select="@weight_v" />
            <xsl:with-param name="indentation" select="$indentation1" />
            <xsl:with-param name="id" select="@id" />
        </xsl:call-template>
        <xsl:value-of select="$newline" />

        <xsl:apply-templates select="*">
            <xsl:with-param name="parent" select="@id" />
        </xsl:apply-templates>

        <xsl:if test="@disable = 'true'">
            <xsl:value-of select="concat($indentation1, 'elm_object_disabled_set(vc->', @id, ', EINA_TRUE);', $newline)" />
        </xsl:if>
        <xsl:apply-templates mode="visible" select="current()">
            <xsl:with-param name="parent" select="@id" />
            <xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
        </xsl:apply-templates>
        <xsl:value-of select="concat($indentation,'}', $newline)" />
    </xsl:template>

</xsl:stylesheet>
