<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:template name="view.comment">
		<xsl:text><![CDATA[	
/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/
		]]></xsl:text>
	</xsl:template>
	<xsl:template name="view.include">
		<xsl:value-of select="concat('&#35;', 'include ', '&#34;', 'g_inc_uib.h', '&#34;', $newline)" />
		<xsl:value-of select="concat('&#35;', 'include ', '&#34;', 'uib_views.h', '&#34;', $newline)" />
		<xsl:value-of select="concat('&#35;', 'include ', '&#34;', 'uib_views_inc.h', '&#34;', $newline)" />
		<xsl:value-of select="concat('&#35;', 'include ', '&#34;', 'uib_app_manager.h', '&#34;')" />
		<xsl:value-of select="$newline" />
		<xsl:value-of select="$newline" />
	</xsl:template>

	<xsl:template name="eventhandler_declaration">
		<xsl:param name="parent"></xsl:param>
		<xsl:value-of select="concat('&#47;&#42;',' event handler declarations ','&#42;&#47;')" />

		<xsl:value-of select="$newline" />
		<xsl:apply-templates select="event" mode="event.view.declaration">
			<xsl:with-param name="level">
				<xsl:value-of select="0" />
			</xsl:with-param>
			<xsl:with-param name="parent" select="@id" />
			<xsl:with-param name="view" select="@id" />
		</xsl:apply-templates>
		<xsl:apply-templates select="*" mode="event.declaration" />
		<xsl:value-of select="$newline" />
	</xsl:template>

	<xsl:template match="*" mode="event.declaration">
		<!-- Storyboard_START -->
		<xsl:apply-templates select="event" mode="event.wrapper.declaration">
			<!-- Storyboard_END -->
			<xsl:with-param name="level">
				<xsl:value-of select="0" />
			</xsl:with-param>
			<xsl:with-param name="view" select="./ancestor::view/@id" />
		</xsl:apply-templates>
		<xsl:apply-templates select="*" mode="event.declaration" />
	</xsl:template>

	<xsl:template match="*" mode="event.registration">
		<!-- Storyboard_START -->
		<xsl:apply-templates select="event" mode="event.wrapper.registration">
			<xsl:with-param name="view" select="./ancestor::view/@id" />
			<xsl:with-param name="parent" select="@id" />
		</xsl:apply-templates>
		<!-- Storyboard_END -->
		<xsl:apply-templates select="*" mode="event.registration" />
	</xsl:template>

	<xsl:template name="view.create_view">
		<xsl:param name="parent" />
		<xsl:param name="viewName" />
		<xsl:param name="indicator" />
		<xsl:param name="level" />
		<xsl:param name="indentation" />
		<xsl:param name="indentation1" />
		<xsl:param name="current_view_position" />
		<xsl:param name="is_version_rm_support" />
		<xsl:param name="profile" />
		<xsl:variable name="view_id" select="@id" />

		<xsl:value-of
			select="concat($indentation, 'uib_view_context','&#42;',' uib_view_', $parent, '_create(Evas_Object','&#42;',' parent, void','&#42;',' create_callback_param) {', $newline)" />

		<xsl:if test="string-length(@indicator) != 0">
			<xsl:choose>
				<xsl:when test="@indicator='false'">
					<xsl:value-of select="concat($indentation1, 'elm_win_indicator_mode_set(get_window(parent), ELM_WIN_INDICATOR_HIDE);', $newline)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($indentation1, 'elm_win_indicator_mode_set(get_window(parent), ELM_WIN_INDICATOR_SHOW);', $newline)" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>

		<xsl:value-of select="concat($indentation1, 'uib_', $parent, '_view_context','&#42;',' vc = calloc(1, sizeof(uib_', $parent, '_view_context));', $newline)" />

		<xsl:value-of select="concat($indentation1, 'vc->parent = parent;', $newline)" />

		<xsl:value-of select="concat($indentation1, 'vc->view_name = &#34;', $viewName,'&#34;;', $newline)" />

		<xsl:if test="string-length(@file) != 0">
			<xsl:value-of select="concat($indentation1, 'elm_bg_file_set(', @id, ',', '&quot;', @file, '&quot;', ');', $newline)" />
		</xsl:if>


		<xsl:if test="string-length(@option) != 0">
			<xsl:choose>
				<xsl:when test="string(number(@option))='NaN'">
					<xsl:value-of select="concat($indentation1, 'elm_bg_option_set(', @id, ', ', @option, ');', $newline)" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="concat($indentation1, 'elm_bg_option_set(', @id, ', (Elm_Bg_Option)', @option, ');', $newline)" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:if>

		<xsl:apply-templates select="*">
			<xsl:with-param name="parent" select="@id" />
			<xsl:with-param name="fromView" select="'true'" />
			<xsl:with-param name="is_version_rm_support" select="$is_version_rm_support" />
			<xsl:with-param name="profile" select="$profile" />
		</xsl:apply-templates>


		<xsl:value-of select="concat($indentation1, 'uib_app_manager_get_instance()->add_view_context((uib_view_context*)vc);', $newline)" />
		<xsl:value-of select="concat($indentation1, 'uib_views_get_instance()->set_targeted_view(vc->view_name);', $newline)" />
		<xsl:value-of select="$newline" />

		<xsl:value-of select="concat($indentation1, '//bind event handler', $newline)" />

		<xsl:apply-templates select="event" mode="registration">
			<xsl:with-param name="parent" select="'root_container'" />
			<xsl:with-param name="view" select="@id" />
		</xsl:apply-templates>
		<xsl:apply-templates select="*" mode="event.registration" />

		<xsl:value-of select="$newline" />
		<xsl:value-of select="$newline" />
		<xsl:value-of select="concat($indentation1, 'evas_object_data_set(vc->root_container, KEY_VIEW_CONTEXT, vc);', $newline)" />
		<xsl:value-of
			select="concat($indentation1, 'evas_object_event_callback_add(vc->root_container, EVAS_CALLBACK_DEL, (Evas_Object_Event_Cb)uib_views_destroy_callback, vc);', $newline)" />
		<xsl:value-of
			select="concat($indentation1, 'uib_views_create_callback(vc, evas_object_evas_get(vc->root_container), vc->root_container, create_callback_param);', $newline)" />
		<xsl:value-of select="$newline" />

		<xsl:value-of select="concat($indentation1, 'return (uib_view_context*)vc;', $newline)" />
		<xsl:value-of select="concat($indentation, '}', $newline)" />

		<!-- create mscreen view func -->
		<xsl:for-each select="/document/mscreen/configuration">
			<xsl:variable name="configuration_type" select="@type" />
			<xsl:variable name="configuration_id" select="@id" />
			<xsl:variable name="configuration_resolution" select="@device" />
			<xsl:variable name="configuration_orientation" select="@orientation" />
			<xsl:choose>
				<xsl:when test="$configuration_type='common'">
					<xsl:value-of select="concat('void uib_',$current_view_name,'_config_',$configuration_resolution,'_',$configuration_orientation,'() {',$newline)" />
					<xsl:call-template name="writing_layout_code">
						<xsl:with-param name="current_view_name" select="$current_view_name" />
						<xsl:with-param name="is_version_rm_support" select="$is_version_rm_support" />
						<xsl:with-param name="profile" select="$profile" />
						<xsl:with-param name="current_view_position" select="$current_view_position" />
						<xsl:with-param name="view_id" select="$view_id" />
						<xsl:with-param name="view_configuration_id" select="$configuration_id" />
						<xsl:with-param name="level" select="$level" />
						<xsl:with-param name="indentation" select="$indentation" />
						<xsl:with-param name="indentation1" select="$indentation1" />
					</xsl:call-template>

				</xsl:when>
				<xsl:otherwise>
					<xsl:for-each select="/document/views/view[$current_view_position]//variation[$configuration_id = @config_ref]">
						<xsl:if test="position()='1'">
							<xsl:value-of select="concat('void uib_',$current_view_name,'_config_',$configuration_resolution,'_',$configuration_orientation,'() {',$newline)" />
							<xsl:call-template name="writing_layout_code">
								<xsl:with-param name="current_view_name" select="$current_view_name" />
								<xsl:with-param name="is_version_rm_support" select="$is_version_rm_support" />
								<xsl:with-param name="profile" select="$profile" />
								<xsl:with-param name="current_view_position" select="$current_view_position" />
								<xsl:with-param name="view_id" select="$view_id" />
								<xsl:with-param name="view_configuration_id" select="$configuration_id" />
								<xsl:with-param name="level" select="$level" />
								<xsl:with-param name="indentation" select="$indentation" />
								<xsl:with-param name="indentation1" select="$indentation1" />
							</xsl:call-template>

						</xsl:if>
					</xsl:for-each>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:for-each>

	</xsl:template>



	<xsl:template name="writing_layout_code">
		<!-- Parameter -->
		<xsl:param name="current_view_name" />
		<xsl:param name="is_version_rm_support" />
		<xsl:param name="profile" />
		<xsl:param name="current_view_position" />
		<xsl:param name="view_id" />
		<xsl:param name="view_configuration_id" />
		<xsl:param name="level" />
		<xsl:param name="indentation" />
		<xsl:param name="indentation1" />

		<xsl:if test="count(/document/views/view[$current_view_position]/*) > 0">
			<xsl:value-of select="concat($indentation1,'uib_app_manager_st* uib_app_manager = uib_app_manager_get_instance();', $newline)" />
			<xsl:value-of
				select="concat($indentation1,'uib_',$current_view_name,'_view_context* vc = (uib_',$current_view_name,'_view_context*)uib_app_manager->find_view_context(','&#34;',$current_view_name,'&#34;',');',$newline)" />
		</xsl:if>
		<xsl:apply-templates select="/document/views/view[$current_view_position]/*">
			<xsl:with-param name="parent" select="$view_id" />
			<xsl:with-param name="fromView" select="'root_container'" />
			<xsl:with-param name="view_configuration_id" select="$view_configuration_id" />
			<xsl:with-param name="is_version_rm_support" select="$is_version_rm_support" />
			<xsl:with-param name="profile" select="$profile" />
		</xsl:apply-templates>
		<xsl:value-of select="concat('}', $newline, $newline)" />
	</xsl:template>





	<xsl:template match="view">
		<xsl:if test="$current_view_name=@id">
			<xsl:variable name="current_view_position" select="position()" />
			<xsl:param name="level" select="count(./ancestor::*)-count(//view/ancestor::*)" />
			<xsl:param name="is_version_rm_support" />
			<xsl:param name="profile" />

			<xsl:param name="indentation">
				<xsl:call-template name="dup">
					<xsl:with-param name="input" select="$indent" />
					<xsl:with-param name="count" select="$level" />
				</xsl:call-template>
			</xsl:param>
			<xsl:param name="indentation1">
				<xsl:call-template name="dup">
					<xsl:with-param name="input" select="$indent" />
					<xsl:with-param name="count" select="$level+1" />
				</xsl:call-template>
			</xsl:param>

			<xsl:call-template name="view.comment" />
			<xsl:call-template name="view.include" />
			<xsl:call-template name="eventhandler_declaration">
				<xsl:with-param name="parent" select="@id" />
			</xsl:call-template>
			<xsl:call-template name="view.create_view">
				<xsl:with-param name="parent" select="@id" />
				<xsl:with-param name="level" select="$level" />
				<xsl:with-param name="indentation" select="$indentation" />
				<xsl:with-param name="indentation1" select="$indentation1" />
				<xsl:with-param name="viewName" select="@id" />
				<xsl:with-param name="indicator" select="@indicator" />
				<xsl:with-param name="current_view_position" select="$current_view_position" />
				<xsl:with-param name="is_version_rm_support" select="$is_version_rm_support" />
				<xsl:with-param name="profile" select="$profile" />
			</xsl:call-template>
		</xsl:if>
	</xsl:template>

	<xsl:template match="/">
		<xsl:apply-templates select="//view">
		</xsl:apply-templates>
	</xsl:template>
</xsl:stylesheet>
