/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.projectmigrator.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StringUtil {
    private static Logger logger = LoggerFactory.getLogger(StringUtil.class);

    public static boolean isNullorEmpty(String string) {
        return string == null || string.isEmpty();
    }

    public static int endsWithNotDigitPos(String string) {
        if (!StringUtil.isNullorEmpty(string)) {
            char[] cArray = string.toCharArray();
            int n = cArray.length - 1;
            while (n >= 0) {
                if (!Character.isDigit(cArray[n])) {
                    return n;
                }
                --n;
            }
        }
        return -1;
    }

    public static String removeEndsWithDigit(String string) {
        int n = StringUtil.endsWithNotDigitPos(string);
        if (n >= 0) {
            return string.substring(0, n + 1);
        }
        return null;
    }

    public static String removeEndsWith(String string, String string2) {
        if (StringUtil.isNullorEmpty(string) || StringUtil.isNullorEmpty(string2)) {
            return null;
        }
        int n = string.lastIndexOf(string2);
        if (n >= 0) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String getStackTraceToString(Exception exception) {
        StringWriter stringWriter = new StringWriter();
        exception.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }
}

