<?xml version="1.0" encoding="utf-8"?>

<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>
	<xsl:param name="startup_view" />
	<xsl:param name="profile" />
	<xsl:param name="is_version_rm_support" />
	<xsl:template match="/">
		<xsl:call-template name="uib_util_header" />
	</xsl:template>

	<xsl:template name="uib_util_header">

		<!-- BEGIN : OUTPUT -->
		<xsl:text disable-output-escaping="yes">
<![CDATA[
/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/

#ifndef UIB_UTIL_H_
#define UIB_UTIL_H_

#include "g_inc_uib.h"
#include "uib_views.h"

#ifdef ENABLE_UIB_DELOG
	#define UIB_DLOG(log_type, log_tag, fmt,...) dlog_print(log_type, log_tag, fmt, ##__VA_ARGS__)
#else
	#define UIB_DLOG(log_type, log_tag, fmt,...)
#endif /* ENABLE_FILE_LOG_TRACE */

#ifdef  LOG_TAG
#undef  LOG_TAG
#endif
//#define LOG_TAG APP_NAME
#define LOG_TAG "UIB_APP"
]]></xsl:text>

		<xsl:choose>
			<xsl:when test="$is_version_rm_support='true'">
				<xsl:text><![CDATA[
typedef app_resource_e _APP_RESOURCE_E; // RM]]></xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text><![CDATA[
typedef int _APP_RESOURCE_E;  // RM]]></xsl:text>
			</xsl:otherwise>
		</xsl:choose>

		<xsl:text><![CDATA[
typedef enum {
	e_rotation_unknown=-1,
	e_rotation_default,
	e_rotation_fullSensor = e_rotation_default,
	e_rotation_noSensor,
	e_rotation_onlyPortrait,
	e_rotation_onlyLandscape,
	e_rotation_max_num,
} rotation_e;

typedef enum {
	e_resolution_unknown=-1,]]></xsl:text>
		<xsl:choose>
			<xsl:when test="$profile='mobile'">
				<xsl:text><![CDATA[
	e_resolution_WVGA,
	e_resolution_qHD,
	e_resolution_HD,]]></xsl:text>
			</xsl:when>
			<xsl:when test="$profile='wearable'">
				<xsl:text><![CDATA[
	e_resolution_SQUARE_320x320,
	e_resolution_SQUARE_360x480,]]></xsl:text>
			</xsl:when>
			<xsl:when test="$profile='wearable-circle'">
				<xsl:text><![CDATA[
	e_resolution_CIRCLE_360x360,]]></xsl:text>
			</xsl:when>
			<xsl:when test="$profile='tv'">
				<xsl:text><![CDATA[
	e_resolution_HD,
	e_resolution_FHD,]]></xsl:text>
			</xsl:when>
		</xsl:choose>
		<xsl:text><![CDATA[
	e_resolution_max_num,
} resolution_e;

typedef enum {
	e_orient_unknown=-1,
	e_orientation_default,
	e_orientation_port=e_orientation_default,
	e_orientation_land,
	e_orientation_max_num,
} orientation_e;

typedef enum {
	e_ctxpopup_position_unknown=-1,
	e_ctxpopup_position_default,
	e_ctxpopup_position_user_input,
} ctxpopup_position_e;

#define DEF_SENSOR_ARRAY_ONLY_PORT		{ 0, 180 }
#define DEF_SENSOR_ARRAY_ONLY_LAND		{ 90, 270 }
#define DEF_SENSOR_ARRAY_FULL					{ 0, 90, 180, 270 }
#define DEF_SENSOR_ARRAY_NO					{ 0 }

typedef struct {
	int w;
	int h;
	int dpi;
	char profile_name[128];
	double base_scale;
	resolution_e resolution_type;
} uib_device_info_st;

#define DEF_UIB_ORIENT_TYPE(e_orientation) ((e_orientation==APP_DEVICE_ORIENTATION_0||e_orientation==APP_DEVICE_ORIENTATION_180)? e_orientation_port:e_orientation_land)

void uib_util_rotation_set(Evas_Object *win, rotation_e e_rotation_type);

resolution_e uib_util_get_resolution_type(int w, int h);
int uib_util_get_device_info(uib_device_info_st* uib_device_info);
Elm_Object_Item* uib_util_push_view(char *view_name);
uib_popup_context* uib_create_popup(char *popup_name);
uib_popup_context* uib_create_ctxpopup(char *popup_name, ctxpopup_position_e position, Evas_Object *obj, Evas_Coord input_x, Evas_Coord input_y);
char* uib_util_get_current_config_name();

void uib_util_widget_hide_on_grid(Evas_Object* grid_evas_obj, Evas_Object* evas_sub_obj);

/**
 * @brief Gets the localized translation for the specified string.
 *
 * @details If a translation is not found in the localization file(.po file), @a message is returned.
 *
 * @since_tizen @if MOBILE 2.3 @elseif WEARABLE 2.3.1 @endif
 * @remarks Do not free the returned value.
 *
 * @param[in] message The string to be translated
 * @return  The localized translation for the given @a message on success,
 *          otherwise the given @a message
 */
char* uib_util_rm_get_locale_string(char* src_string);
#define _UIB_LOCALE(msg) uib_util_rm_get_locale_string(msg)

/**
 * @brief Convert resource ID to path name
 *
 * @remarks If resource manager is not created yet,
 *			app_resource_manager_init() will be invoked automatically.
 *			Caller should free the returned pointer.
 * @param[in] type Resource type @see app_resource_e
 * @param[in] id Resource ID
 * @param[out] path The name of requested resource on success, otherwise NULL
 * @return @c 0 on success,
 *         otherwise a negative error value
 * @retval #APP_RESOURCE_ERROR_NONE Successful
 * @retval #APP_RESOURCE_ERROR_INVALID_PARAMETER Invalid Parameter
 * @retval #APP_RESOURCE_ERROR_OUT_OF_MEMORY Out of memory
 * @retval #APP_RESOURCE_ERROR_IO_ERROR Internal I/O Error or failed to find valid resource
 * @see	app_resource_manager_init()
 */
int uib_util_rm_get_resource_path(_APP_RESOURCE_E e_resource_type, const char* resource_path_in, char** resource_path_out);
]]></xsl:text>
		<xsl:if test="$profile='tv'">
			<xsl:value-of select="concat($newline, 'void uib_util_win_alpha_set(Evas_Object *data, Eina_Bool enabled);')" />
		</xsl:if>
		<xsl:text><![CDATA[

#endif /* UIB_UTIL_H_ */
]]></xsl:text>


		<!-- END : OUTPUT -->
	</xsl:template>
</xsl:stylesheet>
