<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:template match="/">
		<!-- Apply following template only once if contacts type datasource is found -->
		<xsl:variable name="remote_datasource_count"
			select="count(//dataBinding//dataSource[@modelType='remote'])" />
		<xsl:if test="$remote_datasource_count>0">
			<xsl:apply-templates select="//dataBinding" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="dataBinding">

		<xsl:text disable-output-escaping="yes">
<![CDATA[
/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/

#ifndef MANAGED_INC_UIB_DATASOURCE_REMOTE_H_
#define MANAGED_INC_UIB_DATASOURCE_REMOTE_H_

#include <curl/curl.h>
#include "uib_datasources.h"


#define BUFFER_SIZE 1024
#define MAX_ALLOWED_SOURCES 20

typedef struct {
    Ecore_Thread *thread;
    CURL *curl;
    char url[BUFFER_SIZE];
    double curl_filesize;
    char filesize_buffer[BUFFER_SIZE];

    Eina_Lock mutex;
    bool downloading;
    bool cancel_requested;
    bool global_cleanup_needed;
    bool cleanup_done;
    bool exiting;
    bool thread_running;

    char filename[BUFFER_SIZE];
    char filename_without_path[BUFFER_SIZE];
    FILE *stream;
    char *response_data;
    char *prev_response_data;
    int internal_storage_id;

    int polling_interval;
    long timeout_ms;
    char *source_name;
    int registry_id;
    Ecore_Poller *poller;
    UIB_DATASOURCE_CONTENT_TYPE content_type;
} remote_ds_s;

uib_datasource_interface* uib_remote_datasource_get_instance();
void set_remote_datasource(remote_ds_s *);

#endif
]]>
</xsl:text>

	</xsl:template>
</xsl:stylesheet>
