<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:param name="datamodel_id"></xsl:param>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:template match="/">
		<!-- Ignore empty datamodels or datamodels tied to empty datasource -->
		<xsl:if
			test="//dataBinding//dataModel[@modelName=$datamodel_id][@dataSource != ''][@modelType != 'Empty']">
			<xsl:apply-templates
				select="//dataBinding//dataModel[@modelName=$datamodel_id]" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="dataModel">
		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/
]]>
</xsl:text>

		<xsl:variable name="smallcase" select="'abcdefghijklmnopqrstuvwxyz'" />
		<xsl:variable name="uppercase" select="'ABCDEFGHIJKLMNOPQRSTUVWXYZ'" />
		<xsl:variable name="capital_datamodel_id"
			select="translate( $datamodel_id, $smallcase, $uppercase)" />
		<xsl:value-of
			select="concat('#ifndef MANAGED_INC_DATABINDING_UIB_',$capital_datamodel_id,'_DATAMODEL_H_',$newline,'#define MANAGED_INC_DATABINDING_UIB_',$capital_datamodel_id,'_DATAMODEL_H_',$newline)" />

		<xsl:text disable-output-escaping="yes">
<![CDATA[#include "uib_datamodels.h"
#include "uib_datasources.h"
]]>
</xsl:text>
		<xsl:value-of
			select="concat('uib_datamodel_context* get_',$datamodel_id,'_datamodel_context();',$newline )" />
		<xsl:value-of
			select="concat('void cleanup_',$datamodel_id,'_datamodel();',$newline )" />
		<xsl:text disable-output-escaping="yes">
<![CDATA[
#endif
]]>
</xsl:text>

	</xsl:template>
</xsl:stylesheet>
