/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.model.descriptors;

import java.util.ArrayList;
import java.util.List;
import org.tizen.efluibuilder.model.descriptors.DescriptorManager;
import org.tizen.efluibuilder.model.descriptors.PropertyConditionDescriptor;
import org.tizen.efluibuilder.model.descriptors.TypeDescriptor;

public class PropertyDescriptor {
    private static final int UNUSED_EDITORS_PROPERTIES = 1;
    private static final int UNUSED_EDITORS_SOURCE_TAB = 2;
    private String name;
    private String type;
    private String displayName;
    private String tooltip;
    private String defaultValue;
    private String initValue;
    private String category;
    private String xpath;
    private String attrXpath;
    private String inline;
    private int unusedEditors;
    private TypeDescriptor typeDescriptor;
    private List<PropertyConditionDescriptor> conditions = new ArrayList<PropertyConditionDescriptor>();
    private List<PropertyDescriptor> childProperties = new ArrayList<PropertyDescriptor>();
    private DescriptorManager manager;

    public PropertyDescriptor(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, TypeDescriptor typeDescriptor) {
        this.name = string;
        this.type = string2;
        this.displayName = string3;
        this.tooltip = string4;
        this.defaultValue = string5;
        this.initValue = string6;
        this.category = string7;
        this.xpath = string8;
        this.attrXpath = string9;
        this.inline = string10;
        this.unusedEditors = this.convertToBit(string11);
        this.typeDescriptor = typeDescriptor;
    }

    private int convertToBit(String string) {
        int n = 0;
        if (string == null) {
            return n;
        }
        String[] stringArray = null;
        stringArray = !string.contains("|") ? new String[]{string} : string.split("\\|");
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string2 = stringArray[n2].trim();
            if (string2.equals(UnusedEditors.PROPERTIES.getString())) {
                n |= UnusedEditors.PROPERTIES.getBit();
            } else if (string2.equals(UnusedEditors.SOURCE_TAB.getString())) {
                n |= UnusedEditors.SOURCE_TAB.getBit();
            }
            ++n2;
        }
        return n;
    }

    public void addConditionDescriptor(PropertyConditionDescriptor propertyConditionDescriptor) {
        this.conditions.add(propertyConditionDescriptor);
    }

    public void addChildPropertyDescriptor(PropertyDescriptor propertyDescriptor) {
        this.childProperties.add(propertyDescriptor);
    }

    public String getPropertyName() {
        return this.name;
    }

    public String getPropertyType() {
        return this.type;
    }

    public String getInlineValue() {
        return this.inline;
    }

    private int getUnusedEditors() {
        return this.unusedEditors;
    }

    public TypeDescriptor getTypeDescriptor() {
        return this.typeDescriptor;
    }

    public String getPropertyDisplayName() {
        return this.displayName;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getInitValue() {
        return this.initValue;
    }

    public String getCategory() {
        return this.category;
    }

    public String getXpath() {
        return this.xpath;
    }

    public String getAttrXpath() {
        return this.attrXpath;
    }

    public List<PropertyConditionDescriptor> getConditionDescriptors() {
        return this.conditions;
    }

    public List<PropertyDescriptor> getChildPropertyDescriptors() {
        return this.childProperties;
    }

    public PropertyDescriptor getChildPropertyDescriptor(String string) {
        for (PropertyDescriptor propertyDescriptor : this.childProperties) {
            String string2 = propertyDescriptor.getPropertyName();
            if (string2 == null || !string2.equals(string)) continue;
            return propertyDescriptor;
        }
        return null;
    }

    public DescriptorManager getDescriptorManager() {
        return this.manager;
    }

    public void setDefaultValue(String string) {
        this.defaultValue = string;
    }

    public boolean checkUnusedEditors(UnusedEditors unusedEditors) {
        int n = this.getUnusedEditors();
        if (n == 0) {
            return false;
        }
        return (n & unusedEditors.getBit()) > 0;
    }

    public static enum UnusedEditors {
        PROPERTIES("properties", 1),
        SOURCE_TAB("source_tab", 2);

        private String editor;
        private int bit;

        private UnusedEditors(String string2, int n2) {
            this.editor = string2;
            this.bit = n2;
        }

        public String getString() {
            return this.editor;
        }

        public int getBit() {
            return this.bit;
        }
    }
}

