/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.projectmigrator.ui.wizards.pages;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.ui.color.TizenColors;
import org.tizen.common.ui.font.TizenFonts;
import org.tizen.common.util.DialogUtil;
import org.tizen.efluibuilder.projectmigrator.codewriter.ASTManager;
import org.tizen.efluibuilder.projectmigrator.codewriter.CodeWriterException;
import org.tizen.efluibuilder.projectmigrator.codewriter.visitor.MethodCheckVisitor;
import org.tizen.efluibuilder.projectmigrator.ui.message.Messages;
import org.tizen.efluibuilder.projectmigrator.ui.wizards.ProjectMigratorWizard;
import org.tizen.efluibuilder.projectmigrator.ui.wizards.pages.BaseWizardPage;
import org.tizen.efluibuilder.projectmigrator.util.FileUtil;
import org.tizen.efluibuilder.projectmigrator.util.StringUtil;
import org.tizen.efluibuilder.projectmigrator.util.UIUtil;
import org.tizen.efluibuilder.ui.resources.ImageResources;

public class AppEntryPage
extends BaseWizardPage {
    private Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private Button radioUIB;
    private Button radioLegacy;
    private Label imageLabel;
    private Text textFilePath;
    private Button btnBrowse;
    private String appEntryFileName = null;
    private static Map<String, String> mainParam = AppEntryPage.createMainParamMap();
    private SelectionListener radioUIBListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            AppEntryPage.this.radioUIB.setSelection(true);
            AppEntryPage.this.radioLegacy.setSelection(false);
            AppEntryPage.this.imageLabel.setImage(ImageResources.getImage((String)"res/icons/uibconverter/wizard_page_app_entry/code_uib.png"));
            AppEntryPage.this.imageLabel.pack();
            super.widgetSelected(selectionEvent);
        }
    };
    private SelectionListener radioLegacyListener = new SelectionAdapter(){

        public void widgetSelected(SelectionEvent selectionEvent) {
            AppEntryPage.this.radioLegacy.setSelection(true);
            AppEntryPage.this.radioUIB.setSelection(false);
            AppEntryPage.this.imageLabel.setImage(ImageResources.getImage((String)"res/icons/uibconverter/wizard_page_app_entry/code_legacy.png"));
            AppEntryPage.this.imageLabel.pack();
            super.widgetSelected(selectionEvent);
        }
    };

    private static Map<String, String> createMainParamMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("argc", "int");
        hashMap.put("*argv[]", "char");
        return Collections.unmodifiableMap(hashMap);
    }

    public AppEntryPage(String string) {
        super(string);
        this.setDescription(Messages.PAGE_APPENTRY_DESC);
    }

    public void createControl(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout());
        this.createBodyComposite(composite2);
        this.setControl((Control)composite2);
        this.setPageComplete(false);
    }

    private void createBodyComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new FormLayout());
        composite2.setLayoutData((Object)new GridData(768));
        int n = this.createFileBrowserComposite(composite2, 0);
        this.createSelectComposite(composite2, n);
    }

    private int createFileBrowserComposite(Composite composite, int n) {
        Label label = new Label(composite, 0);
        FormData formData = UIUtil.createFormData(new FormAttachment(0, 63), new FormAttachment(100, -63), new FormAttachment(0, n += 15));
        label.setLayoutData((Object)formData);
        label.setBackground(TizenColors.getTizenLightGrey());
        label.setText(Messages.PAGE_APPENTRY_MSG_LABEL_BROWSE);
        label.setFont(TizenFonts.getBoldFont());
        n += 13;
        Composite composite2 = new Composite(composite, 0);
        FormData formData2 = UIUtil.createFormData(new FormAttachment(0, 63), new FormAttachment(100, -63), new FormAttachment(0, n += 15));
        composite2.setLayoutData((Object)formData2);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 9;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 9;
        composite2.setLayout((Layout)gridLayout);
        this.textFilePath = new Text(composite2, 2048);
        GridData gridData = new GridData(768);
        this.textFilePath.setLayoutData((Object)gridData);
        this.textFilePath.setMessage(Messages.PAGE_APPENTRY_MSG_TEXT_DEFAULT_MSG);
        this.textFilePath.setEnabled(false);
        gridData = new GridData();
        gridData.widthHint = 100;
        this.btnBrowse = UIUtil.createButtonWithGridLayout(composite2, Messages.PAGE_APPENTRY_MSG_BTN_BROWSE, gridData, 8, true, false, false);
        final String string = ((ProjectMigratorWizard)this.getWizard()).getProject().getLocation().toOSString();
        this.btnBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                FileDialog fileDialog = new FileDialog(AppEntryPage.this.getShell(), 4096);
                fileDialog.setFilterExtensions(new String[]{Messages.PAGE_APPENTRY_MSG_FILTER_EXTENSION});
                fileDialog.setFilterPath(string);
                fileDialog.setText(Messages.PAGE_APPENTRY_MSG_FILE_DLG_TITLE);
                String string2 = fileDialog.open();
                if (!StringUtil.isNullorEmpty(string2)) {
                    if (!string2.startsWith(string)) {
                        DialogUtil.openErrorDialog((String)Messages.WIZARD_TITLE_CONVERTER, (String)Messages.PAGE_APPENTRY_MSG_INVALID_SRC);
                        return;
                    }
                    if (AppEntryPage.this.isExistAppEntryWithCoreVisit(string2 = string2.substring(string.length() + 1))) {
                        AppEntryPage.this.appEntryFileName = string2;
                        AppEntryPage.this.textFilePath.setText(string2);
                        AppEntryPage.this.setPageComplete(true);
                    } else {
                        DialogUtil.openErrorDialog((String)Messages.WIZARD_TITLE_CONVERTER, (String)Messages.CORE_EXCEPTION_MSG_CANNOT_FIND_APP_ENTRY);
                    }
                }
            }
        });
        n += 37;
        return n += 30;
    }

    private void createSelectComposite(Composite composite, int n) {
        FormData formData = UIUtil.createFormData(new FormAttachment(0, 63), new FormAttachment(100, -63), new FormAttachment(0, n));
        Label label = new Label(composite, 0);
        label.setLayoutData((Object)formData);
        label.setBackground(TizenColors.getTizenLightGrey());
        label.setText(Messages.PAGE_APPENTRY_MSG_LABEL_SELECT);
        label.setFont(TizenFonts.getBoldFont());
        n += 13;
        n += 15;
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        gridLayout.verticalSpacing = 0;
        gridLayout.horizontalSpacing = 0;
        composite2.setLayout((Layout)gridLayout);
        formData = UIUtil.createFormData(new FormAttachment(0, 109), new FormAttachment(100, -109), new FormAttachment(0, n));
        composite2.setLayoutData((Object)formData);
        GridData gridData = UIUtil.createGridData(768, 1, 0x1000000, -1);
        this.radioUIB = UIUtil.createButtonWithGridLayout(composite2, Messages.PAGE_APPENTRY_MSG_UIB, gridData, 16, true, false, false);
        this.radioUIB.addSelectionListener(this.radioUIBListener);
        GridData gridData2 = UIUtil.createGridData(768, 1, 0x1000000, -1);
        this.radioLegacy = UIUtil.createButtonWithGridLayout(composite2, Messages.PAGE_APPENTRY_MSG_LEGACY, gridData2, 16, true, false, false);
        this.radioLegacy.addSelectionListener(this.radioLegacyListener);
        this.createImageComposite(composite, n += 28);
    }

    private void createImageComposite(Composite composite, int n) {
        FormData formData = UIUtil.createFormData(new FormAttachment(0, 80), new FormAttachment(100, -80), new FormAttachment(0, n));
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayoutData((Object)formData);
        GridLayout gridLayout = new GridLayout();
        composite2.setLayout((Layout)gridLayout);
        this.imageLabel = new Label(composite2, 0);
        GridData gridData = UIUtil.createGridData(768, 1, 0x1000000, -1);
        this.imageLabel.setLayoutData((Object)gridData);
        this.imageLabel.setBackground(TizenColors.getTizenLightGrey());
        Image image = ImageResources.getImage((String)"res/icons/uibconverter/wizard_page_app_entry/code_uib.png");
        this.imageLabel.setImage(image);
        this.imageLabel.pack();
        this.radioUIB.setSelection(true);
    }

    private boolean isExistAppEntryWithCoreVisit(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("appEntryRelativeFilePath", string);
        ProjectMigratorWizard projectMigratorWizard = (ProjectMigratorWizard)this.getWizard();
        try {
            IFile iFile = FileUtil.getFile(projectMigratorWizard.getProject(), string);
            MethodCheckVisitor methodCheckVisitor = new MethodCheckVisitor("main", 3, mainParam);
            ASTManager aSTManager = new ASTManager();
            aSTManager.visit(iFile, 7, methodCheckVisitor);
            return methodCheckVisitor.isExist();
        }
        catch (CodeWriterException codeWriterException) {
            this.logger.error(codeWriterException.getMessage());
            return false;
        }
    }

    public String getAppEntryRelativeFilePath() {
        return this.appEntryFileName;
    }

    public boolean isSelectedAppEntryUIB() {
        return this.radioUIB.getSelection();
    }
}

