/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.efluibuilder.projectmigrator;

import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.cdt.managedbuilder.core.IConfiguration;
import org.eclipse.cdt.managedbuilder.core.IManagedBuildInfo;
import org.eclipse.cdt.managedbuilder.core.ManagedBuildManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.application.InstallPathConfig;
import org.tizen.common.util.DialogUtil;
import org.tizen.efluibuilder.projectmigrator.IProjectMigrator;
import org.tizen.efluibuilder.projectmigrator.ProjectConvertParam;
import org.tizen.efluibuilder.projectmigrator.ProjectMigratorException;
import org.tizen.efluibuilder.projectmigrator.ProjectMigratorUtil;
import org.tizen.efluibuilder.projectmigrator.codewriter.ASTManager;
import org.tizen.efluibuilder.projectmigrator.codewriter.CodeWriterConstants;
import org.tizen.efluibuilder.projectmigrator.codewriter.CodeWriterException;
import org.tizen.efluibuilder.projectmigrator.codewriter.UserViewGenerator;
import org.tizen.efluibuilder.projectmigrator.codewriter.visitor.MethodCheckVisitor;
import org.tizen.efluibuilder.projectmigrator.codewriter.visitor.NUIBAppEntryAddVisitor;
import org.tizen.efluibuilder.projectmigrator.codewriter.visitor.UserViewAddVisitor;
import org.tizen.efluibuilder.projectmigrator.codewriter.visitor.UserViewRemoveVisitor;
import org.tizen.efluibuilder.projectmigrator.ui.message.Messages;
import org.tizen.efluibuilder.projectmigrator.util.FileUtil;
import org.tizen.efluibuilder.projectmigrator.util.StringUtil;
import org.tizen.efluibuilder.utility.PlatformUtil;
import org.tizen.nativecommon.build.CommonConfigurationManager;

public class ProjectMigrator
implements IProjectMigrator {
    private IProject project;
    private boolean isProjectCloned = false;
    private ASTManager astManager;
    private static Map<String, String> copyTargetFileMap = ProjectMigrator.createCopyTargetFileMap();
    private static Map<String, String> mainParam = ProjectMigrator.createMainParamMap();
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    private static Map<String, String> createCopyTargetFileMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("/project/inc/app_main.h", "inc/app_main.h");
        hashMap.put("/project/src/app_main.c", "src/app_main.c");
        hashMap.put("/project/layout/layout.xml", "layout/layout.xml");
        hashMap.put("/project/.uproject", ".uproject");
        return Collections.unmodifiableMap(hashMap);
    }

    private static Map<String, String> createMainParamMap() {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("argc", "int");
        hashMap.put("*argv[]", "char");
        return Collections.unmodifiableMap(hashMap);
    }

    public ProjectMigrator(IProject iProject) {
        this.project = iProject;
    }

    public synchronized ASTManager getASTManager() {
        if (this.astManager == null) {
            this.astManager = new ASTManager();
        }
        return this.astManager;
    }

    public void setASTManager(ASTManager aSTManager) {
        this.astManager = aSTManager;
    }

    @Override
    public void convertToUIB(ProjectConvertParam projectConvertParam, IProgressMonitor iProgressMonitor) {
        try {
            if (!this.isExistAppEntry(projectConvertParam.getAppEntryRelativeFilePath())) {
                return;
            }
            iProgressMonitor.beginTask(Messages.PROGRESS_MSG_CONVERT_BEGINTASK, 1000000);
            if (!this.cloneProject(projectConvertParam.getCloneProjectName(), iProgressMonitor)) {
                return;
            }
            if (!this.createLayoutFolder(this.project, iProgressMonitor)) {
                return;
            }
            if (!this.copyRelatedFiles(this.project, this.getBaseTemplatePath(ProjectMigratorUtil.getPlatformProfile(this.project), ProjectMigratorUtil.getPlatformVersion(this.project), projectConvertParam.isShapeCircle()), iProgressMonitor)) {
                return;
            }
            if (!this.appendIncludePath(this.project, iProgressMonitor)) {
                return;
            }
            if (!this.addNUIBAppEntry(this.project, projectConvertParam.isUIBAppEntry(), projectConvertParam.getAppEntryRelativeFilePath(), iProgressMonitor)) {
                return;
            }
            if (!this.addUserViews(projectConvertParam.getUserViews(), null, projectConvertParam.getStartupViewName(), iProgressMonitor)) {
                return;
            }
        }
        catch (ProjectMigratorException | CodeWriterException exception) {
            this.logger.error(exception.getMessage());
            this.logger.error(StringUtil.getStackTraceToString(exception));
            try {
                if (this.isProjectCloned) {
                    FileUtil.deleteProject(this.project);
                }
            }
            catch (CoreException coreException) {
                this.logger.error("Failed to delete %s project by Exception", (Object)this.project.getName());
            }
            DialogUtil.openErrorDialog((String)Messages.WIZARD_TITLE_CONVERTER, (String)exception.getMessage());
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private void doProcessUserViews(List<String> list, List<String> list2, String string, int n, IProgressMonitor iProgressMonitor) throws ProjectMigratorException, CodeWriterException {
        int n2 = n / 2;
        int n3 = n;
        iProgressMonitor.subTask(Messages.bind((String)Messages.PROGRESS_MSG_SUBTASK_DO_PROCESS_USER_VIEW_FILE, (Object)""));
        IFile iFile = FileUtil.getFile(this.project, CodeWriterConstants.SRC_PATH, "app_main.c");
        UserViewRemoveVisitor userViewRemoveVisitor = new UserViewRemoveVisitor(list, string);
        this.getASTManager().visit(iFile, 6, userViewRemoveVisitor);
        UserViewAddVisitor userViewAddVisitor = new UserViewAddVisitor(list, string);
        this.getASTManager().visit(iFile, 6, userViewAddVisitor);
        try {
            FileUtil.createFolder(this.project, CodeWriterConstants.USER_VIEW_PATH);
        }
        catch (CoreException coreException) {
            this.logger.error(coreException.getMessage());
            throw new ProjectMigratorException(Messages.bind((String)Messages.CORE_EXCEPTION_MSG_CREATE_FOLDER, (Object)CodeWriterConstants.USER_VIEW_PATH));
        }
        UserViewGenerator userViewGenerator = new UserViewGenerator(this.project);
        userViewGenerator.addUserViewFile(list, n2, iProgressMonitor);
        n3 -= n2;
        userViewGenerator.deleteUserviewFile(list2, n2, iProgressMonitor);
        iProgressMonitor.worked(n3 -= n2);
    }

    private boolean addUserViews(List<String> list, List<String> list2, String string, IProgressMonitor iProgressMonitor) throws ProjectMigratorException, CodeWriterException {
        int n = 400000;
        this.doProcessUserViews(list, list2, string, n, iProgressMonitor);
        if (iProgressMonitor.isCanceled()) {
            this.recoveryProject(iProgressMonitor);
            return false;
        }
        return true;
    }

    @Override
    public void updateUserViews(List<String> list, List<String> list2, String string, IProgressMonitor iProgressMonitor) {
        int n = 1000000;
        iProgressMonitor.beginTask(Messages.PROGRESS_MSG_UPDATE_USER_VIEW_BEGINTASK, n);
        try {
            try {
                this.doProcessUserViews(list, list2, string, n, iProgressMonitor);
            }
            catch (ProjectMigratorException | CodeWriterException exception) {
                this.logger.error(exception.getMessage());
                this.logger.error(StringUtil.getStackTraceToString(exception));
                DialogUtil.openErrorDialog((String)Messages.WIZARD_TITLE_USER_VIEW, (String)exception.getMessage());
                iProgressMonitor.done();
            }
        }
        finally {
            iProgressMonitor.done();
        }
    }

    private boolean isExistAppEntry(String string) throws CodeWriterException, ProjectMigratorException {
        if (string == null) {
            throw new ProjectMigratorException(Messages.CORE_EXCEPTION_MSG_PRE_VALIDATION_NO_FILE_SELECTED);
        }
        IFile iFile = FileUtil.getFile(this.project, string);
        MethodCheckVisitor methodCheckVisitor = new MethodCheckVisitor("main", 3, mainParam);
        this.getASTManager().visit(iFile, 7, methodCheckVisitor);
        boolean bl = methodCheckVisitor.isExist();
        if (!bl) {
            throw new ProjectMigratorException(Messages.bind((String)Messages.CORE_EXCEPTION_MSG_CANNOT_FIND_APP_ENTRY, (Object)string));
        }
        return bl;
    }

    private void recoveryProject(IProgressMonitor iProgressMonitor) throws ProjectMigratorException {
        String string = this.project.getName();
        iProgressMonitor.subTask(Messages.bind((String)Messages.PROGRESS_MSG_SUBTASK_RECORVERY, (Object)string));
        try {
            FileUtil.deleteProject(this.project);
            this.logger.debug("The %s project was canceld", (Object)string);
        }
        catch (CoreException coreException) {
            this.logger.error(coreException.getMessage());
            throw new ProjectMigratorException(Messages.CORE_EXCEPTION_MSG_CANNOT_FIND_APP_ENTRY);
        }
        iProgressMonitor.worked(5);
    }

    private boolean createLayoutFolder(IProject iProject, IProgressMonitor iProgressMonitor) throws ProjectMigratorException {
        iProgressMonitor.subTask(Messages.PROGRESS_MSG_SUBTASK_CREATE_LAYOUT_FOLADER);
        try {
            FileUtil.createFolder(iProject, "layout");
        }
        catch (CoreException coreException) {
            this.logger.error(coreException.getMessage());
            throw new ProjectMigratorException(Messages.bind((String)Messages.CORE_EXCEPTION_MSG_CREATE_FOLDER, (Object)iProject.getName()));
        }
        if (iProgressMonitor.isCanceled()) {
            this.recoveryProject(iProgressMonitor);
            return false;
        }
        iProgressMonitor.worked(50000);
        return true;
    }

    private boolean addNUIBAppEntry(IProject iProject, boolean bl, String string, IProgressMonitor iProgressMonitor) throws CodeWriterException, ProjectMigratorException {
        iProgressMonitor.subTask(Messages.PROGRESS_MSG_SUBTASK_SET_APP_ENTRY);
        IFile iFile = FileUtil.getFile(iProject, string);
        NUIBAppEntryAddVisitor nUIBAppEntryAddVisitor = new NUIBAppEntryAddVisitor("main", 3, mainParam, bl);
        this.getASTManager().visit(iFile, 6, nUIBAppEntryAddVisitor);
        this.getASTManager().appendInclude(iFile, "app_main.h");
        if (iProgressMonitor.isCanceled()) {
            this.recoveryProject(iProgressMonitor);
            return false;
        }
        iProgressMonitor.worked(150000);
        return true;
    }

    private boolean cloneProject(String string, IProgressMonitor iProgressMonitor) throws ProjectMigratorException {
        String string2 = this.project.getName();
        iProgressMonitor.subTask(Messages.bind((String)Messages.PROGRESS_MSG_SUBTASK_CLONE_CUR_PROJECT, (Object)string2));
        try {
            this.project = FileUtil.cloneProject(string2, string);
            this.isProjectCloned = true;
        }
        catch (CoreException coreException) {
            this.logger.error(coreException.getMessage());
            throw new ProjectMigratorException(Messages.bind((String)Messages.CORE_EXCEPTION_MSG_CLONE_PROJECT, (Object)string2));
        }
        if (iProgressMonitor.isCanceled()) {
            this.recoveryProject(iProgressMonitor);
            return false;
        }
        iProgressMonitor.worked(150000);
        return true;
    }

    private boolean appendIncludePath(IProject iProject, IProgressMonitor iProgressMonitor) throws ProjectMigratorException {
        iProgressMonitor.subTask(Messages.PROGRESS_MSG_SUBTASK_ADD_INCLUDE_PATH);
        IManagedBuildInfo iManagedBuildInfo = ManagedBuildManager.getBuildInfo((IResource)iProject);
        if (iManagedBuildInfo != null) {
            IConfiguration iConfiguration = iManagedBuildInfo.getDefaultConfiguration();
            IConfiguration[] iConfigurationArray = iConfiguration.getManagedProject().getConfigurations();
            int n = iConfigurationArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfiguration iConfiguration2 = iConfigurationArray[n2];
                CommonConfigurationManager.appendIncludePathToCompiler((IConfiguration)iConfiguration2, (String)"\"${workspace_loc:/${ProjName}/src/managed/inc}\"");
                ++n2;
            }
        }
        ManagedBuildManager.saveBuildInfo((IProject)iProject, (boolean)true);
        if (iProgressMonitor.isCanceled()) {
            this.recoveryProject(iProgressMonitor);
            return false;
        }
        iProgressMonitor.worked(50000);
        return true;
    }

    private String getBaseTemplatePath(String string, String string2, boolean bl) {
        String string3 = InstallPathConfig.getSDKPath();
        string3 = String.valueOf(string3) + "/platforms/tizen-" + string2 + "/" + string;
        string3 = "wearable".equals(string) ? (bl ? String.valueOf(string3) + "/samples/Template/Native/uib-single-view-circle" : String.valueOf(string3) + "/samples/Template/Native/uib-single-view") : String.valueOf(string3) + "/samples/Template/Native/uib-single-view";
        return string3;
    }

    private boolean copyRelatedFiles(IProject iProject, String string, IProgressMonitor iProgressMonitor) throws ProjectMigratorException {
        iProgressMonitor.subTask(Messages.CORE_EXCEPTION_MSG_COPY_RELATED_FILES);
        try {
            for (String string2 : copyTargetFileMap.keySet()) {
                this.copyFilesToProject(iProject, String.valueOf(string) + string2, copyTargetFileMap.get(string2));
            }
        }
        catch (IOException iOException) {
            throw new ProjectMigratorException(Messages.CORE_EXCEPTION_MSG_COPY_RELATED_FILES);
        }
        catch (CoreException coreException) {
            throw new ProjectMigratorException(Messages.CORE_EXCEPTION_MSG_COPY_RELATED_FILES);
        }
        if (iProgressMonitor.isCanceled()) {
            this.recoveryProject(iProgressMonitor);
            return false;
        }
        iProgressMonitor.worked(150000);
        return true;
    }

    private void copyFilesToProject(IProject iProject, String string, String string2) throws IOException, CoreException {
        String string3 = PlatformUtil.getCorrectedPath((String)string);
        IFile iFile = iProject.getFile(string2);
        if (iFile.exists()) {
            return;
        }
        String string4 = iFile.getLocation().toOSString();
        Files.copy(Paths.get(string3, new String[0]), Paths.get(string4, new String[0]), new CopyOption[0]);
        iFile.refreshLocal(1, null);
    }
}

