<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:template match="/">
		<xsl:variable name="databinding_children_count" select="count(//dataBinding//*)" />
		<xsl:if test="$databinding_children_count>0">
			<xsl:apply-templates select="//dataBinding" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="dataBinding">

		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/

#ifndef MANAGED_INC_UIB_DATABINDING_COMMON_H_
#define MANAGED_INC_UIB_DATABINDING_COMMON_H_

#include "g_inc_uib.h"
#include "stdlib.h"
#include "dlog.h"
#include <json-glib/json-glib.h>
#include <libxml2/libxml/tree.h>

typedef enum {
	text, foreach, binding_type_end_proxy
} widget_binding_type;

typedef enum {
	uib_label,
	uib_list,
	uib_hoversel,
	uib_hoverselitem,
	uib_genlist,
	uib_button,
	uib_checkbox,
	uib_listitem,
	uib_radio,
	uib_flipselector,
	uib_flipselectoritem,
	uib_widget_list_end_proxy
} widget_type;

typedef enum {
	UIB_XML, UIB_JSON
} UIB_DATASOURCE_CONTENT_TYPE;

typedef void (*Databinding_callback)(Evas_Object* widget,
		char* binding_element_path, widget_binding_type binding_type,
		void** root_element, UIB_DATASOURCE_CONTENT_TYPE ds_content_type);
typedef void (*SetWidgetElementValue_callback)(Evas_Object* widget,
		widget_binding_type binding_type, char* value_data);

typedef struct {
	bool is_init;
	Databinding_callback binding_cb;
} widget_handler_st;

char* get_json_data_from_builder(JsonBuilder*);
char* get_json_data_from_node(JsonNode*);
char* trim_quotes(char*);
bool data_contacts_common_disconnect();
bool data_contacts_common_connect();
char* get_xml_data_from_node(xmlDocPtr);
xmlDocPtr convert_json_to_xml(JsonNode*);

/**
 *
 * @brief Bind data value to specified widget based on
 *
 * @remark
 *
 * @param[in] widget The widget on which databinding will be performed
 * @param[in] binding_element_path The JSON path to extract data element(s) from JSON tree
 * @param[in] binding_type The type of binding to be performed performed
 * @param[in] root_element The root node of JSON from where data needs to be extracted
 * @param[in] pre_db_cb The callback of type Databinding_callback to be called before value is set on widget. Can be used to reset or preserve old values
 * @param[in] databind_cb The callback of SetWidgetElementValue_callback type to be used for setting data value onto widget
 * @param[in] post_db_cb The callback of type Databinding_callback to be called after value is set on widget. Can be used to render updated widget elements
 * @param[in] ds_content_type The datasource content type which calls respective parser for the attached data content
 */
void bind_data(Evas_Object* widget, char* binding_element_path,
		widget_binding_type binding_type, void** root_element,
		Databinding_callback pre_db_cb,
		SetWidgetElementValue_callback databind_cb,
		Databinding_callback post_db_cb,
		UIB_DATASOURCE_CONTENT_TYPE ds_content_type);
#endif
]]>
</xsl:text>

	</xsl:template>
</xsl:stylesheet>
