<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:template match="/">
	<xsl:variable name="datasource_count" select="count(//dataBinding//dataSource[@modelType != 'Empty'])" />
	<xsl:if test="$datasource_count>0">
		<xsl:apply-templates select="//dataBinding" />
	</xsl:if>
	</xsl:template>

	<xsl:template match="dataBinding">

		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/

#ifndef MANAGED_INC_UIB_DATASOURCES_H_
#define MANAGED_INC_UIB_DATASOURCES_H_

#include "uib_databinding_common.h"

enum UIB_DATASOURCE_TYPE {
	static_source, contacts_API, call_history_API, calendar_API, remote_API, end_datasource_type_marker
};

typedef struct {
	bool _is_init;
	enum UIB_DATASOURCE_TYPE ds_type;
	void** (*get_datasource_root_element)();
	void (*register_datasource_update_callback)(void (*)());
	void (*cleanup_datasource)();
} uib_datasource_interface;

typedef struct {
	char * name;
	uib_datasource_interface* datasource_interface;
	void** root_element;
	UIB_DATASOURCE_CONTENT_TYPE ds_content_type;
} uib_datasource_instance;

typedef struct {
	bool _is_init;
	uib_datasource_instance* (*get_datasource_instance)(const char*);
	void (*register_datasource_update_cb)(void (*)());
	uib_datasource_interface* (*get_datasource_interface_for_datasource_type)(
			enum UIB_DATASOURCE_TYPE);
	void (*free_all_datasources)();
} uib_datasource_manager_st;

uib_datasource_manager_st* uib_datasource_manager_get_instance();

#endif
]]>
</xsl:text>

	</xsl:template>
</xsl:stylesheet>
