<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:template match="/">
		<xsl:variable name="data_bind_count" select="count(//*[@data_bind != ''])" />
		<xsl:variable name="databinding_done">
			<xsl:choose>
				<xsl:when test="$data_bind_count>0">
					<xsl:value-of select="'yes'" />
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'no'" />
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$databinding_done='yes'">
			<xsl:apply-templates select="//views" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="views">

		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/

#ifndef MANAGED_INC_UIB_DB_MANAGER_H_
#define MANAGED_INC_UIB_DB_MANAGER_H_
#include <string.h>
#include "uib_views_binding.h"
#include "uib_databinding_common.h"
#include "databinding/uib_widget_handler_hoverselitem.h"
#include "databinding/uib_widget_handler_hoversel.h"
#include "databinding/uib_widget_handler_button.h"
#include "databinding/uib_widget_handler_checkbox.h"
#include "databinding/uib_widget_handler_label.h"
#include "databinding/uib_widget_handler_list.h"
#include "databinding/uib_widget_handler_listitem.h"
#include "databinding/uib_widget_handler_radio.h"
#include "uib_views.h"]]>
</xsl:text>
		<!-- #include "databinding/uib_widget_handler_hoversel.h" -->
		<xsl:call-template name="widget_handler_header_include" />
		<!-- #include "uib_view1_binding.h" -->
		<xsl:call-template name="views_binding_header_include" />
		<xsl:text disable-output-escaping="yes">
<![CDATA[typedef struct {
	bool _is_init;
	void (*perform_databinding)(uib_view_context* );
	void (*free_all_databinding_resources)();
} uib_databinding_manager_st;

uib_databinding_manager_st* uib_databinding_manager_get_instance();
#endif
]]>
</xsl:text>
	</xsl:template>
	<xsl:template name="views_binding_header_include">
		<xsl:for-each select="/document/views/view">
			<xsl:variable name="view_name" select="@id" />
			<xsl:variable name="view_data_bind_count" select="count(.//*[@data_bind != ''])" />
			<xsl:if test="$view_data_bind_count>0">
				<xsl:value-of
					select="concat('#include &quot;uib_',$view_name,'_bindings.h&quot;',$newline)" />
			</xsl:if>
		</xsl:for-each>
	</xsl:template>
	<xsl:template name="widget_handler_header_include">
			<xsl:if test="count(.//hoverselitem[@data_bind != ''])>0">
				<xsl:value-of
					select="concat('#include &quot;databinding/uib_widget_handler_hoverselitem.h&quot;',$newline)" />
			</xsl:if>
			<xsl:if test="count(.//hoversel[@data_bind != ''])>0">
				<xsl:value-of
					select="concat('#include &quot;databinding/uib_widget_handler_hoversel.h&quot;',$newline)" />
			</xsl:if>
			<xsl:if test="count(.//list[@data_bind != ''])>0">
				<xsl:value-of
					select="concat('#include &quot;databinding/uib_widget_handler_list.h&quot;',$newline)" />
			</xsl:if>
			<xsl:if test="count(.//listitem[@data_bind != ''])>0">
				<xsl:value-of
					select="concat('#include &quot;databinding/uib_widget_handler_listitem.h&quot;',$newline)" />
			</xsl:if>
			<xsl:if test="count(.//button[@data_bind != ''])>0">
				<xsl:value-of
					select="concat('#include &quot;databinding/uib_widget_handler_button.h&quot;',$newline)" />
			</xsl:if>
			<xsl:if test="count(.//check[@data_bind != ''])>0">
				<xsl:value-of
					select="concat('#include &quot;databinding/uib_widget_handler_checkbox.h&quot;',$newline)" />
			</xsl:if>
			<xsl:if test="count(.//label[@data_bind != ''])>0">
				<xsl:value-of
					select="concat('#include &quot;databinding/uib_widget_handler_label.h&quot;',$newline)" />
			</xsl:if>
			<xsl:if test="count(.//radio[@data_bind != ''])>0">
				<xsl:value-of
					select="concat('#include &quot;databinding/uib_widget_handler_radio.h&quot;',$newline)" />
			</xsl:if>
			<xsl:if test="count(.//flipselector[@data_bind != ''])>0">
				<xsl:value-of
					select="concat('#include &quot;databinding/uib_widget_handler_flipselector.h&quot;',$newline)" />
			</xsl:if>
			<xsl:if test="count(.//flipselectoritem[@data_bind != ''])>0">
				<xsl:value-of
					select="concat('#include &quot;databinding/uib_widget_handler_flipselectoritem.h&quot;',$newline)" />
			</xsl:if>
	</xsl:template>
</xsl:stylesheet>
