<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:template match="/">
		<xsl:variable name="data_bind_count" select="count(//*[@data_bind != ''])" />
<!-- 		<xsl:value-of select="concat('data_bind-count ', $data_bind_count)"/> -->
		<xsl:variable name="databinding_done">
			<xsl:choose>
				<xsl:when test="$data_bind_count>0">
					<xsl:value-of select="'yes'"></xsl:value-of>
				</xsl:when>
				<xsl:otherwise>
					<xsl:value-of select="'no'"></xsl:value-of>
				</xsl:otherwise>
			</xsl:choose>
		</xsl:variable>
		<xsl:if test="$databinding_done='yes'">
			<xsl:apply-templates select="//views" />
		</xsl:if>
	</xsl:template>

	<xsl:template match="views">
		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/


#ifndef MANAGED_INC_DATABINDING_UIB_VIEWS_BINDING_H_
#define MANAGED_INC_DATABINDING_UIB_VIEWS_BINDING_H_
#include "uib_datamodels.h"
#include "g_inc_uib.h"
#include <ctype.h>

typedef struct {

	Evas_Object* widget;
	char* widgetPropertyId;
	widget_type widgetType;
	//Dot-separated path to bound element in data model
	char* binding_element_path;
	widget_binding_type binding_type;
	uib_datamodel_context* dataModelContext;

} uib_binding_info;

typedef struct {
	bool _is_init;
	widget_binding_type (*get_binding_type)(const char* );
	void (*free_all_databindings)();
} uib_databindings_st;

uib_databindings_st* uib_databindings_get_instance();
#endif 
]]>
</xsl:text>
	</xsl:template>
</xsl:stylesheet>

