<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">

	<xsl:variable name="newline">
		<xsl:text>
</xsl:text>
	</xsl:variable>
	<xsl:variable name="tab">
		<xsl:text disable-output-escaping="yes">	</xsl:text>
	</xsl:variable>

	<xsl:param name="is_widget_project" />
	<xsl:template match="/">
		<xsl:apply-templates select="//views">
		</xsl:apply-templates>
	</xsl:template>

	<xsl:template match="views">

		<xsl:text disable-output-escaping="yes">
<![CDATA[/*******************************************************************************
* This file was generated by UI Builder.
* This file will be auto-generated each and everytime you save your project.
* Do not hand edit this file.
********************************************************************************/

#ifndef UIB_APP_MANAGER_H_
#define UIB_APP_MANAGER_H_

#include "g_inc_uib.h"
#include "uib_views.h"
#include "app_main.h"


typedef struct {
	bool _is_init;
]]></xsl:text>
		<xsl:choose>
			<xsl:when test="$is_widget_project='true'">
				<xsl:text><![CDATA[	bool (*initialize)(widget_context_h context, int w, int y);]]></xsl:text>
			</xsl:when>
			<xsl:otherwise>
				<xsl:text><![CDATA[	bool (*initialize)();]]></xsl:text>
			</xsl:otherwise>
		</xsl:choose>
		<xsl:text><![CDATA[
	void (*prepare)();
	void (*finalize)();
	const uib_device_info_st* (*get_uib_device_info)();
	int (*add_view_context)(uib_view_context*);
	uib_view_context* (*find_view_context)(char*);
	void (*free_all_view_context)();
} uib_app_manager_st;

uib_app_manager_st* uib_app_manager_get_instance();

#endif /* UIB_APP_MANAGER_H_ */
]]>
</xsl:text>

	</xsl:template>
</xsl:stylesheet>
