#!/bin/sh -xe

echo $INSTALLED_PATH > "/tmp/tizen_installed_path"
MODIFIED_INSTALLED_PATH=$(sed "s/\//\\\\\//g" "/tmp/tizen_installed_path")
rm -rf "/tmp/tizen_installed_path"

echo "================================================================================"
echo "Set prefix value of Eflete pkg config files. INSTALLED_PATH is $INSTALLED_PATH"
echo "================================================================================"
if [ -d "${INSTALLED_PATH}/tools/component-designer/lib/pkgconfig" ]; then
    cd "${INSTALLED_PATH}/tools/component-designer/lib/pkgconfig"
    for I in `ls *.pc`
    do
        sed -i /^"prefix="/d $I
        sed -i "s/^exec_prefix=/prefix=$MODIFIED_INSTALLED_PATH\/tools\/component-designer\nexec_prefix=/" $I
        sed -i /^"prefix ="/d $I
        sed -i "s/^exec_prefix =/prefix = $MODIFIED_INSTALLED_PATH\/tools\/component-designer\nexec_prefix =/" $I
    done
fi

if [ -d "${HOME}/.config/eflete" ]; then
    rm -rf "${HOME}/.config/eflete"
fi

if [ -d "${HOME}/Component_Designer" ]; then
    rm -rf "${HOME}/Component_Designer"
fi
