/*
 * Decompiled with CFR 0.152.
 */
package com.sun.glass.ui.monocle;

import com.sun.glass.ui.monocle.LinuxAbsoluteInputCapabilities;
import com.sun.glass.ui.monocle.LinuxInput;
import com.sun.glass.ui.monocle.LinuxInputDevice;
import com.sun.glass.ui.monocle.LinuxInputProcessor;
import com.sun.glass.ui.monocle.NativePlatform;
import com.sun.glass.ui.monocle.NativePlatformFactory;
import com.sun.glass.ui.monocle.SysFS;
import com.sun.glass.ui.monocle.Udev;
import com.sun.glass.ui.monocle.UdevListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

class GetEvent {
    private static Set<File> devices = new HashSet<File>();
    private static UdevListener udevListener = (string, map) -> {
        String string2 = (String)map.get("SUBSYSTEM");
        String string3 = (String)map.get("DEVPATH");
        if (string2 != null && string2.equals("input") && string3 != null) {
            System.out.format("%1$ts.%1$tL Received UEVENT:\n", new Date());
            ArrayList arrayList = new ArrayList(map.keySet());
            Collections.sort(arrayList);
            for (String string4 : arrayList) {
                System.out.format("  %s='%s'\n", string4, map.get(string4));
            }
            try {
                String string4;
                File file = new File("/sys", string3);
                string4 = (String)map.get("DEVNAME");
                if (string4 == null) {
                    return;
                }
                if (string.equals("add") || string.equals("change") && !devices.contains(file)) {
                    LinuxInputDevice linuxInputDevice = new LinuxInputDevice(new File(string4), file, map);
                    linuxInputDevice.setInputProcessor(new LinuxInputProcessor.Logger());
                    Thread thread = new Thread(linuxInputDevice);
                    thread.setName(string4.toString());
                    thread.setDaemon(true);
                    thread.start();
                    System.out.println("Added device " + string4);
                    System.out.println("  touch=" + linuxInputDevice.isTouch());
                    System.out.println("  multiTouch=" + linuxInputDevice.isMultiTouch());
                    System.out.println("  relative=" + linuxInputDevice.isRelative());
                    System.out.println("  5-way=" + linuxInputDevice.is5Way());
                    System.out.println("  fullKeyboard=" + linuxInputDevice.isFullKeyboard());
                    System.out.println("  PRODUCT=" + linuxInputDevice.getProduct());
                    for (short s = 0; s < 63; s = (short)(s + 1)) {
                        LinuxAbsoluteInputCapabilities linuxAbsoluteInputCapabilities = linuxInputDevice.getAbsoluteInputCapabilities(s);
                        if (linuxAbsoluteInputCapabilities == null) continue;
                        String string5 = LinuxInput.codeToString("EV_ABS", s);
                        System.out.format("  ABSVAL %s %d\n", string5, linuxAbsoluteInputCapabilities.getValue());
                        System.out.format("  ABSMIN %s %d\n", string5, linuxAbsoluteInputCapabilities.getMinimum());
                        System.out.format("  ABSMAX %s %d\n", string5, linuxAbsoluteInputCapabilities.getMaximum());
                        System.out.format("  ABSFUZZ %s %d\n", string5, linuxAbsoluteInputCapabilities.getFuzz());
                        System.out.format("  ABSFLAT %s %d\n", string5, linuxAbsoluteInputCapabilities.getFlat());
                        System.out.format("  ABSRES %s %d\n", string5, linuxAbsoluteInputCapabilities.getResolution());
                    }
                    devices.add(file);
                } else if (string.equals("remove")) {
                    devices.remove(string3);
                }
            }
            catch (IOException | RuntimeException exception) {
                exception.printStackTrace();
            }
        }
    };

    GetEvent() {
    }

    public static void main(String[] stringArray) throws Exception {
        NativePlatform nativePlatform = NativePlatformFactory.getNativePlatform();
        Udev.getInstance().addListener(udevListener);
        SysFS.triggerUdevNotification("input");
        new Thread(nativePlatform.getRunnableProcessor()).start();
    }
}

