/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager;

import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.RelativeFileSet;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class JreUtils {
    public static boolean shouldExclude(File file, File file2, Rule[] ruleArray) {
        if (ruleArray == null) {
            return false;
        }
        String string = file2.getAbsolutePath().toLowerCase().substring(file.getAbsolutePath().length());
        for (Rule rule : ruleArray) {
            if (!rule.match(string)) continue;
            return !rule.treatAsAccept();
        }
        return false;
    }

    public static void walk(File file, File file2, Rule[] ruleArray, Set<File> set) {
        JreUtils.walk(file, file2, ruleArray, set, false);
    }

    public static void walk(File file, File file2, Rule[] ruleArray, Set<File> set, boolean bl) {
        if (!file2.isDirectory()) {
            if (file2.isFile()) {
                set.add(file2);
            }
            return;
        }
        File[] fileArray = file2.listFiles();
        if (fileArray != null) {
            for (File file3 : fileArray) {
                if (!bl && !IOUtils.isNotSymbolicLink(file3) || JreUtils.shouldExclude(file, file3, ruleArray)) continue;
                if (file3.isDirectory()) {
                    JreUtils.walk(file, file3, ruleArray, set, bl);
                    continue;
                }
                if (!file3.isFile()) continue;
                set.add(file3);
            }
        }
    }

    public static RelativeFileSet extractJreAsRelativeFileSet(String string, Rule[] ruleArray) {
        return JreUtils.extractJreAsRelativeFileSet(string, ruleArray, false);
    }

    public static RelativeFileSet extractJreAsRelativeFileSet(String string, Rule[] ruleArray, boolean bl) {
        if (string.isEmpty()) {
            return null;
        }
        File file = new File(string);
        HashSet<File> hashSet = new HashSet<File>();
        JreUtils.walk(file, file, ruleArray, hashSet, bl);
        return new RelativeFileSet(file, (Set<File>)hashSet);
    }

    public static class Rule {
        String regex;
        boolean includeRule;
        Type type;

        private Rule(String string, boolean bl, Type type) {
            this.regex = string;
            this.type = type;
            this.includeRule = bl;
        }

        boolean match(String string) {
            if (this.type == Type.SUFFIX) {
                return string.endsWith(this.regex);
            }
            if (this.type == Type.PREFIX) {
                return string.startsWith(this.regex);
            }
            if (this.type == Type.SUBSTR) {
                return string.contains(this.regex);
            }
            return string.matches(this.regex);
        }

        boolean treatAsAccept() {
            return this.includeRule;
        }

        public static Rule suffix(String string) {
            return new Rule(string, true, Type.SUFFIX);
        }

        public static Rule suffixNeg(String string) {
            return new Rule(string, false, Type.SUFFIX);
        }

        static Rule prefix(String string) {
            return new Rule(string, true, Type.PREFIX);
        }

        public static Rule prefixNeg(String string) {
            return new Rule(string, false, Type.PREFIX);
        }

        static Rule substr(String string) {
            return new Rule(string, true, Type.SUBSTR);
        }

        public static Rule substrNeg(String string) {
            return new Rule(string, false, Type.SUBSTR);
        }

        static enum Type {
            SUFFIX,
            PREFIX,
            SUBSTR,
            REGEX;

        }
    }
}

