/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.font.freetype;

import com.sun.javafx.font.Glyph;
import com.sun.javafx.font.freetype.FTFontFile;
import com.sun.javafx.font.freetype.FTFontStrike;
import com.sun.javafx.font.freetype.FT_Bitmap;
import com.sun.javafx.geom.RectBounds;
import com.sun.javafx.geom.Shape;

class FTGlyph
implements Glyph {
    FTFontStrike strike;
    int glyphCode;
    byte[] buffer;
    FT_Bitmap bitmap;
    int bitmap_left;
    int bitmap_top;
    float advanceX;
    float advanceY;
    float userAdvance;
    boolean lcd;

    FTGlyph(FTFontStrike strike, int glyphCode, boolean drawAsShape) {
        this.strike = strike;
        this.glyphCode = glyphCode;
    }

    @Override
    public int getGlyphCode() {
        return this.glyphCode;
    }

    private void init() {
        if (this.bitmap != null) {
            return;
        }
        this.strike.initGlyph(this);
    }

    @Override
    public RectBounds getBBox() {
        float[] bb = new float[4];
        FTFontFile fontResource = (FTFontFile)this.strike.getFontResource();
        fontResource.getGlyphBoundingBox(this.glyphCode, this.strike.getSize(), bb);
        return new RectBounds(bb[0], bb[1], bb[2], bb[3]);
    }

    @Override
    public float getAdvance() {
        this.init();
        return this.userAdvance;
    }

    @Override
    public Shape getShape() {
        return this.strike.createGlyphOutline(this.glyphCode);
    }

    @Override
    public byte[] getPixelData() {
        this.init();
        return this.buffer;
    }

    @Override
    public byte[] getPixelData(int subPixel) {
        this.init();
        return this.buffer;
    }

    @Override
    public float getPixelXAdvance() {
        this.init();
        return this.advanceX;
    }

    @Override
    public float getPixelYAdvance() {
        this.init();
        return this.advanceY;
    }

    @Override
    public int getWidth() {
        this.init();
        return this.bitmap != null ? this.bitmap.width : 0;
    }

    @Override
    public int getHeight() {
        this.init();
        return this.bitmap != null ? this.bitmap.rows : 0;
    }

    @Override
    public int getOriginX() {
        this.init();
        return this.bitmap_left;
    }

    @Override
    public int getOriginY() {
        this.init();
        return -this.bitmap_top;
    }

    @Override
    public boolean isLCDGlyph() {
        return this.lcd;
    }
}

