/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.geom;

public class Point2D {
    public float x;
    public float y;

    public Point2D() {
    }

    public Point2D(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setLocation(float x, float y) {
        this.x = x;
        this.y = y;
    }

    public void setLocation(Point2D p) {
        this.setLocation(p.x, p.y);
    }

    public static float distanceSq(float x1, float y1, float x2, float y2) {
        return (x1 -= x2) * x1 + (y1 -= y2) * y1;
    }

    public static float distance(float x1, float y1, float x2, float y2) {
        return (float)Math.sqrt((x1 -= x2) * x1 + (y1 -= y2) * y1);
    }

    public float distanceSq(float px, float py) {
        return (px -= this.x) * px + (py -= this.y) * py;
    }

    public float distanceSq(Point2D pt) {
        float px = pt.x - this.x;
        float py = pt.y - this.y;
        return px * px + py * py;
    }

    public float distance(float px, float py) {
        return (float)Math.sqrt((px -= this.x) * px + (py -= this.y) * py);
    }

    public float distance(Point2D pt) {
        float px = pt.x - this.x;
        float py = pt.y - this.y;
        return (float)Math.sqrt(px * px + py * py);
    }

    public int hashCode() {
        int bits = Float.floatToIntBits(this.x);
        return bits ^= Float.floatToIntBits(this.y) * 31;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Point2D) {
            Point2D p2d = (Point2D)obj;
            return this.x == p2d.x && this.y == p2d.y;
        }
        return false;
    }

    public String toString() {
        return "Point2D[" + this.x + ", " + this.y + "]";
    }
}

