/*
 * Decompiled with CFR 0.152.
 */
package com.sun.prism.d3d;

import com.sun.prism.PixelFormat;
import com.sun.prism.d3d.D3DContext;
import com.sun.prism.d3d.D3DResource;
import com.sun.prism.impl.PrismTrace;

public class D3DTextureData
extends D3DResource.D3DRecord {
    private final long size;
    private final boolean isRTT;
    private final int samples;

    static long estimateSize(int physicalWidth, int physicalHeight, PixelFormat format) {
        return (long)physicalWidth * (long)physicalHeight * (long)format.getBytesPerPixelUnit();
    }

    static long estimateRTSize(int physicalWidth, int physicalHeight, boolean hasDepth) {
        return (long)physicalWidth * (long)physicalHeight * 4L;
    }

    D3DTextureData(D3DContext context, long pResource, boolean isRTT, int physicalWidth, int physicalHeight, PixelFormat format, int numberOfSamples) {
        super(context, pResource);
        this.size = isRTT ? D3DTextureData.estimateRTSize(physicalWidth, physicalHeight, false) : D3DTextureData.estimateSize(physicalWidth, physicalHeight, format);
        this.isRTT = isRTT;
        this.samples = numberOfSamples;
        if (isRTT) {
            PrismTrace.rttCreated(pResource, physicalWidth, physicalHeight, this.size);
        } else {
            PrismTrace.textureCreated(pResource, physicalWidth, physicalHeight, this.size);
        }
    }

    int getSamples() {
        return this.samples;
    }

    long getSize() {
        return this.size;
    }

    @Override
    protected void markDisposed() {
        long pResource = this.getResource();
        if (pResource != 0L) {
            if (this.isRTT) {
                PrismTrace.rttDisposed(pResource);
            } else {
                PrismTrace.textureDisposed(pResource);
            }
        }
        super.markDisposed();
    }

    @Override
    public void dispose() {
        long pResource = this.getResource();
        if (pResource != 0L) {
            if (this.isRTT) {
                PrismTrace.rttDisposed(pResource);
            } else {
                PrismTrace.textureDisposed(pResource);
            }
        }
        super.dispose();
    }
}

