/*
 * Decompiled with CFR 0.152.
 */
package com.sun.scenario.effect.impl.sw.java;

import com.sun.javafx.geom.Rectangle;
import com.sun.javafx.geom.transform.BaseTransform;
import com.sun.scenario.effect.ColorAdjust;
import com.sun.scenario.effect.Effect;
import com.sun.scenario.effect.FilterContext;
import com.sun.scenario.effect.ImageData;
import com.sun.scenario.effect.impl.HeapImage;
import com.sun.scenario.effect.impl.Renderer;
import com.sun.scenario.effect.impl.state.RenderState;
import com.sun.scenario.effect.impl.sw.java.JSWEffectPeer;

public class JSWColorAdjustPeer
extends JSWEffectPeer {
    public JSWColorAdjustPeer(FilterContext fctx, Renderer r, String uniqueName) {
        super(fctx, r, uniqueName);
    }

    @Override
    protected final ColorAdjust getEffect() {
        return (ColorAdjust)super.getEffect();
    }

    private float getHue() {
        return this.getEffect().getHue() / 2.0f;
    }

    private float getSaturation() {
        return this.getEffect().getSaturation() + 1.0f;
    }

    private float getBrightness() {
        return this.getEffect().getBrightness() + 1.0f;
    }

    private float getContrast() {
        float c = this.getEffect().getContrast();
        if (c > 0.0f) {
            c *= 3.0f;
        }
        return c + 1.0f;
    }

    @Override
    public ImageData filter(Effect effect, RenderState rstate, BaseTransform transform, Rectangle outputClip, ImageData ... inputs) {
        this.setEffect(effect);
        Rectangle dstBounds = this.getResultBounds(transform, outputClip, inputs);
        this.setDestBounds(dstBounds);
        HeapImage src0 = (HeapImage)inputs[0].getTransformedImage(dstBounds);
        int src0x = 0;
        int src0y = 0;
        int src0w = src0.getPhysicalWidth();
        int src0h = src0.getPhysicalHeight();
        int src0scan = src0.getScanlineStride();
        int[] baseImg = src0.getPixelArray();
        Rectangle src0Bounds = new Rectangle(src0x, src0y, src0w, src0h);
        Rectangle src0InputBounds = inputs[0].getTransformedBounds(dstBounds);
        BaseTransform src0Transform = BaseTransform.IDENTITY_TRANSFORM;
        this.setInputBounds(0, src0InputBounds);
        this.setInputNativeBounds(0, src0Bounds);
        float[] src0Rect = new float[4];
        this.getTextureCoordinates(0, src0Rect, src0InputBounds.x, src0InputBounds.y, src0w, src0h, dstBounds, src0Transform);
        boolean dstx = false;
        boolean dsty = false;
        int dstw = dstBounds.width;
        int dsth = dstBounds.height;
        HeapImage dst = (HeapImage)((Object)this.getRenderer().getCompatibleImage(dstw, dsth));
        this.setDestNativeBounds(dst.getPhysicalWidth(), dst.getPhysicalHeight());
        int dstscan = dst.getScanlineStride();
        int[] dstPixels = dst.getPixelArray();
        float saturation = this.getSaturation();
        float brightness = this.getBrightness();
        float contrast = this.getContrast();
        float hue = this.getHue();
        float inc0_x = (src0Rect[2] - src0Rect[0]) / (float)dstw;
        float inc0_y = (src0Rect[3] - src0Rect[1]) / (float)dsth;
        float pos0_y = src0Rect[1] + inc0_y * 0.5f;
        for (int dy = 0; dy < 0 + dsth; ++dy) {
            float pixcoord_y = dy;
            int dyi = dy * dstscan;
            float pos0_x = src0Rect[0] + inc0_x * 0.5f;
            for (int dx = 0; dx < 0 + dstw; ++dx) {
                float clamp_res_x;
                float s;
                float h;
                float min_res;
                float cmin;
                float max_res;
                float cmax;
                int baseImg_tmp;
                float pixcoord_x = dx;
                float loc_tmp_x = pos0_x;
                float loc_tmp_y = pos0_y;
                if (loc_tmp_x >= 0.0f && loc_tmp_y >= 0.0f) {
                    int iloc_tmp_x = (int)(loc_tmp_x * (float)src0w);
                    int iloc_tmp_y = (int)(loc_tmp_y * (float)src0h);
                    boolean out = iloc_tmp_x >= src0w || iloc_tmp_y >= src0h;
                    baseImg_tmp = out ? 0 : baseImg[iloc_tmp_y * src0scan + iloc_tmp_x];
                } else {
                    baseImg_tmp = 0;
                }
                float sample_res_x = (float)(baseImg_tmp >> 16 & 0xFF) / 255.0f;
                float sample_res_y = (float)(baseImg_tmp >> 8 & 0xFF) / 255.0f;
                float sample_res_z = (float)(baseImg_tmp & 0xFF) / 255.0f;
                float sample_res_w = (float)(baseImg_tmp >>> 24) / 255.0f;
                float src_x = sample_res_x;
                float src_y = sample_res_y;
                float src_z = sample_res_z;
                float src_w = sample_res_w;
                if (src_w > 0.0f) {
                    src_x /= src_w;
                    src_y /= src_w;
                    src_z /= src_w;
                }
                src_x = (src_x - 0.5f) * contrast + 0.5f;
                src_y = (src_y - 0.5f) * contrast + 0.5f;
                src_z = (src_z - 0.5f) * contrast + 0.5f;
                float v_tmp_x = src_x;
                float v_tmp_y = src_y;
                float v_tmp_z = src_z;
                float x_tmp = v_tmp_x;
                float y_tmp = v_tmp_y;
                float x_tmp2 = cmax = (max_res = x_tmp > y_tmp ? x_tmp : y_tmp);
                float y_tmp2 = v_tmp_z;
                cmax = max_res = x_tmp2 > y_tmp2 ? x_tmp2 : y_tmp2;
                float x_tmp3 = v_tmp_x;
                float y_tmp3 = v_tmp_y;
                float x_tmp4 = cmin = (min_res = x_tmp3 < y_tmp3 ? x_tmp3 : y_tmp3);
                float y_tmp4 = v_tmp_z;
                min_res = x_tmp4 < y_tmp4 ? x_tmp4 : y_tmp4;
                cmin = min_res;
                if (cmax > cmin) {
                    float c_x = (cmax - v_tmp_x) / (cmax - cmin);
                    float c_y = (cmax - v_tmp_y) / (cmax - cmin);
                    float c_z = (cmax - v_tmp_z) / (cmax - cmin);
                    h = v_tmp_x == cmax ? c_z - c_y : (v_tmp_y == cmax ? 2.0f + c_x - c_z : 4.0f + c_y - c_x);
                    if ((h /= 6.0f) < 0.0f) {
                        h += 1.0f;
                    }
                    s = (cmax - cmin) / cmax;
                } else {
                    h = 0.0f;
                    s = 0.0f;
                }
                float b = cmax;
                float rgb_to_hsb_res_x = h;
                float rgb_to_hsb_res_y = s;
                float rgb_to_hsb_res_z = b;
                float hsb_x = rgb_to_hsb_res_x;
                float hsb_y = rgb_to_hsb_res_y;
                float hsb_z = rgb_to_hsb_res_z;
                hsb_x += hue;
                if (hsb_x < 0.0f) {
                    hsb_x += 1.0f;
                } else if (hsb_x > 1.0f) {
                    hsb_x -= 1.0f;
                }
                if (saturation > 1.0f) {
                    float sat = saturation - 1.0f;
                    hsb_y += (1.0f - hsb_y) * sat;
                } else {
                    hsb_y *= saturation;
                }
                if (brightness > 1.0f) {
                    float brt = brightness - 1.0f;
                    hsb_y *= 1.0f - brt;
                    hsb_z += (1.0f - hsb_z) * brt;
                } else {
                    hsb_z *= brightness;
                }
                float val_tmp_x = hsb_y;
                float val_tmp_y = hsb_z;
                float min_tmp = 0.0f;
                float max_tmp = 1.0f;
                float f = val_tmp_x < min_tmp ? min_tmp : (clamp_res_x = val_tmp_x > max_tmp ? max_tmp : val_tmp_x);
                float clamp_res_y = val_tmp_y < min_tmp ? min_tmp : (val_tmp_y > max_tmp ? max_tmp : val_tmp_y);
                hsb_y = clamp_res_x;
                hsb_z = clamp_res_y;
                float v_tmp_x2 = hsb_x;
                float v_tmp_y2 = hsb_y;
                float v_tmp_z2 = hsb_z;
                float res_x = 0.0f;
                float res_y = 0.0f;
                float res_z = 0.0f;
                float h2 = v_tmp_x2;
                float s2 = v_tmp_y2;
                float b2 = v_tmp_z2;
                float x_tmp5 = h2;
                float floor_res = (float)Math.floor(x_tmp5);
                x_tmp5 = h2 = (h2 - floor_res) * 6.0f;
                floor_res = (float)Math.floor(x_tmp5);
                float f2 = h2 - floor_res;
                float p = b2 * (1.0f - s2);
                float q = b2 * (1.0f - s2 * f2);
                float t = b2 * (1.0f - s2 * (1.0f - f2));
                float x_tmp6 = h2;
                h2 = floor_res = (float)Math.floor(x_tmp6);
                if (h2 < 1.0f) {
                    res_x = b2;
                    res_y = t;
                    res_z = p;
                } else if (h2 < 2.0f) {
                    res_x = q;
                    res_y = b2;
                    res_z = p;
                } else if (h2 < 3.0f) {
                    res_x = p;
                    res_y = b2;
                    res_z = t;
                } else if (h2 < 4.0f) {
                    res_x = p;
                    res_y = q;
                    res_z = b2;
                } else if (h2 < 5.0f) {
                    res_x = t;
                    res_y = p;
                    res_z = b2;
                } else {
                    res_x = b2;
                    res_y = p;
                    res_z = q;
                }
                float hsb_to_rgb_res_x = res_x;
                float hsb_to_rgb_res_y = res_y;
                float hsb_to_rgb_res_z = res_z;
                float color_x = src_w * hsb_to_rgb_res_x;
                float color_y = src_w * hsb_to_rgb_res_y;
                float color_z = src_w * hsb_to_rgb_res_z;
                float color_w = src_w;
                if (color_w < 0.0f) {
                    color_w = 0.0f;
                } else if (color_w > 1.0f) {
                    color_w = 1.0f;
                }
                if (color_x < 0.0f) {
                    color_x = 0.0f;
                } else if (color_x > color_w) {
                    color_x = color_w;
                }
                if (color_y < 0.0f) {
                    color_y = 0.0f;
                } else if (color_y > color_w) {
                    color_y = color_w;
                }
                if (color_z < 0.0f) {
                    color_z = 0.0f;
                } else if (color_z > color_w) {
                    color_z = color_w;
                }
                dstPixels[dyi + dx] = (int)(color_x * 255.0f) << 16 | (int)(color_y * 255.0f) << 8 | (int)(color_z * 255.0f) << 0 | (int)(color_w * 255.0f) << 24;
                pos0_x += inc0_x;
            }
            pos0_y += inc0_y;
        }
        inputs[0].releaseTransformedImage(src0);
        return new ImageData(this.getFilterContext(), dst, dstBounds);
    }
}

