/*
 * Decompiled with CFR 0.152.
 */
package javafx.css;

import java.util.Collections;
import java.util.List;
import javafx.css.StyleConverter;
import javafx.css.StyleOrigin;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;

public abstract class CssMetaData<S extends Styleable, V> {
    private final String property;
    private final StyleConverter<?, V> converter;
    private final V initialValue;
    private final List<CssMetaData<? extends Styleable, ?>> subProperties;
    private final boolean inherits;

    @Deprecated
    public void set(S styleable, V value, StyleOrigin origin) {
        StyleableProperty<V> styleableProperty = this.getStyleableProperty(styleable);
        StyleOrigin currentOrigin = styleableProperty.getStyleOrigin();
        Object currentValue = styleableProperty.getValue();
        if (currentOrigin != origin || (currentValue != null ? !currentValue.equals(value) : value != null)) {
            styleableProperty.applyStyle(origin, value);
        }
    }

    public abstract boolean isSettable(S var1);

    public abstract StyleableProperty<V> getStyleableProperty(S var1);

    public final String getProperty() {
        return this.property;
    }

    public final StyleConverter<?, V> getConverter() {
        return this.converter;
    }

    public V getInitialValue(S styleable) {
        return this.initialValue;
    }

    public final List<CssMetaData<? extends Styleable, ?>> getSubProperties() {
        return this.subProperties;
    }

    public final boolean isInherits() {
        return this.inherits;
    }

    protected CssMetaData(String property, StyleConverter<?, V> converter, V initialValue, boolean inherits, List<CssMetaData<? extends Styleable, ?>> subProperties) {
        this.property = property;
        this.converter = converter;
        this.initialValue = initialValue;
        this.inherits = inherits;
        List<CssMetaData<Styleable, ?>> list = this.subProperties = subProperties != null ? Collections.unmodifiableList(subProperties) : null;
        if (this.property == null || this.converter == null) {
            throw new IllegalArgumentException("neither property nor converter can be null");
        }
    }

    protected CssMetaData(String property, StyleConverter<?, V> converter, V initialValue, boolean inherits) {
        this(property, converter, initialValue, inherits, null);
    }

    protected CssMetaData(String property, StyleConverter<?, V> converter, V initialValue) {
        this(property, converter, initialValue, false, null);
    }

    protected CssMetaData(String property, StyleConverter<?, V> converter) {
        this(property, converter, null, false, null);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CssMetaData other = (CssMetaData)obj;
        return !(this.property == null ? other.property != null : !this.property.equals(other.property));
    }

    public int hashCode() {
        int hash = 3;
        hash = 19 * hash + (this.property != null ? this.property.hashCode() : 0);
        return hash;
    }

    public String toString() {
        return "CSSProperty {" + "property: " + this.property + ", converter: " + this.converter.toString() + ", initalValue: " + String.valueOf(this.initialValue) + ", inherits: " + this.inherits + ", subProperties: " + (this.subProperties != null ? this.subProperties.toString() : "[]") + "}";
    }
}

