/*
 * Decompiled with CFR 0.152.
 */
package sun.security.jgss.krb5;

import java.io.IOException;
import java.security.AccessControlContext;
import java.security.AccessController;
import javax.security.auth.Subject;
import javax.security.auth.kerberos.KerberosPrincipal;
import javax.security.auth.kerberos.KerberosTicket;
import javax.security.auth.login.LoginException;
import sun.security.action.GetBooleanAction;
import sun.security.jgss.GSSCaller;
import sun.security.jgss.GSSUtil;
import sun.security.jgss.krb5.ServiceCreds;
import sun.security.jgss.krb5.SubjectComber;
import sun.security.krb5.Credentials;
import sun.security.krb5.EncryptionKey;
import sun.security.krb5.KerberosSecrets;
import sun.security.krb5.KrbException;
import sun.security.krb5.PrincipalName;
import sun.security.krb5.internal.ktab.KeyTab;

public class Krb5Util {
    static final boolean DEBUG = AccessController.doPrivileged(new GetBooleanAction("sun.security.krb5.debug"));

    private Krb5Util() {
    }

    public static KerberosTicket getTicketFromSubjectAndTgs(GSSCaller gSSCaller, String string, String string2, String string3, AccessControlContext accessControlContext) throws LoginException, KrbException, IOException {
        Credentials credentials;
        Credentials credentials2;
        boolean bl;
        KerberosTicket kerberosTicket;
        Subject subject = Subject.getSubject(accessControlContext);
        KerberosTicket kerberosTicket2 = SubjectComber.find(subject, string2, string, KerberosTicket.class);
        if (kerberosTicket2 != null) {
            return kerberosTicket2;
        }
        Subject subject2 = null;
        if (!GSSUtil.useSubjectCredsOnly(gSSCaller)) {
            try {
                subject2 = GSSUtil.login(gSSCaller, GSSUtil.GSS_KRB5_MECH_OID);
                kerberosTicket2 = SubjectComber.find(subject2, string2, string, KerberosTicket.class);
                if (kerberosTicket2 != null) {
                    return kerberosTicket2;
                }
            }
            catch (LoginException loginException) {
                // empty catch block
            }
        }
        if ((kerberosTicket = SubjectComber.find(subject, string3, string, KerberosTicket.class)) == null && subject2 != null) {
            kerberosTicket = SubjectComber.find(subject2, string3, string, KerberosTicket.class);
            bl = false;
        } else {
            bl = true;
        }
        if (kerberosTicket != null && (credentials2 = Credentials.acquireServiceCreds(string2, credentials = Krb5Util.ticketToCreds(kerberosTicket))) != null) {
            kerberosTicket2 = Krb5Util.credsToTicket(credentials2);
            if (bl && subject != null && !subject.isReadOnly()) {
                subject.getPrivateCredentials().add(kerberosTicket2);
            }
        }
        return kerberosTicket2;
    }

    static KerberosTicket getServiceTicket(GSSCaller gSSCaller, String string, String string2, AccessControlContext accessControlContext) throws LoginException {
        Subject subject = Subject.getSubject(accessControlContext);
        KerberosTicket kerberosTicket = SubjectComber.find(subject, string2, string, KerberosTicket.class);
        return kerberosTicket;
    }

    static KerberosTicket getInitialTicket(GSSCaller gSSCaller, String string, AccessControlContext accessControlContext) throws LoginException {
        Subject subject = Subject.getSubject(accessControlContext);
        KerberosTicket kerberosTicket = SubjectComber.find(subject, null, string, KerberosTicket.class);
        if (kerberosTicket == null && !GSSUtil.useSubjectCredsOnly(gSSCaller)) {
            Subject subject2 = GSSUtil.login(gSSCaller, GSSUtil.GSS_KRB5_MECH_OID);
            kerberosTicket = SubjectComber.find(subject2, null, string, KerberosTicket.class);
        }
        return kerberosTicket;
    }

    public static Subject getSubject(GSSCaller gSSCaller, AccessControlContext accessControlContext) throws LoginException {
        Subject subject = Subject.getSubject(accessControlContext);
        if (subject == null && !GSSUtil.useSubjectCredsOnly(gSSCaller)) {
            subject = GSSUtil.login(gSSCaller, GSSUtil.GSS_KRB5_MECH_OID);
        }
        return subject;
    }

    public static ServiceCreds getServiceCreds(GSSCaller gSSCaller, String string, AccessControlContext accessControlContext) throws LoginException {
        Subject subject = Subject.getSubject(accessControlContext);
        ServiceCreds serviceCreds = null;
        if (subject != null) {
            serviceCreds = ServiceCreds.getInstance(subject, string);
        }
        if (serviceCreds == null && !GSSUtil.useSubjectCredsOnly(gSSCaller)) {
            Subject subject2 = GSSUtil.login(gSSCaller, GSSUtil.GSS_KRB5_MECH_OID);
            serviceCreds = ServiceCreds.getInstance(subject2, string);
        }
        return serviceCreds;
    }

    public static KerberosTicket credsToTicket(Credentials credentials) {
        EncryptionKey encryptionKey = credentials.getSessionKey();
        KerberosTicket kerberosTicket = new KerberosTicket(credentials.getEncoded(), new KerberosPrincipal(credentials.getClient().getName()), new KerberosPrincipal(credentials.getServer().getName(), 2), encryptionKey.getBytes(), encryptionKey.getEType(), credentials.getFlags(), credentials.getAuthTime(), credentials.getStartTime(), credentials.getEndTime(), credentials.getRenewTill(), credentials.getClientAddresses());
        PrincipalName principalName = credentials.getClientAlias();
        PrincipalName principalName2 = credentials.getServerAlias();
        if (principalName != null) {
            KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketSetClientAlias(kerberosTicket, new KerberosPrincipal(principalName.getName(), principalName.getNameType()));
        }
        if (principalName2 != null) {
            KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketSetServerAlias(kerberosTicket, new KerberosPrincipal(principalName2.getName(), principalName2.getNameType()));
        }
        return kerberosTicket;
    }

    public static Credentials ticketToCreds(KerberosTicket kerberosTicket) throws KrbException, IOException {
        KerberosPrincipal kerberosPrincipal = KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketGetClientAlias(kerberosTicket);
        KerberosPrincipal kerberosPrincipal2 = KerberosSecrets.getJavaxSecurityAuthKerberosAccess().kerberosTicketGetServerAlias(kerberosTicket);
        return new Credentials(kerberosTicket.getEncoded(), kerberosTicket.getClient().getName(), kerberosPrincipal != null ? kerberosPrincipal.getName() : null, kerberosTicket.getServer().getName(), kerberosPrincipal2 != null ? kerberosPrincipal2.getName() : null, kerberosTicket.getSessionKey().getEncoded(), kerberosTicket.getSessionKeyType(), kerberosTicket.getFlags(), kerberosTicket.getAuthTime(), kerberosTicket.getStartTime(), kerberosTicket.getEndTime(), kerberosTicket.getRenewTill(), kerberosTicket.getClientAddresses());
    }

    public static KeyTab snapshotFromJavaxKeyTab(javax.security.auth.kerberos.KeyTab keyTab) {
        return KerberosSecrets.getJavaxSecurityAuthKerberosAccess().keyTabTakeSnapshot(keyTab);
    }

    public static EncryptionKey[] keysFromJavaxKeyTab(javax.security.auth.kerberos.KeyTab keyTab, PrincipalName principalName) {
        return Krb5Util.snapshotFromJavaxKeyTab(keyTab).readServiceKeys(principalName);
    }
}

