/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.tools.packager;

import com.oracle.tools.packager.IOUtils;
import com.oracle.tools.packager.RelativeFileSet;
import java.io.File;
import java.util.HashSet;
import java.util.Set;

public class JreUtils {
    public static boolean shouldExclude(File baseDir, File f, Rule[] ruleset) {
        if (ruleset == null) {
            return false;
        }
        String fname = f.getAbsolutePath().toLowerCase().substring(baseDir.getAbsolutePath().length());
        for (Rule r : ruleset) {
            if (!r.match(fname)) continue;
            return !r.treatAsAccept();
        }
        return false;
    }

    public static void walk(File base, File root, Rule[] ruleset, Set<File> files) {
        JreUtils.walk(base, root, ruleset, files, false);
    }

    public static void walk(File base, File root, Rule[] ruleset, Set<File> files, boolean acceptSymlinks) {
        if (!root.isDirectory()) {
            if (root.isFile()) {
                files.add(root);
            }
            return;
        }
        File[] lst = root.listFiles();
        if (lst != null) {
            for (File f : lst) {
                if (!acceptSymlinks && !IOUtils.isNotSymbolicLink(f) || JreUtils.shouldExclude(base, f, ruleset)) continue;
                if (f.isDirectory()) {
                    JreUtils.walk(base, f, ruleset, files, acceptSymlinks);
                    continue;
                }
                if (!f.isFile()) continue;
                files.add(f);
            }
        }
    }

    public static RelativeFileSet extractJreAsRelativeFileSet(String root, Rule[] ruleset) {
        return JreUtils.extractJreAsRelativeFileSet(root, ruleset, false);
    }

    public static RelativeFileSet extractJreAsRelativeFileSet(String root, Rule[] ruleset, boolean acceptSymlinks) {
        if (root.isEmpty()) {
            return null;
        }
        File baseDir = new File(root);
        HashSet<File> lst = new HashSet<File>();
        JreUtils.walk(baseDir, baseDir, ruleset, lst, acceptSymlinks);
        return new RelativeFileSet(baseDir, (Set<File>)lst);
    }

    public static class Rule {
        String regex;
        boolean includeRule;
        Type type;

        private Rule(String regex, boolean includeRule, Type type) {
            this.regex = regex;
            this.type = type;
            this.includeRule = includeRule;
        }

        boolean match(String str) {
            if (this.type == Type.SUFFIX) {
                return str.endsWith(this.regex);
            }
            if (this.type == Type.PREFIX) {
                return str.startsWith(this.regex);
            }
            if (this.type == Type.SUBSTR) {
                return str.contains(this.regex);
            }
            return str.matches(this.regex);
        }

        boolean treatAsAccept() {
            return this.includeRule;
        }

        public static Rule suffix(String s) {
            return new Rule(s, true, Type.SUFFIX);
        }

        public static Rule suffixNeg(String s) {
            return new Rule(s, false, Type.SUFFIX);
        }

        static Rule prefix(String s) {
            return new Rule(s, true, Type.PREFIX);
        }

        public static Rule prefixNeg(String s) {
            return new Rule(s, false, Type.PREFIX);
        }

        static Rule substr(String s) {
            return new Rule(s, true, Type.SUBSTR);
        }

        public static Rule substrNeg(String s) {
            return new Rule(s, false, Type.SUBSTR);
        }

        static enum Type {
            SUFFIX,
            PREFIX,
            SUBSTR,
            REGEX;

        }
    }
}

