/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkColor;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class ToolItem
extends Item {
    int arrowHandle;
    int labelHandle;
    int imageHandle;
    int eventHandle;
    int proxyMenuItem;
    int provider;
    ToolBar parent;
    Control control;
    Image hotImage;
    Image disabledImage;
    String toolTipText;
    boolean drawHotImage;

    public ToolItem(ToolBar toolBar, int n) {
        super(toolBar, ToolItem.checkStyle(n));
        this.parent = toolBar;
        this.createWidget(toolBar.getItemCount());
    }

    public ToolItem(ToolBar toolBar, int n, int n2) {
        super(toolBar, ToolItem.checkStyle(n));
        this.parent = toolBar;
        int n3 = toolBar.getItemCount();
        if (0 > n2 || n2 > n3) {
            this.error(6);
        }
        this.createWidget(n2);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return ToolItem.checkBits(n, 8, 32, 16, 2, 4, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createHandle(int n) {
        this.state |= 8;
        int n2 = 62;
        if ((this.style & 2) == 0) {
            this.labelHandle = OS.gtk_label_new_with_mnemonic(null);
            if (this.labelHandle == 0) {
                this.error(2);
            }
            this.imageHandle = OS.gtk_image_new_from_pixbuf(0);
            if (this.imageHandle == 0) {
                this.error(2);
            }
        }
        switch (this.style & n2) {
            case 2: {
                this.handle = OS.gtk_separator_tool_item_new();
                if (this.handle == 0) {
                    this.error(2);
                }
                OS.gtk_separator_tool_item_set_draw(this.handle, true);
                break;
            }
            case 4: {
                this.handle = OS.gtk_menu_tool_button_new(0, null);
                if (this.handle == 0) {
                    this.error(2);
                }
                int n3 = OS.gtk_bin_get_child(this.handle);
                int n4 = OS.gtk_container_get_children(n3);
                this.arrowHandle = OS.g_list_nth_data(n4, 1);
                OS.gtk_widget_set_sensitive(this.arrowHandle, true);
                if (!OS.GTK3) {
                    OS.gtk_widget_set_size_request(OS.gtk_bin_get_child(this.arrowHandle), 8, 6);
                    break;
                }
                String string = "GtkMenuButton.button {\npadding-left: 0px;\npadding-right: 0px;\n}\n";
                if (this.provider != 0) break;
                this.provider = OS.gtk_css_provider_new();
                int n5 = OS.gtk_widget_get_style_context(this.arrowHandle);
                OS.gtk_style_context_add_provider(n5, this.provider, 600);
                OS.g_object_unref(this.provider);
                OS.gtk_css_provider_load_from_data(this.provider, Converter.wcsToMbcs(null, string, true), -1, null);
                OS.gtk_style_context_invalidate(n5);
                break;
            }
            case 16: 
            case 32: {
                this.handle = OS.gtk_toggle_tool_button_new();
                if (this.handle != 0) break;
                this.error(2);
                break;
            }
            default: {
                this.handle = OS.gtk_tool_button_new(0, null);
                if (this.handle != 0) break;
                this.error(2);
            }
        }
        if (this.labelHandle != 0) {
            OS.gtk_tool_button_set_label_widget(this.handle, this.labelHandle);
        }
        if (this.imageHandle != 0) {
            OS.gtk_tool_button_set_icon_widget(this.handle, this.imageHandle);
        }
        if ((this.parent.state & 0x1000) != 0) {
            this.setForegroundColor(this.parent.getForegroundColor());
        }
        if ((this.parent.state & 0x4000) != 0) {
            this.setFontDescription(this.parent.getFontDescription());
        }
        if ((this.parent.style & 0x20000) != 0) {
            OS.gtk_tool_item_set_is_important(this.handle, true);
        }
        if ((this.style & 2) == 0) {
            OS.gtk_tool_button_set_use_underline(this.handle, true);
        }
    }

    void createWidget(int n) {
        super.createWidget(n);
        this.showWidget(n);
        this.parent.relayout();
    }

    Widget[] computeTabList() {
        if (this.isTabGroup() && this.getEnabled()) {
            if ((this.style & 2) != 0) {
                if (this.control != null) {
                    return this.control.computeTabList();
                }
            } else {
                return new Widget[]{this};
            }
        }
        return new Widget[0];
    }

    void deregister() {
        super.deregister();
        if (this.eventHandle != 0) {
            this.display.removeWidget(this.eventHandle);
        }
        if (this.arrowHandle != 0) {
            this.display.removeWidget(this.arrowHandle);
        }
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        ToolBar toolBar = this.parent;
        super.dispose();
        toolBar.relayout();
    }

    public Rectangle getBounds() {
        this.checkWidget();
        this.parent.forceResize();
        int n = this.topHandle();
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(n, gtkAllocation);
        int n2 = gtkAllocation.x;
        int n3 = gtkAllocation.y;
        int n4 = gtkAllocation.width;
        int n5 = gtkAllocation.height;
        if ((this.parent.style & 0x8000000) != 0) {
            n2 = this.parent.getClientWidth() - n4 - n2;
        }
        if ((this.style & 2) != 0 && this.control != null) {
            n5 = Math.max(n5, 23);
        }
        return new Rectangle(n2, n3, n4, n5);
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Image getDisabledImage() {
        this.checkWidget();
        return this.disabledImage;
    }

    public boolean getEnabled() {
        this.checkWidget();
        int n = this.topHandle();
        return OS.gtk_widget_get_sensitive(n);
    }

    public Image getHotImage() {
        this.checkWidget();
        return this.hotImage;
    }

    public ToolBar getParent() {
        this.checkWidget();
        if (this.parent == null) {
            this.error(24);
        }
        return this.parent;
    }

    public boolean getSelection() {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return false;
        }
        return OS.gtk_toggle_tool_button_get_active(this.handle);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        this.parent.forceResize();
        int n = this.topHandle();
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(n, gtkAllocation);
        return gtkAllocation.width;
    }

    int gtk_button_press_event(int n, int n2) {
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.handle, gtkAllocation);
        double d = gdkEventButton.x + (double)gtkAllocation.x;
        double d2 = gdkEventButton.y + (double)gtkAllocation.y;
        OS.memmove(n2, gdkEventButton, GdkEventButton.sizeof);
        int n3 = this.parent.gtk_button_press_event(n, n2);
        gdkEventButton.x = d;
        gdkEventButton.y = d2;
        OS.memmove(n2, gdkEventButton, GdkEventButton.sizeof);
        return n3;
    }

    int gtk_button_release_event(int n, int n2) {
        GdkEventButton gdkEventButton = new GdkEventButton();
        OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.handle, gtkAllocation);
        double d = gdkEventButton.x + (double)gtkAllocation.x;
        double d2 = gdkEventButton.y + (double)gtkAllocation.y;
        OS.memmove(n2, gdkEventButton, GdkEventButton.sizeof);
        int n3 = this.parent.gtk_button_release_event(n, n2);
        gdkEventButton.x = d;
        gdkEventButton.y = d2;
        OS.memmove(n2, gdkEventButton, GdkEventButton.sizeof);
        return n3;
    }

    int gtk_clicked(int n) {
        int n2;
        Event event = new Event();
        if ((this.style & 4) != 0 && (n2 = OS.gtk_get_current_event()) != 0) {
            GdkEvent gdkEvent = new GdkEvent();
            OS.memmove(gdkEvent, n2, GdkEvent.sizeof);
            int n3 = this.topHandle();
            switch (gdkEvent.type) {
                case 4: 
                case 5: 
                case 7: 
                case 9: {
                    boolean bl = false;
                    if (n == this.arrowHandle) {
                        bl = true;
                        n3 = n;
                        OS.g_signal_handlers_block_matched(n, 16, 0, 0, 0, 0, 8);
                        OS.gtk_toggle_button_set_active(n, false);
                        OS.g_signal_handlers_unblock_matched(n, 16, 0, 0, 0, 0, 8);
                    }
                    if (!bl) break;
                    event.detail = 4;
                    GtkAllocation gtkAllocation = new GtkAllocation();
                    OS.gtk_widget_get_allocation(n3, gtkAllocation);
                    event.x = gtkAllocation.x;
                    if ((this.parent.style & 0x8000000) != 0) {
                        event.x = this.parent.getClientWidth() - gtkAllocation.width - event.x;
                    }
                    event.y = gtkAllocation.y + gtkAllocation.height;
                    break;
                }
            }
            OS.gdk_event_free(n2);
        }
        if ((this.style & 0x10) != 0 && (this.parent.getStyle() & 0x400000) == 0) {
            this.selectRadio();
        }
        this.sendSelectionEvent(13, event, false);
        return 0;
    }

    int gtk_create_menu_proxy(int n) {
        int n2;
        ImageList imageList;
        byte[] byArray = Converter.wcsToMbcs(null, "menu-id", true);
        if (this.proxyMenuItem != 0) {
            OS.gtk_tool_item_set_proxy_menu_item(n, byArray, this.proxyMenuItem);
            return 1;
        }
        if (this.image != null && (imageList = this.parent.imageList) != null && (n2 = imageList.indexOf(this.image)) != -1) {
            int n3;
            int n4 = imageList.getPixbuf(n2);
            byte[] byArray2 = null;
            int[] nArray = new int[]{1};
            int n5 = OS.gtk_settings_get_default();
            if (n5 != 0 && (n3 = OS.g_object_class_find_property(OS.G_OBJECT_GET_CLASS(n5), OS.gtk_menu_images)) != 0) {
                OS.g_object_get(n5, OS.gtk_menu_images, nArray, 0);
            }
            byArray2 = this.text == null || this.text.length() == 0 ? (nArray[0] == 0 && this.toolTipText != null ? Converter.wcsToMbcs(null, this.toolTipText, true) : new byte[]{0}) : Converter.wcsToMbcs(null, this.text, true);
            n3 = OS.gtk_image_menu_item_new_with_label(byArray2);
            int n6 = OS.gtk_image_new_from_pixbuf(n4);
            OS.gtk_image_menu_item_set_image(n3, n6);
            OS.gtk_tool_item_set_proxy_menu_item(n, byArray, n3);
            this.proxyMenuItem = OS.gtk_tool_item_get_proxy_menu_item(n, byArray);
            OS.g_signal_connect(n3, OS.activate, ToolBar.menuItemSelectedFunc.getAddress(), this.handle);
            return 1;
        }
        return 0;
    }

    int gtk_enter_notify_event(int n, int n2) {
        int n3;
        ImageList imageList;
        this.parent.gtk_enter_notify_event(n, n2);
        boolean bl = this.drawHotImage = (this.parent.style & 0x800000) != 0 && this.hotImage != null;
        if (this.drawHotImage && (imageList = this.parent.imageList) != null && (n3 = imageList.indexOf(this.hotImage)) != -1 && this.imageHandle != 0) {
            int n4 = imageList.getPixbuf(n3);
            this.gtk_image_set_from_pixbuf(this.imageHandle, n4);
        }
        return 0;
    }

    int gtk_event_after(int n, int n2) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, n2, GdkEvent.sizeof);
        switch (gdkEvent.type) {
            case 4: {
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
                if (gdkEventButton.button != 3) break;
                this.parent.showMenu((int)gdkEventButton.x_root, (int)gdkEventButton.y_root);
                break;
            }
        }
        return 0;
    }

    int gtk_focus_in_event(int n, int n2) {
        this.parent.hasChildFocus = true;
        this.parent.currentFocusItem = this;
        return 0;
    }

    int gtk_focus_out_event(int n, int n2) {
        this.parent.hasChildFocus = false;
        return 0;
    }

    int gtk_leave_notify_event(int n, int n2) {
        this.parent.gtk_leave_notify_event(n, n2);
        if (this.drawHotImage) {
            int n3;
            ImageList imageList;
            this.drawHotImage = false;
            if (this.image != null && (imageList = this.parent.imageList) != null && (n3 = imageList.indexOf(this.image)) != -1 && this.imageHandle != 0) {
                int n4 = imageList.getPixbuf(n3);
                this.gtk_image_set_from_pixbuf(this.imageHandle, n4);
            }
        }
        return 0;
    }

    int gtk_map(int n) {
        this.parent.fixZOrder();
        return 0;
    }

    int gtk_mnemonic_activate(int n, int n2) {
        return this.parent.gtk_mnemonic_activate(n, n2);
    }

    void hookEvents() {
        int n;
        super.hookEvents();
        if ((this.style & 2) != 0) {
            return;
        }
        OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.getClosure(8), false);
        this.eventHandle = OS.gtk_bin_get_child(this.handle);
        if ((this.style & 4) != 0) {
            n = OS.gtk_container_get_children(this.eventHandle);
            this.eventHandle = OS.g_list_nth_data(n, 0);
            if (this.arrowHandle != 0) {
                OS.g_signal_connect_closure(this.arrowHandle, OS.clicked, this.display.getClosure(8), false);
            }
        }
        OS.g_signal_connect_closure(this.handle, OS.create_menu_proxy, this.display.getClosure(83), false);
        OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[14], 0, this.display.getClosure(14), false);
        OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[29], 0, this.display.getClosure(29), false);
        OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[21], 0, this.display.getClosure(21), false);
        OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[22], 0, this.display.getClosure(22), false);
        n = 32518;
        OS.gtk_widget_add_events(this.eventHandle, n);
        OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[2], 0, this.display.getClosure(2), false);
        OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[4], 0, this.display.getClosure(4), false);
        OS.g_signal_connect_closure_by_id(this.eventHandle, this.display.signalIds[16], 0, this.display.getClosure(16), false);
        int n2 = this.topHandle();
        OS.g_signal_connect_closure_by_id(n2, this.display.signalIds[30], 0, this.display.getClosure(30), true);
    }

    public boolean isEnabled() {
        this.checkWidget();
        return this.getEnabled() && this.parent.isEnabled();
    }

    boolean isTabGroup() {
        int n;
        ToolItem[] toolItemArray = this.parent._getTabItemList();
        if (toolItemArray != null) {
            for (n = 0; n < toolItemArray.length; ++n) {
                if (toolItemArray[n] != this) continue;
                return true;
            }
        }
        if ((this.style & 2) != 0) {
            return true;
        }
        n = this.parent.indexOf(this);
        if (n == 0) {
            return true;
        }
        ToolItem toolItem = this.parent.getItem(n - 1);
        return (toolItem.getStyle() & 2) != 0;
    }

    void register() {
        super.register();
        if (this.eventHandle != 0) {
            this.display.addWidget(this.eventHandle, this);
        }
        if (this.arrowHandle != 0) {
            this.display.addWidget(this.arrowHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.eventHandle = 0;
        this.imageHandle = 0;
        this.labelHandle = 0;
        this.arrowHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.parent.currentFocusItem == this) {
            this.parent.currentFocusItem = null;
        }
        this.parent = null;
        this.control = null;
        this.disabledImage = null;
        this.hotImage = null;
        this.toolTipText = null;
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    void resizeControl() {
        if (this.control != null && !this.control.isDisposed()) {
            Rectangle rectangle = this.getBounds();
            this.control.setSize(rectangle.width, rectangle.height);
            this.resizeHandle(rectangle.width, rectangle.height);
            Rectangle rectangle2 = this.control.getBounds();
            rectangle2.x = rectangle.x + (rectangle.width - rectangle2.width) / 2;
            rectangle2.y = rectangle.y + (rectangle.height - rectangle2.height) / 2;
            this.control.setLocation(rectangle2.x, rectangle2.y);
        }
    }

    void resizeHandle(int n, int n2) {
        OS.gtk_widget_set_size_request(this.handle, n, n2);
        GtkRequisition gtkRequisition = new GtkRequisition();
        this.parent.gtk_widget_size_request(this.handle, gtkRequisition);
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(this.handle, gtkAllocation);
        gtkAllocation.width = n;
        gtkAllocation.height = n2;
        OS.gtk_widget_size_allocate(this.handle, gtkAllocation);
    }

    void selectRadio() {
        ToolItem[] toolItemArray = this.parent.getItems();
        for (int i = 0; i < toolItemArray.length && toolItemArray[i] != this; ++i) {
        }
        for (int i = i - 1; i >= 0 && toolItemArray[i].setRadioSelection(false); --i) {
        }
        for (int i = i + 1; i < toolItemArray.length && toolItemArray[i].setRadioSelection(false); ++i) {
        }
        this.setSelection(true);
    }

    public void setControl(Control control) {
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if ((this.style & 2) == 0) {
            return;
        }
        if (this.control == control) {
            return;
        }
        this.control = control;
        this.parent.relayout();
    }

    public void setDisabledImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        this.disabledImage = image;
    }

    public void setEnabled(boolean bl) {
        this.checkWidget();
        int n = this.topHandle();
        if (OS.gtk_widget_get_sensitive(n) == bl) {
            return;
        }
        OS.gtk_widget_set_sensitive(n, bl);
        if (!OS.GTK3) {
            if (bl) {
                int[] nArray = new int[1];
                int[] nArray2 = new int[1];
                this.gdk_window_get_device_position(this.parent.paintWindow(), nArray, nArray2, null);
                if (this.getBounds().contains(nArray[0], nArray2[0])) {
                    OS.gtk_widget_hide(this.handle);
                    OS.gtk_widget_show(this.handle);
                }
            } else {
                OS.gtk_widget_set_state(n, 0);
            }
        }
    }

    boolean setFocus() {
        return OS.gtk_widget_child_focus(this.handle, 0);
    }

    void setFontDescription(int n) {
        if (this.labelHandle != 0) {
            this.setFontDescription(this.labelHandle, n);
        }
    }

    void setForegroundColor(GdkColor gdkColor) {
        if (this.labelHandle != 0) {
            this.setForegroundColor(this.labelHandle, gdkColor);
        }
    }

    public void setHotImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        this.hotImage = image;
        if (image != null) {
            int n;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((n = imageList.indexOf(image)) == -1) {
                n = imageList.add(image);
            } else {
                imageList.put(n, image);
            }
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if ((this.style & 2) != 0) {
            return;
        }
        super.setImage(image);
        if (image != null) {
            int n;
            ImageList imageList = this.parent.imageList;
            if (imageList == null) {
                imageList = this.parent.imageList = new ImageList();
            }
            if ((n = imageList.indexOf(image)) == -1) {
                n = imageList.add(image);
            } else {
                imageList.put(n, image);
            }
            int n2 = imageList.getPixbuf(n);
            this.gtk_image_set_from_pixbuf(this.imageHandle, n2);
        } else {
            this.gtk_image_set_from_pixbuf(this.imageHandle, 0);
        }
        if ((this.style & 4) != 0) {
            this.proxyMenuItem = 0;
            this.proxyMenuItem = OS.gtk_tool_item_retrieve_proxy_menu_item(this.handle);
            OS.g_signal_connect(this.proxyMenuItem, OS.activate, ToolBar.menuItemSelectedFunc.getAddress(), this.handle);
        }
        this.parent.relayout();
    }

    void setOrientation(boolean bl) {
        if ((this.parent.style & 0x4000000) != 0 || !bl) {
            int n;
            int n2 = n = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            if (this.handle != 0) {
                OS.gtk_widget_set_direction(this.handle, n);
            }
        }
    }

    boolean setRadioSelection(boolean bl) {
        if ((this.style & 0x10) == 0) {
            return false;
        }
        if (this.getSelection() != bl) {
            this.setSelection(bl);
            this.sendSelectionEvent(13);
        }
        return true;
    }

    public void setSelection(boolean bl) {
        this.checkWidget();
        if ((this.style & 0x30) == 0) {
            return;
        }
        OS.g_signal_handlers_block_matched(this.handle, 16, 0, 0, 0, 0, 8);
        OS.gtk_toggle_tool_button_set_active(this.handle, bl);
        OS.g_signal_handlers_unblock_matched(this.handle, 16, 0, 0, 0, 0, 8);
    }

    boolean setTabItemFocus(boolean bl) {
        return this.setFocus();
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if ((this.style & 2) != 0) {
            return;
        }
        if (string.equals(this.text)) {
            return;
        }
        super.setText(string);
        if (this.labelHandle == 0) {
            return;
        }
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
        OS.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
        if ((this.style & 4) != 0) {
            this.proxyMenuItem = 0;
            this.proxyMenuItem = OS.gtk_tool_item_retrieve_proxy_menu_item(this.handle);
            OS.g_signal_connect(this.proxyMenuItem, OS.activate, ToolBar.menuItemSelectedFunc.getAddress(), this.handle);
        }
        this.parent.relayout();
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        if (this.toolTipText == string || this.toolTipText != null && this.toolTipText.equals(string)) {
            return;
        }
        if (this.parent.toolTipText == null) {
            Shell shell = this.parent._getShell();
            this.setToolTipText(shell, string);
        }
        this.toolTipText = string;
        if ((this.style & 4) != 0) {
            this.proxyMenuItem = 0;
            this.proxyMenuItem = OS.gtk_tool_item_retrieve_proxy_menu_item(this.handle);
            OS.g_signal_connect(this.proxyMenuItem, OS.activate, ToolBar.menuItemSelectedFunc.getAddress(), this.handle);
        }
    }

    void setToolTipText(Shell shell, String string) {
        int n = OS.gtk_bin_get_child(this.handle);
        if ((this.style & 4) != 0) {
            int n2 = OS.gtk_container_get_children(n);
            n = OS.g_list_nth_data(n2, 0);
            if (this.arrowHandle != 0) {
                shell.setToolTipText(this.arrowHandle, string);
            }
        }
        shell.setToolTipText(n != 0 ? n : this.handle, string);
    }

    public void setWidth(int n) {
        this.checkWidget();
        if ((this.style & 2) == 0) {
            return;
        }
        if (n < 0) {
            return;
        }
        this.resizeHandle(n, (this.parent.style & 0x200) != 0 ? 6 : 15);
        this.parent.relayout();
    }

    void showWidget(int n) {
        if (this.handle != 0) {
            OS.gtk_widget_show(this.handle);
        }
        if (this.labelHandle != 0) {
            OS.gtk_widget_show(this.labelHandle);
        }
        if (this.imageHandle != 0) {
            OS.gtk_widget_show(this.imageHandle);
        }
        OS.gtk_toolbar_insert(this.parent.handle, this.handle, n);
    }
}

