/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.GdkEvent;
import org.eclipse.swt.internal.gtk.GdkEventButton;
import org.eclipse.swt.internal.gtk.GtkAllocation;
import org.eclipse.swt.internal.gtk.GtkRequisition;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;

public class TreeColumn
extends Item {
    int labelHandle;
    int imageHandle;
    int buttonHandle;
    Tree parent;
    int modelIndex;
    int lastButton;
    int lastTime;
    int lastX;
    int lastWidth;
    boolean customDraw;
    boolean useFixedWidth;
    String toolTipText;

    public TreeColumn(Tree tree, int n) {
        super(tree, TreeColumn.checkStyle(n));
        this.parent = tree;
        this.createWidget(tree.getColumnCount());
    }

    public TreeColumn(Tree tree, int n, int n2) {
        super(tree, TreeColumn.checkStyle(n));
        this.parent = tree;
        this.createWidget(n2);
    }

    public void addControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(controlListener);
        this.addListener(11, typedListener);
        this.addListener(10, typedListener);
    }

    public void addSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(selectionListener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    static int checkStyle(int n) {
        return TreeColumn.checkBits(n, 16384, 0x1000000, 131072, 0, 0, 0);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void createWidget(int n) {
        this.parent.createItem(this, n);
        this.setOrientation(true);
        this.hookEvents();
        this.register();
        this.text = "";
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.handle);
        if (this.buttonHandle != 0) {
            this.display.removeWidget(this.buttonHandle);
        }
        if (this.labelHandle != 0) {
            this.display.removeWidget(this.labelHandle);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public int getAlignment() {
        this.checkWidget();
        if ((this.style & 0x4000) != 0) {
            return 16384;
        }
        if ((this.style & 0x1000000) != 0) {
            return 0x1000000;
        }
        if ((this.style & 0x20000) != 0) {
            return 131072;
        }
        return 16384;
    }

    public boolean getMoveable() {
        this.checkWidget();
        return OS.gtk_tree_view_column_get_reorderable(this.handle);
    }

    public Tree getParent() {
        this.checkWidget();
        return this.parent;
    }

    public boolean getResizable() {
        this.checkWidget();
        return OS.gtk_tree_view_column_get_resizable(this.handle);
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    public int getWidth() {
        this.checkWidget();
        if (!OS.gtk_tree_view_column_get_visible(this.handle)) {
            return 0;
        }
        if (this.useFixedWidth) {
            return OS.gtk_tree_view_column_get_fixed_width(this.handle);
        }
        return OS.gtk_tree_view_column_get_width(this.handle);
    }

    int gtk_clicked(int n) {
        boolean bl = false;
        boolean bl2 = true;
        int n2 = OS.gtk_get_current_event();
        if (n2 != 0) {
            GdkEventButton gdkEventButton = new GdkEventButton();
            OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
            OS.gdk_event_free(n2);
            switch (gdkEventButton.type) {
                case 7: {
                    int n3 = this.display.getDoubleClickTime();
                    int n4 = gdkEventButton.time;
                    int n5 = gdkEventButton.button;
                    if (this.lastButton == n5 && this.lastTime != 0 && Math.abs(this.lastTime - n4) <= n3) {
                        bl = true;
                    }
                    this.lastTime = n4 == 0 ? 1 : n4;
                    this.lastButton = n5;
                    break;
                }
            }
        }
        if (bl2) {
            this.sendSelectionEvent(bl ? 14 : 13);
        }
        return 0;
    }

    int gtk_event_after(int n, int n2) {
        GdkEvent gdkEvent = new GdkEvent();
        OS.memmove(gdkEvent, n2, GdkEvent.sizeof);
        switch (gdkEvent.type) {
            case 4: {
                GdkEventButton gdkEventButton = new GdkEventButton();
                OS.memmove(gdkEventButton, n2, GdkEventButton.sizeof);
                if (gdkEventButton.button != 3) break;
                this.parent.showMenu((int)gdkEventButton.x_root, (int)gdkEventButton.y_root);
                break;
            }
        }
        return 0;
    }

    int gtk_mnemonic_activate(int n, int n2) {
        return this.parent.gtk_mnemonic_activate(n, n2);
    }

    int gtk_size_allocate(int n, int n2) {
        this.useFixedWidth = false;
        GtkAllocation gtkAllocation = new GtkAllocation();
        OS.gtk_widget_get_allocation(n, gtkAllocation);
        int n3 = gtkAllocation.x;
        int n4 = gtkAllocation.width;
        if (n3 != this.lastX) {
            this.lastX = n3;
            this.sendEvent(10);
        }
        if (n4 != this.lastWidth) {
            this.lastWidth = n4;
            this.sendEvent(11);
        }
        return 0;
    }

    void hookEvents() {
        super.hookEvents();
        OS.g_signal_connect_closure(this.handle, OS.clicked, this.display.getClosure(8), false);
        if (this.buttonHandle != 0) {
            OS.g_signal_connect_closure_by_id(this.buttonHandle, this.display.signalIds[47], 0, this.display.getClosure(47), false);
            OS.g_signal_connect_closure_by_id(this.buttonHandle, this.display.signalIds[16], 0, this.display.getClosure(16), false);
        }
        if (this.labelHandle != 0) {
            OS.g_signal_connect_closure_by_id(this.labelHandle, this.display.signalIds[32], 0, this.display.getClosure(32), false);
        }
    }

    public void pack() {
        this.checkWidget();
        int n = 0;
        if (this.buttonHandle != 0) {
            GtkRequisition gtkRequisition = new GtkRequisition();
            this.gtk_widget_get_preferred_size(this.buttonHandle, gtkRequisition);
            n = gtkRequisition.width;
        }
        if ((this.parent.style & 0x10000000) != 0) {
            for (int i = 0; i < this.parent.items.length; ++i) {
                TreeItem treeItem = this.parent.items[i];
                if (treeItem == null || !treeItem.cached) continue;
                n = Math.max(n, this.parent.calculateWidth(this.handle, treeItem.handle, true));
            }
        } else {
            int n2 = OS.g_malloc(OS.GtkTreeIter_sizeof());
            if (OS.gtk_tree_model_get_iter_first(this.parent.modelHandle, n2)) {
                do {
                    n = Math.max(n, this.parent.calculateWidth(this.handle, n2, true));
                } while (OS.gtk_tree_model_iter_next(this.parent.modelHandle, n2));
            }
            OS.g_free(n2);
        }
        this.setWidth(n);
    }

    void register() {
        super.register();
        this.display.addWidget(this.handle, this);
        if (this.buttonHandle != 0) {
            this.display.addWidget(this.buttonHandle, this);
        }
        if (this.labelHandle != 0) {
            this.display.addWidget(this.labelHandle, this);
        }
    }

    void releaseHandle() {
        super.releaseHandle();
        this.imageHandle = 0;
        this.labelHandle = 0;
        this.buttonHandle = 0;
        this.handle = 0;
        this.modelIndex = -1;
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        if (this.parent.sortColumn == this) {
            this.parent.sortColumn = null;
        }
    }

    public void removeControlListener(ControlListener controlListener) {
        this.checkWidget();
        if (controlListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(10, controlListener);
        this.eventTable.unhook(11, controlListener);
    }

    public void removeSelectionListener(SelectionListener selectionListener) {
        this.checkWidget();
        if (selectionListener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(13, selectionListener);
        this.eventTable.unhook(14, selectionListener);
    }

    public void setAlignment(int n) {
        this.checkWidget();
        if ((n & 0x1024000) == 0) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1 || n2 == 0) {
            return;
        }
        this.style &= 0xFEFDBFFF;
        this.style |= n & 0x1024000;
        this.parent.createRenderers(this.handle, this.modelIndex, n2 == 0, this.style);
    }

    void setFontDescription(int n) {
        this.setFontDescription(this.labelHandle, n);
        this.setFontDescription(this.imageHandle, n);
    }

    public void setImage(Image image) {
        this.checkWidget();
        super.setImage(image);
        if (image != null) {
            int n;
            ImageList imageList = this.parent.headerImageList;
            if (imageList == null) {
                imageList = this.parent.headerImageList = new ImageList();
            }
            if ((n = imageList.indexOf(image)) == -1) {
                n = imageList.add(image);
            }
            int n2 = imageList.getPixbuf(n);
            this.gtk_image_set_from_pixbuf(this.imageHandle, n2);
            OS.gtk_widget_show(this.imageHandle);
        } else {
            this.gtk_image_set_from_pixbuf(this.imageHandle, 0);
            OS.gtk_widget_hide(this.imageHandle);
        }
    }

    public void setMoveable(boolean bl) {
        this.checkWidget();
        OS.gtk_tree_view_column_set_reorderable(this.handle, bl);
    }

    void setOrientation(boolean bl) {
        if (!((this.parent.style & 0x4000000) == 0 && bl || this.buttonHandle == 0)) {
            int n = (this.parent.style & 0x4000000) != 0 ? 2 : 1;
            OS.gtk_widget_set_direction(this.buttonHandle, n);
            OS.gtk_container_forall(this.buttonHandle, this.display.setDirectionProc, n);
        }
    }

    public void setResizable(boolean bl) {
        this.checkWidget();
        OS.gtk_tree_view_column_set_resizable(this.handle, bl);
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        super.setText(string);
        char[] cArray = this.fixMnemonic(string);
        byte[] byArray = Converter.wcsToMbcs(null, cArray, true);
        OS.gtk_label_set_text_with_mnemonic(this.labelHandle, byArray);
        if (string.length() != 0) {
            OS.gtk_widget_show(this.labelHandle);
        } else {
            OS.gtk_widget_hide(this.labelHandle);
        }
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        Shell shell = this.parent._getShell();
        this.setToolTipText(shell, string);
        this.toolTipText = string;
    }

    void setToolTipText(Shell shell, String string) {
        shell.setToolTipText(this.buttonHandle, string);
    }

    public void setWidth(int n) {
        int n2;
        int n3;
        this.checkWidget();
        if (n < 0) {
            return;
        }
        if (n == this.lastWidth) {
            return;
        }
        if (n > 0) {
            this.useFixedWidth = true;
            OS.gtk_tree_view_column_set_fixed_width(this.handle, n);
        }
        if (n != 0) {
            OS.gtk_widget_realize(this.parent.handle);
        }
        OS.gtk_tree_view_column_set_visible(this.handle, n != 0);
        this.lastWidth = n;
        if (n != 0 && this.buttonHandle != 0 && (n3 = OS.gtk_widget_get_parent_window(this.buttonHandle)) != 0 && (n2 = OS.gdk_window_get_children(n3)) != 0) {
            int n4 = n2;
            int[] nArray = new int[1];
            while (n4 != 0) {
                int n5 = OS.g_list_data(n4);
                OS.gdk_window_get_user_data(n5, nArray);
                if (nArray[0] == this.buttonHandle) {
                    OS.gdk_window_lower(n5);
                    break;
                }
                n4 = OS.g_list_next(n4);
            }
            OS.g_list_free(n2);
        }
        this.sendEvent(11);
    }
}

