/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.TCITEM;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.TabFolder;

public class TabItem
extends Item {
    TabFolder parent;
    Control control;
    String toolTipText;

    public TabItem(TabFolder tabFolder, int n) {
        super(tabFolder, n);
        this.parent = tabFolder;
        tabFolder.createItem(this, tabFolder.getItemCount());
    }

    public TabItem(TabFolder tabFolder, int n, int n2) {
        super(tabFolder, n);
        this.parent = tabFolder;
        tabFolder.createItem(this, n2);
    }

    void _setText(int n, String string) {
        int n2;
        int n3;
        if (OS.COMCTL32_MAJOR >= 6 && this.image != null && string.indexOf(38) != -1) {
            n3 = string.length();
            char[] cArray = new char[n3];
            string.getChars(0, n3, cArray, 0);
            int n4 = 0;
            n2 = 0;
            for (n4 = 0; n4 < n3; ++n4) {
                if (cArray[n4] == '&') continue;
                cArray[n2++] = cArray[n4];
            }
            if (n2 < n4) {
                string = new String(cArray, 0, n2);
            }
        }
        n3 = this.parent.handle;
        int n5 = OS.GetProcessHeap();
        TCHAR tCHAR = new TCHAR(this.parent.getCodePage(), string, true);
        n2 = tCHAR.length() * TCHAR.sizeof;
        int n6 = OS.HeapAlloc(n5, 8, n2);
        OS.MoveMemory(n6, tCHAR, n2);
        TCITEM tCITEM = new TCITEM();
        tCITEM.mask = 1;
        tCITEM.pszText = n6;
        OS.SendMessage(n3, OS.TCM_SETITEM, n, tCITEM);
        OS.HeapFree(n5, 0, n6);
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    void destroyWidget() {
        this.parent.destroyItem(this);
        this.releaseHandle();
    }

    public Control getControl() {
        this.checkWidget();
        return this.control;
    }

    public Rectangle getBounds() {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return new Rectangle(0, 0, 0, 0);
        }
        RECT rECT = new RECT();
        OS.SendMessage(this.parent.handle, 4874, n, rECT);
        return new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
    }

    public TabFolder getParent() {
        this.checkWidget();
        return this.parent;
    }

    public String getToolTipText() {
        this.checkWidget();
        return this.toolTipText;
    }

    void releaseHandle() {
        super.releaseHandle();
        this.parent = null;
    }

    void releaseParent() {
        super.releaseParent();
        int n = this.parent.indexOf(this);
        if (n == this.parent.getSelectionIndex() && this.control != null) {
            this.control.setVisible(false);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.control = null;
    }

    public void setControl(Control control) {
        int n;
        this.checkWidget();
        if (control != null) {
            if (control.isDisposed()) {
                this.error(5);
            }
            if (control.parent != this.parent) {
                this.error(32);
            }
        }
        if (this.control != null && this.control.isDisposed()) {
            this.control = null;
        }
        Control control2 = this.control;
        Control control3 = control;
        this.control = control;
        int n2 = this.parent.indexOf(this);
        if (n2 != (n = this.parent.getSelectionIndex()) && control3 != null) {
            Control control4;
            if (n != -1 && (control4 = this.parent.getItem(n).getControl()) == control3) {
                return;
            }
            control3.setVisible(false);
            return;
        }
        if (control3 != null) {
            control3.setBounds(this.parent.getClientArea());
            control3.setVisible(true);
        }
        if (control2 != null && control3 != null && control2 != control3) {
            control2.setVisible(false);
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        int n = this.parent.indexOf(this);
        if (n == -1) {
            return;
        }
        super.setImage(image);
        if (OS.COMCTL32_MAJOR >= 6 && this.text.indexOf(38) != -1) {
            this._setText(n, this.text);
        }
        int n2 = this.parent.handle;
        TCITEM tCITEM = new TCITEM();
        tCITEM.mask = 2;
        tCITEM.iImage = this.parent.imageIndex(image);
        OS.SendMessage(n2, OS.TCM_SETITEM, n, tCITEM);
    }

    public void setText(String string) {
        int n;
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        if (string.equals(this.text)) {
            return;
        }
        int n2 = this.parent.indexOf(this);
        if (n2 == -1) {
            return;
        }
        super.setText(string);
        int n3 = n = (this.state & 0x400000) != 0 ? 0x6000000 : this.style & Integer.MIN_VALUE;
        if (!this.updateTextDirection(n)) {
            this._setText(n2, string);
        }
    }

    boolean updateTextDirection(int n) {
        int n2;
        if (super.updateTextDirection(n) && OS.IsUnicode && (n2 = this.parent.indexOf(this)) != -1) {
            if ((n & 0x4000000) != 0) {
                this._setText(n2, '\u202b' + this.text);
                return true;
            }
            if ((n & 0x2000000) != 0) {
                this._setText(n2, '\u202a' + this.text);
                return true;
            }
        }
        return false;
    }

    public void setToolTipText(String string) {
        this.checkWidget();
        this.toolTipText = string;
    }
}

