/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.SerializableCompatibility;
import org.eclipse.swt.internal.win32.ACCEL;
import org.eclipse.swt.internal.win32.CREATESTRUCT;
import org.eclipse.swt.internal.win32.LRESULT;
import org.eclipse.swt.internal.win32.MENUITEMINFO;
import org.eclipse.swt.internal.win32.MSG;
import org.eclipse.swt.internal.win32.OS;
import org.eclipse.swt.internal.win32.RECT;
import org.eclipse.swt.internal.win32.STARTUPINFO;
import org.eclipse.swt.internal.win32.TCHAR;
import org.eclipse.swt.internal.win32.WINDOWPLACEMENT;
import org.eclipse.swt.internal.win32.WINDOWPOS;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class Decorations
extends Canvas {
    Image image;
    Image smallImage;
    Image largeImage;
    Image[] images;
    Menu menuBar;
    Menu[] menus;
    Control savedFocus;
    Button defaultButton;
    Button saveDefault;
    int swFlags;
    int nAccel;
    int hAccel;
    boolean moved;
    boolean resized;
    boolean opened;
    int oldX = Integer.MIN_VALUE;
    int oldY = Integer.MIN_VALUE;
    int oldWidth = Integer.MIN_VALUE;
    int oldHeight = Integer.MIN_VALUE;
    RECT maxRect = new RECT();

    Decorations() {
    }

    public Decorations(Composite composite, int n) {
        super(composite, Decorations.checkStyle(n));
    }

    void _setMaximized(boolean bl) {
        int n = this.swFlags = bl ? OS.SW_SHOWMAXIMIZED : OS.SW_RESTORE;
        if (OS.IsWinCE) {
            if (bl) {
                int n2;
                RECT rECT = new RECT();
                OS.SystemParametersInfo(48, 0, rECT, 0);
                int n3 = rECT.right - rECT.left;
                int n4 = rECT.bottom - rECT.top;
                if (OS.IsPPC && this.menuBar != null) {
                    n2 = this.menuBar.hwndCB;
                    RECT rECT2 = new RECT();
                    OS.GetWindowRect(n2, rECT2);
                    n4 -= rECT2.bottom - rECT2.top;
                }
                n2 = 52;
                this.SetWindowPos(this.handle, 0, rECT.left, rECT.top, n3, n4, n2);
            }
        } else {
            if (!OS.IsWindowVisible(this.handle)) {
                return;
            }
            if (bl == OS.IsZoomed(this.handle)) {
                return;
            }
            OS.ShowWindow(this.handle, this.swFlags);
            OS.UpdateWindow(this.handle);
        }
    }

    void _setMinimized(boolean bl) {
        if (OS.IsWinCE) {
            return;
        }
        int n = this.swFlags = bl ? 7 : OS.SW_RESTORE;
        if (!OS.IsWindowVisible(this.handle)) {
            return;
        }
        if (bl == OS.IsIconic(this.handle)) {
            return;
        }
        int n2 = this.swFlags;
        if (n2 == 7 && this.handle == OS.GetActiveWindow()) {
            n2 = 6;
        }
        OS.ShowWindow(this.handle, n2);
        OS.UpdateWindow(this.handle);
    }

    void addMenu(Menu menu) {
        if (this.menus == null) {
            this.menus = new Menu[4];
        }
        for (int i = 0; i < this.menus.length; ++i) {
            if (this.menus[i] != null) continue;
            this.menus[i] = menu;
            return;
        }
        Menu[] menuArray = new Menu[this.menus.length + 4];
        menuArray[this.menus.length] = menu;
        System.arraycopy(this.menus, 0, menuArray, 0, this.menus.length);
        this.menus = menuArray;
    }

    void bringToTop() {
        OS.BringWindowToTop(this.handle);
    }

    static int checkStyle(int n) {
        if ((n & 8) != 0) {
            n &= 0xFFFFF30F;
        }
        if (OS.IsWinCE) {
            if ((n & 0x80) != 0) {
                n &= 0xFFFFFF7F;
            }
            if ((n & 0x400) != 0) {
                n &= 0xFFFFFBFF;
            }
            return n;
        }
        if ((n & 0x4C0) != 0) {
            n |= 0x20;
        }
        if ((n & 0x480) != 0) {
            n |= 0x40;
        }
        if ((n & 0x40) != 0) {
            n |= 0x20;
        }
        return n;
    }

    void checkBorder() {
    }

    void checkComposited(Composite composite) {
    }

    void checkOpened() {
        if (!this.opened) {
            this.resized = false;
        }
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    int callWindowProc(int n, int n2, int n3, int n4) {
        if (this.handle == 0) {
            return 0;
        }
        return OS.DefMDIChildProc(n, n2, n3, n4);
    }

    void closeWidget() {
        Event event = new Event();
        this.sendEvent(21, event);
        if (event.doit && !this.isDisposed()) {
            this.dispose();
        }
    }

    int compare(ImageData imageData, ImageData imageData2, int n, int n2, int n3) {
        int n4;
        int n5 = Math.abs(imageData.width - n);
        if (n5 == (n4 = Math.abs(imageData2.width - n))) {
            int n6;
            int n7 = imageData.getTransparencyType();
            if (n7 == (n6 = imageData2.getTransparencyType())) {
                if (imageData.depth == imageData2.depth) {
                    return 0;
                }
                return imageData.depth > imageData2.depth && imageData.depth <= n3 ? -1 : 1;
            }
            if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(5, 1)) {
                if (n7 == 1) {
                    return -1;
                }
                if (n6 == 1) {
                    return 1;
                }
            }
            if (n7 == 2) {
                return -1;
            }
            if (n6 == 2) {
                return 1;
            }
            if (n7 == 4) {
                return -1;
            }
            if (n6 == 4) {
                return 1;
            }
            return 0;
        }
        return n5 < n4 ? -1 : 1;
    }

    Widget computeTabGroup() {
        return this;
    }

    Control computeTabRoot() {
        return this;
    }

    public Rectangle computeTrim(int n, int n2, int n3, int n4) {
        this.checkWidget();
        RECT rECT = new RECT();
        OS.SetRect(rECT, n, n2, n + n3, n2 + n4);
        int n5 = OS.GetWindowLong(this.handle, -16);
        int n6 = OS.GetWindowLong(this.handle, -20);
        boolean bl = OS.IsWinCE ? false : OS.GetMenu(this.handle) != 0;
        OS.AdjustWindowRectEx(rECT, n5, bl, n6);
        if (this.horizontalBar != null) {
            rECT.bottom += OS.GetSystemMetrics(3);
        }
        if (this.verticalBar != null) {
            rECT.right += OS.GetSystemMetrics(2);
        }
        if (bl) {
            RECT rECT2 = new RECT();
            OS.SetRect(rECT2, 0, 0, rECT.right - rECT.left, rECT.bottom - rECT.top);
            OS.SendMessage(this.handle, 131, 0, rECT2);
            while (rECT2.bottom - rECT2.top < n4 && rECT2.bottom - rECT2.top != 0) {
                rECT.top -= OS.GetSystemMetrics(15) - OS.GetSystemMetrics(6);
                OS.SetRect(rECT2, 0, 0, rECT.right - rECT.left, rECT.bottom - rECT.top);
                OS.SendMessage(this.handle, 131, 0, rECT2);
            }
        }
        return new Rectangle(rECT.left, rECT.top, rECT.right - rECT.left, rECT.bottom - rECT.top);
    }

    void createAccelerators() {
        this.nAccel = 0;
        this.hAccel = 0;
        int n = 0;
        MenuItem[] menuItemArray = this.display.items;
        if (this.menuBar == null || menuItemArray == null) {
            if (!OS.IsPPC) {
                return;
            }
            n = 1;
        } else {
            n = OS.IsPPC ? menuItemArray.length + 1 : menuItemArray.length;
        }
        ACCEL aCCEL = new ACCEL();
        byte[] byArray = new byte[ACCEL.sizeof];
        byte[] byArray2 = new byte[n * ACCEL.sizeof];
        if (this.menuBar != null && menuItemArray != null) {
            for (int i = 0; i < menuItemArray.length; ++i) {
                Menu menu;
                MenuItem menuItem = menuItemArray[i];
                if (menuItem == null || menuItem.accelerator == 0) continue;
                if (menu.parent != this) continue;
                for (menu = menuItem.parent; menu != null && menu != this.menuBar; menu = menu.getParentMenu()) {
                }
                if (menu != this.menuBar || !menuItem.fillAccel(aCCEL)) continue;
                OS.MoveMemory(byArray, aCCEL, ACCEL.sizeof);
                System.arraycopy(byArray, 0, byArray2, this.nAccel * ACCEL.sizeof, ACCEL.sizeof);
                ++this.nAccel;
            }
        }
        if (OS.IsPPC) {
            aCCEL.fVirt = (byte)9;
            aCCEL.key = (short)81;
            aCCEL.cmd = 1;
            OS.MoveMemory(byArray, aCCEL, ACCEL.sizeof);
            System.arraycopy(byArray, 0, byArray2, this.nAccel * ACCEL.sizeof, ACCEL.sizeof);
            ++this.nAccel;
        }
        if (this.nAccel != 0) {
            this.hAccel = OS.CreateAcceleratorTable(byArray2, this.nAccel);
        }
    }

    void createHandle() {
        super.createHandle();
        if (this.parent != null || (this.style & 4) != 0) {
            this.setParent();
            this.setSystemMenu();
        }
    }

    void createWidget() {
        super.createWidget();
        this.swFlags = OS.IsWinCE ? OS.SW_SHOWMAXIMIZED : 4;
        this.hAccel = -1;
    }

    void destroyAccelerators() {
        if (this.hAccel != 0 && this.hAccel != -1) {
            OS.DestroyAcceleratorTable(this.hAccel);
        }
        this.hAccel = -1;
    }

    public void dispose() {
        if (this.isDisposed()) {
            return;
        }
        if (!this.isValidThread()) {
            this.error(22);
        }
        if (!(this instanceof Shell)) {
            if (!this.traverseDecorations(true)) {
                Shell shell = this.getShell();
                shell.setFocus();
            }
            this.setVisible(false);
        }
        super.dispose();
    }

    Menu findMenu(int n) {
        if (this.menus == null) {
            return null;
        }
        for (int i = 0; i < this.menus.length; ++i) {
            Menu menu = this.menus[i];
            if (menu == null || n != menu.handle) continue;
            return menu;
        }
        return null;
    }

    void fixDecorations(Decorations decorations, Control control, Menu[] menuArray) {
        if (this == decorations) {
            return;
        }
        if (control == this.savedFocus) {
            this.savedFocus = null;
        }
        if (control == this.defaultButton) {
            this.defaultButton = null;
        }
        if (control == this.saveDefault) {
            this.saveDefault = null;
        }
        if (menuArray == null) {
            return;
        }
        Menu menu = control.menu;
        if (menu != null) {
            for (int i = 0; i < menuArray.length; ++i) {
                if (menuArray[i] != menu) continue;
                control.setMenu(null);
                return;
            }
            menu.fixMenus(decorations);
            this.destroyAccelerators();
            decorations.destroyAccelerators();
        }
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            WINDOWPLACEMENT wINDOWPLACEMENT = new WINDOWPLACEMENT();
            wINDOWPLACEMENT.length = WINDOWPLACEMENT.sizeof;
            OS.GetWindowPlacement(this.handle, wINDOWPLACEMENT);
            if ((wINDOWPLACEMENT.flags & 2) != 0) {
                int n = this.maxRect.right - this.maxRect.left;
                int n2 = this.maxRect.bottom - this.maxRect.top;
                return new Rectangle(this.maxRect.left, this.maxRect.top, n, n2);
            }
            int n = wINDOWPLACEMENT.right - wINDOWPLACEMENT.left;
            int n3 = wINDOWPLACEMENT.bottom - wINDOWPLACEMENT.top;
            return new Rectangle(wINDOWPLACEMENT.left, wINDOWPLACEMENT.top, n, n3);
        }
        return super.getBounds();
    }

    public Rectangle getClientArea() {
        this.checkWidget();
        if (OS.IsHPC) {
            Rectangle rectangle = super.getClientArea();
            if (this.menuBar != null) {
                int n = this.menuBar.hwndCB;
                int n2 = OS.CommandBar_Height(n);
                rectangle.y += n2;
                rectangle.height = Math.max(0, rectangle.height - n2);
            }
            return rectangle;
        }
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            WINDOWPLACEMENT wINDOWPLACEMENT = new WINDOWPLACEMENT();
            wINDOWPLACEMENT.length = WINDOWPLACEMENT.sizeof;
            OS.GetWindowPlacement(this.handle, wINDOWPLACEMENT);
            if ((wINDOWPLACEMENT.flags & 2) != 0) {
                return new Rectangle(0, 0, this.oldWidth, this.oldHeight);
            }
            int n = wINDOWPLACEMENT.right - wINDOWPLACEMENT.left;
            int n3 = wINDOWPLACEMENT.bottom - wINDOWPLACEMENT.top;
            if (this.horizontalBar != null) {
                n -= OS.GetSystemMetrics(3);
            }
            if (this.verticalBar != null) {
                n3 -= OS.GetSystemMetrics(2);
            }
            RECT rECT = new RECT();
            int n4 = OS.GetWindowLong(this.handle, -16);
            int n5 = OS.GetWindowLong(this.handle, -20);
            boolean bl = OS.IsWinCE ? false : OS.GetMenu(this.handle) != 0;
            OS.AdjustWindowRectEx(rECT, n4, bl, n5);
            n = Math.max(0, n - (rECT.right - rECT.left));
            n3 = Math.max(0, n3 - (rECT.bottom - rECT.top));
            return new Rectangle(0, 0, n, n3);
        }
        return super.getClientArea();
    }

    public Button getDefaultButton() {
        this.checkWidget();
        if (this.defaultButton != null && this.defaultButton.isDisposed()) {
            return null;
        }
        return this.defaultButton;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Image[] getImages() {
        this.checkWidget();
        if (this.images == null) {
            return new Image[0];
        }
        Image[] imageArray = new Image[this.images.length];
        System.arraycopy(this.images, 0, imageArray, 0, this.images.length);
        return imageArray;
    }

    public Point getLocation() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            WINDOWPLACEMENT wINDOWPLACEMENT = new WINDOWPLACEMENT();
            wINDOWPLACEMENT.length = WINDOWPLACEMENT.sizeof;
            OS.GetWindowPlacement(this.handle, wINDOWPLACEMENT);
            if ((wINDOWPLACEMENT.flags & 2) != 0) {
                return new Point(this.maxRect.left, this.maxRect.top);
            }
            return new Point(wINDOWPLACEMENT.left, wINDOWPLACEMENT.top);
        }
        return super.getLocation();
    }

    public boolean getMaximized() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return this.swFlags == OS.SW_SHOWMAXIMIZED;
        }
        if (OS.IsWindowVisible(this.handle)) {
            return OS.IsZoomed(this.handle);
        }
        return this.swFlags == OS.SW_SHOWMAXIMIZED;
    }

    public Menu getMenuBar() {
        this.checkWidget();
        return this.menuBar;
    }

    public boolean getMinimized() {
        this.checkWidget();
        if (OS.IsWinCE) {
            return false;
        }
        if (OS.IsWindowVisible(this.handle)) {
            return OS.IsIconic(this.handle);
        }
        return this.swFlags == 7;
    }

    String getNameText() {
        return this.getText();
    }

    public Point getSize() {
        this.checkWidget();
        if (!OS.IsWinCE && OS.IsIconic(this.handle)) {
            WINDOWPLACEMENT wINDOWPLACEMENT = new WINDOWPLACEMENT();
            wINDOWPLACEMENT.length = WINDOWPLACEMENT.sizeof;
            OS.GetWindowPlacement(this.handle, wINDOWPLACEMENT);
            if ((wINDOWPLACEMENT.flags & 2) != 0) {
                int n = this.maxRect.right - this.maxRect.left;
                int n2 = this.maxRect.bottom - this.maxRect.top;
                return new Point(n, n2);
            }
            int n = wINDOWPLACEMENT.right - wINDOWPLACEMENT.left;
            int n3 = wINDOWPLACEMENT.bottom - wINDOWPLACEMENT.top;
            return new Point(n, n3);
        }
        return super.getSize();
    }

    public String getText() {
        this.checkWidget();
        int n = OS.GetWindowTextLength(this.handle);
        if (n == 0) {
            return "";
        }
        TCHAR tCHAR = new TCHAR(0, n + 1);
        OS.GetWindowText(this.handle, tCHAR, n + 1);
        return tCHAR.toString(0, n);
    }

    public boolean isReparentable() {
        this.checkWidget();
        return false;
    }

    boolean isTabGroup() {
        return true;
    }

    boolean isTabItem() {
        return false;
    }

    Decorations menuShell() {
        return this;
    }

    void releaseChildren(boolean bl) {
        if (this.menuBar != null) {
            this.menuBar.release(false);
            this.menuBar = null;
        }
        super.releaseChildren(bl);
        if (this.menus != null) {
            for (int i = 0; i < this.menus.length; ++i) {
                Menu menu = this.menus[i];
                if (menu == null || menu.isDisposed()) continue;
                menu.dispose();
            }
            this.menus = null;
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        if (this.smallImage != null) {
            this.smallImage.dispose();
        }
        if (this.largeImage != null) {
            this.largeImage.dispose();
        }
        this.image = null;
        this.largeImage = null;
        this.smallImage = null;
        this.images = null;
        this.savedFocus = null;
        this.saveDefault = null;
        this.defaultButton = null;
        if (this.hAccel != 0 && this.hAccel != -1) {
            OS.DestroyAcceleratorTable(this.hAccel);
        }
        this.hAccel = -1;
    }

    void removeMenu(Menu menu) {
        if (this.menus == null) {
            return;
        }
        for (int i = 0; i < this.menus.length; ++i) {
            if (this.menus[i] != menu) continue;
            this.menus[i] = null;
            return;
        }
    }

    void reskinChildren(int n) {
        if (this.menuBar != null) {
            this.menuBar.reskin(n);
        }
        if (this.menus != null) {
            for (int i = 0; i < this.menus.length; ++i) {
                Menu menu = this.menus[i];
                if (menu == null) continue;
                menu.reskin(n);
            }
        }
        super.reskinChildren(n);
    }

    boolean restoreFocus() {
        if (this.display.ignoreRestoreFocus) {
            return true;
        }
        if (this.savedFocus != null && this.savedFocus.isDisposed()) {
            this.savedFocus = null;
        }
        return this.savedFocus != null && this.savedFocus.setSavedFocus();
    }

    void saveFocus() {
        Control control = this.display._getFocusControl();
        if (control != null && control != this && this == control.menuShell()) {
            this.setSavedFocus(control);
        }
    }

    void setBounds(int n, int n2, int n3, int n4, int n5, boolean bl) {
        this.swFlags = 4;
        if (OS.IsWinCE) {
            this.swFlags = OS.SW_RESTORE;
        } else if (OS.IsIconic(this.handle)) {
            this.setPlacement(n, n2, n3, n4, n5);
            return;
        }
        this.forceResize();
        RECT rECT = new RECT();
        OS.GetWindowRect(this.handle, rECT);
        boolean bl2 = true;
        if ((2 & n5) == 0) {
            boolean bl3 = bl2 = rECT.left == n && rECT.top == n2;
            if (!bl2) {
                this.moved = true;
            }
        }
        boolean bl4 = true;
        if ((1 & n5) == 0) {
            boolean bl5 = bl4 = rECT.right - rECT.left == n3 && rECT.bottom - rECT.top == n4;
            if (!bl4) {
                this.resized = true;
            }
        }
        if (!OS.IsWinCE && OS.IsZoomed(this.handle)) {
            if (bl2 && bl4) {
                return;
            }
            this.setPlacement(n, n2, n3, n4, n5);
            this._setMaximized(false);
            return;
        }
        super.setBounds(n, n2, n3, n4, n5, bl);
    }

    public void setDefaultButton(Button button) {
        this.checkWidget();
        if (button != null) {
            if (button.isDisposed()) {
                this.error(5);
            }
            if (button.menuShell() != this) {
                this.error(32);
            }
        }
        this.setDefaultButton(button, true);
    }

    void setDefaultButton(Button button, boolean bl) {
        if (button == null) {
            if (this.defaultButton == this.saveDefault) {
                if (bl) {
                    this.saveDefault = null;
                }
                return;
            }
        } else {
            if ((button.style & 8) == 0) {
                return;
            }
            if (button == this.defaultButton) {
                if (bl) {
                    this.saveDefault = this.defaultButton;
                }
                return;
            }
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(false);
        }
        if ((this.defaultButton = button) == null) {
            this.defaultButton = this.saveDefault;
        }
        if (this.defaultButton != null && !this.defaultButton.isDisposed()) {
            this.defaultButton.setDefault(true);
        }
        if (bl) {
            this.saveDefault = this.defaultButton;
        }
        if (this.saveDefault != null && this.saveDefault.isDisposed()) {
            this.saveDefault = null;
        }
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        this.setImages(image, null);
    }

    void setImages(Image image, Image[] imageArray) {
        int n;
        if (OS.IsWinCE) {
            return;
        }
        if (this.smallImage != null) {
            this.smallImage.dispose();
        }
        if (this.largeImage != null) {
            this.largeImage.dispose();
        }
        this.largeImage = null;
        this.smallImage = null;
        int n2 = 0;
        int n3 = 0;
        Image image2 = null;
        Image image3 = null;
        if (image != null) {
            image2 = image3 = image;
        } else if (imageArray != null && imageArray.length > 0) {
            n = this.display.getIconDepth();
            ImageData[] imageDataArray = null;
            if (imageArray.length > 1) {
                Image[] imageArray2 = new Image[imageArray.length];
                System.arraycopy(imageArray, 0, imageArray2, 0, imageArray.length);
                imageDataArray = new ImageData[imageArray.length];
                for (int i = 0; i < imageDataArray.length; ++i) {
                    imageDataArray[i] = imageArray[i].getImageData();
                }
                imageArray = imageArray2;
                this.sort(imageArray, imageDataArray, OS.GetSystemMetrics(49), OS.GetSystemMetrics(50), n);
            }
            image2 = imageArray[0];
            if (imageArray.length > 1) {
                this.sort(imageArray, imageDataArray, OS.GetSystemMetrics(11), OS.GetSystemMetrics(12), n);
            }
            image3 = imageArray[0];
        }
        if (image2 != null) {
            switch (image2.type) {
                case 0: {
                    this.smallImage = Display.createIcon(image2);
                    n2 = this.smallImage.handle;
                    break;
                }
                case 1: {
                    n2 = image2.handle;
                }
            }
        }
        OS.SendMessage(this.handle, 128, 0, n2);
        if (image3 != null) {
            switch (image3.type) {
                case 0: {
                    this.largeImage = Display.createIcon(image3);
                    n3 = this.largeImage.handle;
                    break;
                }
                case 1: {
                    n3 = image3.handle;
                }
            }
        }
        OS.SendMessage(this.handle, 128, 1, n3);
        if (!OS.IsWinCE && n2 == 0 && n3 == 0 && (this.style & 0x800) != 0) {
            n = 1025;
            OS.RedrawWindow(this.handle, null, 0, n);
        }
    }

    public void setImages(Image[] imageArray) {
        this.checkWidget();
        if (imageArray == null) {
            this.error(5);
        }
        for (int i = 0; i < imageArray.length; ++i) {
            if (imageArray[i] != null && !imageArray[i].isDisposed()) continue;
            this.error(5);
        }
        this.images = imageArray;
        this.setImages(null, imageArray);
    }

    public void setMaximized(boolean bl) {
        this.checkWidget();
        Display.lpStartupInfo = null;
        this._setMaximized(bl);
    }

    public void setMenuBar(Menu menu) {
        this.checkWidget();
        if (this.menuBar == menu) {
            return;
        }
        if (menu != null) {
            if (menu.isDisposed()) {
                this.error(5);
            }
            if ((menu.style & 2) == 0) {
                this.error(33);
            }
            if (menu.parent != this) {
                this.error(32);
            }
        }
        if (OS.IsWinCE) {
            if (OS.IsHPC) {
                boolean bl;
                boolean bl2 = bl = this.menuBar != menu;
                if (this.menuBar != null) {
                    OS.CommandBar_Show(this.menuBar.hwndCB, false);
                }
                this.menuBar = menu;
                if (this.menuBar != null) {
                    OS.CommandBar_Show(this.menuBar.hwndCB, true);
                }
                if (bl) {
                    this.sendEvent(11);
                    if (this.isDisposed()) {
                        return;
                    }
                    if (this.layout != null) {
                        this.markLayout(false, false);
                        this.updateLayout(true, false);
                    }
                }
            } else {
                if (OS.IsPPC) {
                    boolean bl;
                    boolean bl3 = bl = this.getMaximized() && this.menuBar != menu;
                    if (this.menuBar != null) {
                        OS.ShowWindow(this.menuBar.hwndCB, 0);
                    }
                    this.menuBar = menu;
                    if (this.menuBar != null) {
                        OS.ShowWindow(this.menuBar.hwndCB, 5);
                    }
                    if (bl) {
                        this._setMaximized(true);
                    }
                }
                if (OS.IsSP) {
                    if (this.menuBar != null) {
                        OS.ShowWindow(this.menuBar.hwndCB, 0);
                    }
                    this.menuBar = menu;
                    if (this.menuBar != null) {
                        OS.ShowWindow(this.menuBar.hwndCB, 5);
                    }
                }
            }
        } else {
            if (menu != null) {
                this.display.removeBar(menu);
            }
            this.menuBar = menu;
            int n = this.menuBar != null ? this.menuBar.handle : 0;
            OS.SetMenu(this.handle, n);
        }
        this.destroyAccelerators();
    }

    public void setMinimized(boolean bl) {
        this.checkWidget();
        Display.lpStartupInfo = null;
        this._setMinimized(bl);
    }

    public void setOrientation(int n) {
        super.setOrientation(n);
        if (this.menus != null) {
            for (int i = 0; i < this.menus.length; ++i) {
                Menu menu = this.menus[i];
                if (menu == null || menu.isDisposed() || (menu.getStyle() & 8) == 0) continue;
                menu._setOrientation(menu.getOrientation());
            }
        }
    }

    void setParent() {
        int n = this.parent.handle;
        this.display.lockActiveWindow = true;
        OS.SetParent(this.handle, n);
        if (!OS.IsWindowVisible(n)) {
            OS.ShowWindow(this.handle, 8);
        }
        int n2 = OS.GetWindowLong(this.handle, -16);
        OS.SetWindowLong(this.handle, -16, (n2 &= 0xBFFFFFFF) | Integer.MIN_VALUE);
        OS.SetWindowLongPtr(this.handle, -12, 0);
        int n3 = 19;
        this.SetWindowPos(this.handle, 1, 0, 0, 0, 0, n3);
        this.display.lockActiveWindow = false;
    }

    void setPlacement(int n, int n2, int n3, int n4, int n5) {
        WINDOWPLACEMENT wINDOWPLACEMENT = new WINDOWPLACEMENT();
        wINDOWPLACEMENT.length = WINDOWPLACEMENT.sizeof;
        OS.GetWindowPlacement(this.handle, wINDOWPLACEMENT);
        wINDOWPLACEMENT.showCmd = 8;
        if (OS.IsIconic(this.handle)) {
            wINDOWPLACEMENT.showCmd = 7;
        } else if (OS.IsZoomed(this.handle)) {
            wINDOWPLACEMENT.showCmd = OS.SW_SHOWMAXIMIZED;
        }
        boolean bl = true;
        if ((n5 & 2) == 0) {
            bl = wINDOWPLACEMENT.left != n || wINDOWPLACEMENT.top != n2;
            wINDOWPLACEMENT.right = n + (wINDOWPLACEMENT.right - wINDOWPLACEMENT.left);
            wINDOWPLACEMENT.bottom = n2 + (wINDOWPLACEMENT.bottom - wINDOWPLACEMENT.top);
            wINDOWPLACEMENT.left = n;
            wINDOWPLACEMENT.top = n2;
        }
        boolean bl2 = true;
        if ((n5 & 1) == 0) {
            bl2 = wINDOWPLACEMENT.right - wINDOWPLACEMENT.left != n3 || wINDOWPLACEMENT.bottom - wINDOWPLACEMENT.top != n4;
            wINDOWPLACEMENT.right = wINDOWPLACEMENT.left + n3;
            wINDOWPLACEMENT.bottom = wINDOWPLACEMENT.top + n4;
        }
        OS.SetWindowPlacement(this.handle, wINDOWPLACEMENT);
        if (OS.IsIconic(this.handle)) {
            SerializableCompatibility serializableCompatibility;
            if (bl) {
                this.moved = true;
                serializableCompatibility = this.getLocation();
                this.oldX = serializableCompatibility.x;
                this.oldY = serializableCompatibility.y;
                this.sendEvent(10);
                if (this.isDisposed()) {
                    return;
                }
            }
            if (bl2) {
                this.resized = true;
                serializableCompatibility = this.getClientArea();
                this.oldWidth = ((Rectangle)serializableCompatibility).width;
                this.oldHeight = ((Rectangle)serializableCompatibility).height;
                this.sendEvent(11);
                if (this.isDisposed()) {
                    return;
                }
                if (this.layout != null) {
                    this.markLayout(false, false);
                    this.updateLayout(true, false);
                }
            }
        }
    }

    void setSavedFocus(Control control) {
        this.savedFocus = control;
    }

    void setSystemMenu() {
        if (OS.IsWinCE) {
            return;
        }
        int n = OS.GetSystemMenu(this.handle, false);
        if (n == 0) {
            return;
        }
        int n2 = OS.GetMenuItemCount(n);
        if ((this.style & 0x10) == 0) {
            OS.DeleteMenu(n, 61440, 0);
        }
        if ((this.style & 0x80) == 0) {
            OS.DeleteMenu(n, 61472, 0);
        }
        if ((this.style & 0x400) == 0) {
            OS.DeleteMenu(n, 61488, 0);
        }
        if ((this.style & 0x480) == 0) {
            OS.DeleteMenu(n, 61728, 0);
        }
        int n3 = OS.GetMenuItemCount(n);
        if ((this.style & 0x40) == 0 || n3 != n2) {
            int n4;
            OS.DeleteMenu(n, 61744, 0);
            MENUITEMINFO mENUITEMINFO = new MENUITEMINFO();
            mENUITEMINFO.cbSize = MENUITEMINFO.sizeof;
            mENUITEMINFO.fMask = 2;
            for (n4 = 0; !(n4 >= n3 || OS.GetMenuItemInfo(n, n4, true, mENUITEMINFO) && mENUITEMINFO.wID == 61536); ++n4) {
            }
            if (n4 != n3) {
                OS.DeleteMenu(n, n4 - 1, 1024);
                if ((this.style & 0x40) == 0) {
                    OS.DeleteMenu(n, 61536, 0);
                }
            }
        }
    }

    public void setText(String string) {
        this.checkWidget();
        if (string == null) {
            this.error(4);
        }
        TCHAR tCHAR = new TCHAR(0, string, true);
        if ((this.state & 0x4000) != 0) {
            int n = OS.GetProcessHeap();
            int n2 = tCHAR.length() * TCHAR.sizeof;
            int n3 = OS.HeapAlloc(n, 8, n2);
            OS.MoveMemory(n3, tCHAR, n2);
            OS.DefWindowProc(this.handle, 12, 0, n3);
            if (n3 != 0) {
                OS.HeapFree(n, 0, n3);
            }
        } else {
            OS.SetWindowText(this.handle, tCHAR);
        }
        if ((this.state & 0x400000) != 0) {
            this.updateTextDirection(0x6000000);
        }
    }

    public void setVisible(boolean bl) {
        this.checkWidget();
        if (!this.getDrawing() ? (this.state & 0x10) == 0 == bl : bl == OS.IsWindowVisible(this.handle)) {
            return;
        }
        if (bl) {
            int n;
            this.sendEvent(22);
            if (this.isDisposed()) {
                return;
            }
            if (OS.IsHPC && this.menuBar != null) {
                n = this.menuBar.hwndCB;
                OS.CommandBar_DrawMenuBar(n, 0);
            }
            if (!this.getDrawing()) {
                this.state &= 0xFFFFFFEF;
            } else {
                if (OS.IsWinCE) {
                    OS.ShowWindow(this.handle, 5);
                } else {
                    STARTUPINFO sTARTUPINFO;
                    if (this.menuBar != null) {
                        this.display.removeBar(this.menuBar);
                        OS.DrawMenuBar(this.handle);
                    }
                    if ((sTARTUPINFO = Display.lpStartupInfo) != null && (sTARTUPINFO.dwFlags & 1) != 0) {
                        OS.ShowWindow(this.handle, sTARTUPINFO.wShowWindow);
                    } else {
                        OS.ShowWindow(this.handle, this.swFlags);
                    }
                }
                if (this.isDisposed()) {
                    return;
                }
                this.opened = true;
                if (!this.moved) {
                    this.moved = true;
                    Point point = this.getLocation();
                    this.oldX = point.x;
                    this.oldY = point.y;
                }
                if (!this.resized) {
                    this.resized = true;
                    Rectangle rectangle = this.getClientArea();
                    this.oldWidth = rectangle.width;
                    this.oldHeight = rectangle.height;
                }
                n = 1;
                if (!OS.IsWinCE && OS.WIN32_VERSION >= OS.VERSION(6, 0) && !OS.IsAppThemed()) {
                    int n2 = n = !OS.IsHungAppWindow(this.handle) ? 1 : 0;
                }
                if (n != 0) {
                    OS.UpdateWindow(this.handle);
                }
            }
        } else {
            if (!OS.IsWinCE) {
                this.swFlags = OS.IsIconic(this.handle) ? 7 : (OS.IsZoomed(this.handle) ? OS.SW_SHOWMAXIMIZED : 4);
            }
            if (!this.getDrawing()) {
                this.state |= 0x10;
            } else {
                OS.ShowWindow(this.handle, 0);
            }
            if (this.isDisposed()) {
                return;
            }
            this.sendEvent(23);
        }
    }

    void sort(Image[] imageArray, ImageData[] imageDataArray, int n, int n2, int n3) {
        int n4 = imageArray.length;
        if (n4 <= 1) {
            return;
        }
        for (int i = n4 / 2; i > 0; i /= 2) {
            for (int j = i; j < n4; ++j) {
                for (int k = j - i; k >= 0; k -= i) {
                    if (this.compare(imageDataArray[k], imageDataArray[k + i], n, n2, n3) < 0) continue;
                    Image image = imageArray[k];
                    imageArray[k] = imageArray[k + i];
                    imageArray[k + i] = image;
                    ImageData imageData = imageDataArray[k];
                    imageDataArray[k] = imageDataArray[k + i];
                    imageDataArray[k + i] = imageData;
                }
            }
        }
    }

    boolean translateAccelerator(MSG mSG) {
        if (!this.isEnabled() || !this.isActive()) {
            return false;
        }
        if (this.menuBar != null && !this.menuBar.isEnabled()) {
            return false;
        }
        if (this.translateMDIAccelerator(mSG) || this.translateMenuAccelerator(mSG)) {
            return true;
        }
        Decorations decorations = this.parent.menuShell();
        return decorations.translateAccelerator(mSG);
    }

    boolean translateMenuAccelerator(MSG mSG) {
        if (this.hAccel == -1) {
            this.createAccelerators();
        }
        return this.hAccel != 0 && OS.TranslateAccelerator(this.handle, this.hAccel, mSG) != 0;
    }

    boolean translateMDIAccelerator(MSG mSG) {
        if (!(this instanceof Shell)) {
            Shell shell = this.getShell();
            int n = shell.hwndMDIClient;
            if (n != 0 && OS.TranslateMDISysAccel(n, mSG)) {
                return true;
            }
            if (mSG.message == 256) {
                if (OS.GetKeyState(17) >= 0) {
                    return false;
                }
                switch (mSG.wParam) {
                    case 115: {
                        OS.PostMessage(this.handle, 16, 0, 0);
                        return true;
                    }
                    case 117: {
                        if (!this.traverseDecorations(true)) break;
                        return true;
                    }
                }
                return false;
            }
            if (mSG.message == 260) {
                switch (mSG.wParam) {
                    case 115: {
                        OS.PostMessage(shell.handle, 16, 0, 0);
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    boolean traverseDecorations(boolean bl) {
        int n;
        int n2;
        Control[] controlArray = this.parent._getChildren();
        int n3 = controlArray.length;
        for (n2 = 0; n2 < n3 && controlArray[n2] != this; ++n2) {
        }
        int n4 = n2;
        int n5 = n = bl ? 1 : -1;
        while ((n2 = (n2 + n + n3) % n3) != n4) {
            Control control = controlArray[n2];
            if (control.isDisposed() || !(control instanceof Decorations) || !control.setFocus()) continue;
            return true;
        }
        return false;
    }

    boolean traverseItem(boolean bl) {
        return false;
    }

    boolean traverseReturn() {
        if (this.defaultButton == null || this.defaultButton.isDisposed()) {
            return false;
        }
        if (!this.defaultButton.isVisible() || !this.defaultButton.isEnabled()) {
            return false;
        }
        this.defaultButton.click();
        return true;
    }

    CREATESTRUCT widgetCreateStruct() {
        return new CREATESTRUCT();
    }

    int widgetExtStyle() {
        int n = super.widgetExtStyle() | 0x40;
        n &= 0xFFFFFDFF;
        if ((this.style & 8) != 0) {
            return n;
        }
        if (OS.IsPPC && (this.style & 0x40) != 0) {
            n |= Integer.MIN_VALUE;
        }
        if ((this.style & 0x10) != 0) {
            return n;
        }
        if ((this.style & 0x800) != 0) {
            n |= 1;
        }
        return n;
    }

    int widgetParent() {
        Shell shell = this.getShell();
        return shell.hwndMDIClient();
    }

    int widgetStyle() {
        int n = super.widgetStyle() & 0xEFFEFFFF;
        n &= 0xFF7FFFFF;
        if ((this.style & 8) != 0) {
            if (this.parent == null) {
                n |= 0x80000 | OS.WS_MINIMIZEBOX;
            }
            return n;
        }
        if ((this.style & 0x20) != 0) {
            n |= 0xC00000;
        }
        if ((this.style & 0x80) != 0) {
            n |= OS.WS_MINIMIZEBOX;
        }
        if ((this.style & 0x400) != 0) {
            n |= OS.WS_MAXIMIZEBOX;
        }
        if ((this.style & 0x10) != 0) {
            if (!OS.IsPPC) {
                n |= 0x40000;
            }
        } else if ((this.style & 0x800) == 0) {
            n |= 0x800000;
        }
        if (!OS.IsPPC && !OS.IsSP && (this.style & 0x40) != 0) {
            n |= 0x80000;
        }
        return n;
    }

    int windowProc(int n, int n2, int n3, int n4) {
        switch (n2) {
            case 32768: 
            case 32769: {
                if (this.hAccel == -1) {
                    this.createAccelerators();
                }
                return n2 == 32768 ? this.nAccel : this.hAccel;
            }
        }
        return super.windowProc(n, n2, n3, n4);
    }

    LRESULT WM_ACTIVATE(int n, int n2) {
        int n3;
        Object object;
        LRESULT lRESULT = super.WM_ACTIVATE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.GetParent(n2) == this.handle) {
            TCHAR tCHAR = new TCHAR(0, 128);
            OS.GetClassName(n2, tCHAR, tCHAR.length());
            object = tCHAR.toString(0, tCHAR.strlen());
            if (((String)object).equals("SunAwtWindow")) {
                return LRESULT.ZERO;
            }
        }
        if ((n3 = OS.LOWORD(n)) != 0) {
            if (OS.HIWORD(n) != 0) {
                return lRESULT;
            }
            object = this.display.findControl(n2);
            if ((object == null || object instanceof Shell) && this instanceof Shell) {
                Event event = new Event();
                event.detail = n3 == 2 ? 3 : 0;
                this.sendEvent(26, event);
                if (this.isDisposed()) {
                    return LRESULT.ZERO;
                }
            }
            if (this.restoreFocus()) {
                return LRESULT.ZERO;
            }
        } else {
            Control control;
            object = this.display;
            boolean bl = ((Display)object).isXMouseActive();
            if (bl) {
                ((Display)object).lockActiveWindow = true;
            }
            if (((control = ((Display)object).findControl(n2)) == null || control instanceof Shell) && this instanceof Shell) {
                this.sendEvent(27);
                if (!this.isDisposed()) {
                    Shell shell = this.getShell();
                    shell.setActiveControl(null);
                }
            }
            if (bl) {
                ((Display)object).lockActiveWindow = false;
            }
            if (this.isDisposed()) {
                return LRESULT.ZERO;
            }
            this.saveFocus();
        }
        return lRESULT;
    }

    LRESULT WM_CLOSE(int n, int n2) {
        LRESULT lRESULT = super.WM_CLOSE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.isEnabled() && this.isActive()) {
            this.closeWidget();
        }
        return LRESULT.ZERO;
    }

    LRESULT WM_HOTKEY(int n, int n2) {
        LRESULT lRESULT = super.WM_HOTKEY(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (OS.IsSP && OS.HIWORD(n2) == 27) {
            if ((this.style & 0x40) != 0) {
                OS.PostMessage(this.handle, 16, 0, 0);
            } else {
                OS.SHSendBackToFocusWindow(786, n, n2);
            }
            return LRESULT.ZERO;
        }
        return lRESULT;
    }

    LRESULT WM_KILLFOCUS(int n, int n2) {
        LRESULT lRESULT = super.WM_KILLFOCUS(n, n2);
        this.saveFocus();
        return lRESULT;
    }

    LRESULT WM_MOVE(int n, int n2) {
        if (this.moved) {
            Point point = this.getLocation();
            if (point.x == this.oldX && point.y == this.oldY) {
                return null;
            }
            this.oldX = point.x;
            this.oldY = point.y;
        }
        return super.WM_MOVE(n, n2);
    }

    LRESULT WM_NCACTIVATE(int n, int n2) {
        LRESULT lRESULT = super.WM_NCACTIVATE(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (n == 0) {
            if (this.display.lockActiveWindow) {
                return LRESULT.ZERO;
            }
            Control control = this.display.findControl(n2);
            if (control != null) {
                Shell shell = this.getShell();
                Decorations decorations = control.menuShell();
                if (decorations.getShell() == shell) {
                    if (this instanceof Shell) {
                        return LRESULT.ONE;
                    }
                    if (this.display.ignoreRestoreFocus && this.display.lastHittest != 1) {
                        lRESULT = LRESULT.ONE;
                    }
                }
            }
        }
        if (!(this instanceof Shell)) {
            int n3 = this.getShell().handle;
            OS.SendMessage(n3, 134, n, n2);
        }
        return lRESULT;
    }

    LRESULT WM_QUERYOPEN(int n, int n2) {
        LRESULT lRESULT = super.WM_QUERYOPEN(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        this.sendEvent(20);
        return lRESULT;
    }

    LRESULT WM_SETFOCUS(int n, int n2) {
        LRESULT lRESULT = super.WM_SETFOCUS(n, n2);
        if (this.isDisposed()) {
            return lRESULT;
        }
        if (this.savedFocus != this) {
            this.restoreFocus();
        }
        return lRESULT;
    }

    LRESULT WM_SIZE(int n, int n2) {
        LRESULT lRESULT = null;
        boolean bl = true;
        if (this.resized) {
            int n3 = 0;
            int n4 = 0;
            switch (n) {
                case 2: {
                    OS.GetWindowRect(this.handle, this.maxRect);
                }
                case 0: {
                    n3 = OS.LOWORD(n2);
                    n4 = OS.HIWORD(n2);
                    break;
                }
                case 1: {
                    Rectangle rectangle = this.getClientArea();
                    n3 = rectangle.width;
                    n4 = rectangle.height;
                }
            }
            boolean bl2 = bl = n3 != this.oldWidth || n4 != this.oldHeight;
            if (bl) {
                this.oldWidth = n3;
                this.oldHeight = n4;
            }
        }
        if (bl) {
            lRESULT = super.WM_SIZE(n, n2);
            if (this.isDisposed()) {
                return lRESULT;
            }
        }
        if (n == 1) {
            this.sendEvent(19);
        }
        return lRESULT;
    }

    LRESULT WM_SYSCOMMAND(int n, int n2) {
        LRESULT lRESULT = super.WM_SYSCOMMAND(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (!(this instanceof Shell)) {
            int n3 = n & 0xFFF0;
            switch (n3) {
                case 61536: {
                    OS.PostMessage(this.handle, 16, 0, 0);
                    return LRESULT.ZERO;
                }
                case 61504: {
                    this.traverseDecorations(true);
                    return LRESULT.ZERO;
                }
            }
        }
        return lRESULT;
    }

    LRESULT WM_WINDOWPOSCHANGING(int n, int n2) {
        LRESULT lRESULT = super.WM_WINDOWPOSCHANGING(n, n2);
        if (lRESULT != null) {
            return lRESULT;
        }
        if (this.display.lockActiveWindow) {
            WINDOWPOS wINDOWPOS = new WINDOWPOS();
            OS.MoveMemory(wINDOWPOS, n2, WINDOWPOS.sizeof);
            wINDOWPOS.flags |= 4;
            OS.MoveMemory(n2, wINDOWPOS, WINDOWPOS.sizeof);
        }
        return lRESULT;
    }
}

