/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli.utils;

import com.google.protobuf.GeneratedMessage;
import org.json.simple.JSONObject;
import org.tizen.cli.CLIManager;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.sock.SocketClient;
import org.tizen.ecp.sock.SocketMessage;

public class AcquireInfoThread
implements Runnable,
ILsn {
    private int port;
    private Thread th;
    boolean isRun = true;
    private static final String VMINFO = "vminfo";

    public AcquireInfoThread() {
        EventMgr.getInstance().AddLsn(VMINFO, (ILsn)this);
    }

    @Override
    public void run() {
        OutputUtil.debug("AcquireInfoThread - starts.");
        if (!SocketClient.getInstance().connect(this.port)) {
            OutputUtil.debug("failed to connect to port : " + this.port);
            return;
        }
        this.th = new Thread(null, (Runnable)new SocketMessage(), "Socket Message Thread");
        this.th.start();
        OutputUtil.debug("AcquireInfoThread - connect.");
        MessageSender.getInstance().sendDeviceReq(VMINFO, 0, 0);
        OutputUtil.debug("AcquireInfoThread - request vmname.");
        while (this.isRun) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
        if (this.th != null) {
            try {
                this.th.join(10L);
            }
            catch (InterruptedException e) {
                return;
            }
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void stopRunning() {
        this.isRun = false;
    }

    public void OnEventProc(String eventname, JSONObject jsParam) {
    }

    public void OnEventProcPB(String eventname, GeneratedMessage param) {
        String[] info = null;
        OutputUtil.debug("AcquireInfoThread - OnEventProcPB.");
        if (param instanceof Ecs.DeviceAns) {
            Ecs.DeviceAns ans = (Ecs.DeviceAns)param;
            String data = ans.getData().toStringUtf8();
            info = data.split(" ");
            OutputUtil.debug("AcquireInfoThread - vmname: " + info[0] + ", profile: " + info[1] + ", version: " + info[2]);
            CLIManager.getInstance().addInfo(info[0], info[1], info[2], this.port);
        }
        OutputUtil.debug("AcquireInfoThread - Name is gotten.");
        SocketClient.getInstance().disconnect();
        this.stopRunning();
        EventMgr.getInstance().RemoveLsn(VMINFO, (ILsn)this);
        OutputUtil.debug("AcquireInfoThread - received.");
    }

    public void OnStatusEventProcPB(GeneratedMessage param) {
    }
}

