/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.views.card;

import java.util.ArrayList;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.scene.image.Image;
import org.tizen.ecp.interfaces.ICardSelection;
import org.tizen.ecp.views.popup.ECPPopupPane;

public class ECPCardModel {
    List<ICardSelection> listeners = new ArrayList<ICardSelection>();
    private String name;
    private final StringProperty title = new SimpleStringProperty();
    private final ObjectProperty<Image> cardImage = new SimpleObjectProperty();
    private final StringProperty desc = new SimpleStringProperty();
    private final BooleanProperty selected = new SimpleBooleanProperty();
    private Image normalImage;
    private Image hoverImage;
    private Image selectedImage;
    private Image activeImage;
    private Image dimImage;
    private boolean hasDialog = false;
    private ECPPopupPane ecpPopupPane;
    private int width = 0;
    private int height = 0;

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        this.name = name;
    }

    public final void setTitle(String title) {
        this.title.set((Object)title);
    }

    public final StringProperty getTitle() {
        return this.title;
    }

    public final void setDefaultImages(Image normal, Image hover, Image selected, Image active, Image dim) {
        this.normalImage = normal;
        this.hoverImage = hover;
        this.selectedImage = selected;
        this.activeImage = active;
        this.dimImage = dim;
        this.setCardImage(normal);
    }

    public final void setCardImage(Image image) {
        this.cardImage.set((Object)image);
    }

    public final ObjectProperty<Image> getCardImage() {
        return this.cardImage;
    }

    public final void setNormalImage() {
        this.cardImage.set((Object)this.normalImage);
    }

    public final void setHoverImage() {
        this.cardImage.set((Object)this.hoverImage);
    }

    public final void setSelectedImage() {
        this.cardImage.set((Object)this.selectedImage);
    }

    public final void setActiveImage() {
        this.cardImage.set((Object)this.activeImage);
    }

    public final void setDimImage() {
        this.cardImage.set((Object)this.dimImage);
    }

    public final void setDescription(String desc) {
        this.desc.set((Object)desc);
    }

    public final StringProperty getDescription() {
        return this.desc;
    }

    public final void setDialog(boolean hasDialog) {
        this.hasDialog = hasDialog;
    }

    public final boolean hasDialog() {
        return this.hasDialog;
    }

    public final BooleanProperty getSelected() {
        return this.selected;
    }

    public final void selected(boolean selection) {
        this.selected(selection, true);
    }

    public final void selected(boolean selection, boolean notice) {
        this.selected.set(selection);
        if (notice) {
            for (ICardSelection listener : this.listeners) {
                listener.cardSelectionChangedListener(selection);
            }
        }
    }

    public void addCardSelectionListener(ICardSelection listener) {
        this.listeners.add(listener);
    }

    public final int getWidth() {
        return this.width;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public final int getHeight() {
        return this.height;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public ECPPopupPane getEcpPopupPane() {
        return this.ecpPopupPane;
    }

    public void setEcpPopupPane(ECPPopupPane ecpPopupPane) {
        this.ecpPopupPane = ecpPopupPane;
    }
}

