/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.views;

import java.util.ArrayList;
import java.util.List;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Pane;
import org.tizen.ecp.interfaces.IPageChanged;
import org.tizen.ecp.resources.ImageKind;
import org.tizen.ecp.resources.Images;

public class ECPPageNavigator {
    private int nItem = -1;
    private int selected = -1;
    private Pane navigatorPane;
    Button previousButton;
    Button nextButton;
    List<IPageChanged> listeners = new ArrayList<IPageChanged>();

    public ECPPageNavigator(Pane nPane, Button pButton, Button nButton) {
        this.navigatorPane = nPane;
        this.previousButton = pButton;
        this.nextButton = nButton;
    }

    public void addPageChangedListener(IPageChanged listener) {
        this.listeners.add(listener);
    }

    public void callListener() {
        for (IPageChanged listener : this.listeners) {
            listener.pageChangedListener(this.nItem, this.selected);
        }
    }

    private void addItem(boolean selected) {
        Label label = new Label();
        ImageView view = selected ? Images.getImageView(ImageKind.INDI_SEL) : Images.getImageView(ImageKind.INDI_NOR);
        label.setGraphic((Node)view);
        this.navigatorPane.getChildren().add((Object)label);
    }

    private void addItems() {
        this.clear();
        if (this.nItem > 0) {
            if (this.selected == 0) {
                this.previousButton.setVisible(false);
            } else {
                this.previousButton.setVisible(true);
            }
        }
        for (int i = 0; i < this.nItem; ++i) {
            if (this.selected == i) {
                this.addItem(true);
                continue;
            }
            this.addItem(false);
        }
        if (this.nItem == 1) {
            this.nextButton.setVisible(false);
        } else if (this.selected == this.nItem - 1) {
            this.nextButton.setVisible(false);
        } else {
            this.nextButton.setVisible(true);
        }
        this.callListener();
    }

    public void setItem(int page, int selectedIndex) {
        if (selectedIndex >= page) {
            return;
        }
        this.nItem = page;
        this.selected = selectedIndex;
        this.addItems();
    }

    public boolean nextPage() {
        int newSelected = this.selected + 1;
        if (newSelected >= this.nItem) {
            return false;
        }
        this.selected = newSelected;
        this.addItems();
        return true;
    }

    public boolean prevPage() {
        int newSelected = this.selected - 1;
        if (newSelected < 0) {
            return false;
        }
        this.selected = newSelected;
        this.addItems();
        return true;
    }

    public int getItempage() {
        return this.selected;
    }

    public void clear() {
        this.navigatorPane.getChildren().clear();
    }
}

