/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp;

import java.nio.file.Path;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.tizen.ecp.ecpinfo.xmls.BaseInformationType;
import org.tizen.ecp.ecpinfo.xmls.DeviceType;
import org.tizen.ecp.ecpinfo.xmls.DevicesType;
import org.tizen.ecp.ecpinfo.xmls.ECPConfiguration;
import org.tizen.ecp.ecpinfo.xmls.ExtensionType;
import org.tizen.ecp.utils.JaxbUtil;

public class ECPInfo {
    private static ECPInfo instance = new ECPInfo();
    ECPConfiguration configuration = null;

    public static ECPInfo getInstance() {
        return instance;
    }

    public void initialize(Path ecpInfoPath) throws JAXBException {
        JAXBElement<?> element = JaxbUtil.unmarshal(ecpInfoPath, ECPConfiguration.class);
        this.configuration = (ECPConfiguration)element.getValue();
    }

    public ECPConfiguration getConfiguration() {
        return this.configuration;
    }

    public BaseInformationType getBaseInfo() {
        if (this.configuration == null) {
            return null;
        }
        return this.configuration.getBaseInformation();
    }

    public DevicesType getDevices() {
        if (this.configuration == null) {
            return null;
        }
        return this.configuration.getDevices();
    }

    public List<DeviceType> getDevice() {
        DevicesType devices = this.getDevices();
        if (devices == null) {
            return null;
        }
        return devices.getDevice();
    }

    public ExtensionType getExtension() {
        BaseInformationType ext = this.getBaseInfo();
        if (ext == null) {
            return null;
        }
        return ext.getExtension();
    }

    public String getExtensionVersion() {
        ExtensionType type = this.getExtension();
        if (type == null) {
            return null;
        }
        return type.getVersion();
    }

    public String getExtensionProfile() {
        ExtensionType type = this.getExtension();
        if (type == null) {
            return null;
        }
        return type.getProfile();
    }
}

