/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.tizen.ecp.ECPInfo;
import org.tizen.ecp.VMInfo;
import org.tizen.ecp.utils.OSUtil;

public class FilePath {
    static final String SDKINFO_PATH = "sdk.info";
    static final String TOOLS_PATH = "tools";
    static final String PLATFORM_PATH = "platforms";
    static final String EMULATOR_PATH = "emulator";
    static final String EMULATOR_RESOURCES_PATH = "emulator-resources";
    static final String VMS_PATH = "vms";
    static final String LOGS_PATH = "logs";
    static final String PLUGINS_PATH = "plugins";
    static final String PLUGIN_FILE = "ecp-plugin";
    static final String JAR_EXTENSION = ".jar";
    static final String XML_EXTENSION = ".xml";
    static final String SDK_INFO_SDK_TOKEN = "TIZEN_SDK_INSTALLED_PATH";
    static final String SDK_INFO_DATA_TOKEN = "TIZEN_SDK_DATA_PATH";
    static final String FILE_PARENT = ".." + File.separator;
    static final String ECP_REL_SDK_PATH = FILE_PARENT + FILE_PARENT + FILE_PARENT;
    static final String PATH_SDK_INFO = ECP_REL_SDK_PATH + File.separator + "sdk.info";
    private static final String LOG_FILE_NAME = "emulator-control-panel.log";
    static Path binPath;
    static Path sdkPath;
    static Path sdkDataPath;
    static Path vmsPath;
    static Path logFile;
    static Path pvPath;
    static Path pluginPath;
    static Path pluginXML;
    static Path pluginJAR;
    static Path parentJAR;
    static Path sdbPath;
    static Path ansiconPath;
    static final FilePath instance;
    public static boolean isDevelop;

    public static FilePath getInstance() {
        return instance;
    }

    private static boolean initSDKPathInfo() throws IOException, URISyntaxException {
        String bin = null;
        bin = FilePath.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath();
        if (OSUtil.isWindowsPlatform() && bin.charAt(0) == '/') {
            bin = bin.substring(1);
        }
        binPath = FilePath.getNomalizedPath(Paths.get(bin, new String[0]).getParent());
        return instance.getSDKInfo();
    }

    public static boolean initializeSDKPath() {
        try {
            FilePath.initSDKPathInfo();
        }
        catch (IOException | URISyntaxException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static boolean initialize(String vmname) {
        if (!FilePath.initializeSDKPath()) {
            return false;
        }
        String profile = VMInfo.getInstance().getProfile();
        String platformVersion = VMInfo.getInstance().getPlatformVersion();
        vmsPath = FilePath.getNomalizedPath(sdkDataPath.resolve(EMULATOR_PATH).resolve(VMS_PATH));
        Path vmPath = vmsPath.resolve(vmname);
        if (!Files.isDirectory(vmPath, new LinkOption[0])) {
            return false;
        }
        logFile = FilePath.getNomalizedPath(vmPath.resolve(LOGS_PATH).resolve(LOG_FILE_NAME));
        pvPath = FilePath.getNomalizedPath(binPath.resolve(ECP_REL_SDK_PATH).resolve(PLATFORM_PATH).resolve(platformVersion));
        pluginPath = FilePath.getNomalizedPath(pvPath.resolve(profile).resolve(EMULATOR_RESOURCES_PATH).resolve(PLUGINS_PATH));
        pluginXML = FilePath.getNomalizedPath(instance.getPluginFile(PLUGIN_FILE, XML_EXTENSION));
        pluginJAR = FilePath.getNomalizedPath(instance.getPluginFile(PLUGIN_FILE, JAR_EXTENSION));
        if (pluginXML == null || pluginJAR == null) {
            return false;
        }
        String sdbFileName = OSUtil.isWindowsPlatform() ? "sdb.exe" : "sdb";
        sdbPath = FilePath.getNomalizedPath(sdkPath.resolve(TOOLS_PATH).resolve(sdbFileName));
        ansiconPath = FilePath.getNomalizedPath(sdkPath.resolve(TOOLS_PATH).resolve("ansicon.exe"));
        return true;
    }

    private static Path getNomalizedPath(Path path) {
        if (path != null) {
            return path.toAbsolutePath().normalize();
        }
        return path;
    }

    public Path getSdbFilePath() {
        return sdbPath;
    }

    public Path getAnsiconPath() {
        return ansiconPath;
    }

    public Path getSDKRootPath() {
        return sdkPath;
    }

    public Path getPVPath() {
        return pvPath;
    }

    public Path getSDKDataPath() {
        return sdkDataPath;
    }

    public Path getVmsPath() {
        return vmsPath;
    }

    public Path getDataLogFile() {
        return logFile;
    }

    private Path getPluginPath() {
        return pluginPath;
    }

    public Path getPluginXMLPath() {
        return pluginXML;
    }

    public Path getPluginJARPath() {
        return pluginJAR;
    }

    public Path getParentJARPath() {
        if (parentJAR == null && ECPInfo.getInstance().getExtension() != null) {
            String extensionProfile = ECPInfo.getInstance().getExtension().getProfile();
            String string = ECPInfo.getInstance().getExtension().getVersion();
        }
        return parentJAR;
    }

    private boolean getSDKInfo() throws IOException {
        if (binPath == null) {
            return false;
        }
        if (isDevelop) {
            if (this.getSDKPath(Paths.get(".", new String[0]).resolve(SDKINFO_PATH))) {
                return true;
            }
            if (this.getSDKPath(binPath.resolve(SDKINFO_PATH))) {
                return true;
            }
            Path sdkPath = Paths.get(System.getProperty("user.home") + File.separator + "tizen-sdk", new String[0]);
            if (this.getSDKPath(sdkPath.resolve(SDKINFO_PATH))) {
                return true;
            }
            sdkPath = Paths.get("C:\\" + File.separator + "tizen-sdk", new String[0]);
            if (this.getSDKPath(sdkPath.resolve(SDKINFO_PATH))) {
                return true;
            }
        }
        return this.getSDKPath(binPath.resolve(PATH_SDK_INFO));
    }

    private boolean getSDKPath(Path sdkInfoFile) throws IOException {
        if (Files.notExists(sdkInfoFile, new LinkOption[0])) {
            return false;
        }
        BufferedReader in = Files.newBufferedReader(sdkInfoFile, Charset.forName("UTF-8"));
        String s = null;
        while ((s = in.readLine()) != null) {
            if (s.indexOf(SDK_INFO_SDK_TOKEN) >= 0) {
                sdkPath = Paths.get(s.substring(SDK_INFO_SDK_TOKEN.length() + 1, s.length()), new String[0]).toAbsolutePath().normalize();
                continue;
            }
            if (s.indexOf(SDK_INFO_DATA_TOKEN) < 0) continue;
            sdkDataPath = Paths.get(s.substring(SDK_INFO_DATA_TOKEN.length() + 1, s.length()), new String[0]).toAbsolutePath().normalize();
        }
        in.close();
        return true;
    }

    private Path getPluginFile(String filename, String extension) {
        String platformVersion = VMInfo.getInstance().getPlatformVersion();
        String version = platformVersion.substring(platformVersion.lastIndexOf("-"));
        String pluginName = filename + "-" + VMInfo.getInstance().getProfile() + version;
        Path path = null;
        if (isDevelop) {
            URL url = null;
            if (extension.equals(JAR_EXTENSION)) {
                String representativeClassName = "org.tizen.ecp.string.DeviceMessages";
                try {
                    url = this.getClass().getClassLoader().loadClass(representativeClassName).getProtectionDomain().getCodeSource().getLocation();
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                }
            } else if (extension.equals(XML_EXTENSION)) {
                url = this.getClass().getClassLoader().getResource(pluginName + extension);
            }
            try {
                path = Paths.get(url.toURI());
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
            if (Files.exists(path, new LinkOption[0])) {
                return path;
            }
            path = binPath.resolve(filename + extension);
            if (Files.exists(path, new LinkOption[0])) {
                return path;
            }
        }
        if (Files.exists(path = this.getPluginPath().resolve(pluginName + extension), new LinkOption[0])) {
            return path;
        }
        path = this.getPluginPath().resolve(filename + extension);
        if (Files.exists(path, new LinkOption[0])) {
            return path;
        }
        return null;
    }

    static {
        isDevelop = false;
        if (System.getProperty("develop") != null) {
            isDevelop = true;
        }
        instance = new FilePath();
    }
}

