/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.resources;

import java.util.function.Supplier;
import javafx.scene.text.Font;
import org.tizen.ecp.resources.FontSupplier;
import org.tizen.ecp.resources.ResourceKind;
import org.tizen.ecp.utils.OSUtil;

public class FontKind
implements ResourceKind {
    public static FontKind FONT_37_BOLD = new FontKind(new FontSupplier("BreezeSans-Bold", 37.0), () -> new Font("Arial Bold", 37.0), new FontSupplier("BreezeSans-Bold", 37.0));
    public static FontKind FONT_25_BOLD = new FontKind(new FontSupplier("BreezeSans-Bold", 25.0), () -> new Font("Arial Bold", 26.0), new FontSupplier("BreezeSans-Bold", 25.0));
    public static FontKind FONT_13 = new FontKind(new FontSupplier("BreezeSans", 13.0), () -> new Font("Arial", 13.0), new FontSupplier("BreezeSans", 13.0));
    private Supplier<Font> linuxSupplier;
    private Supplier<Font> winSupplier;
    private Supplier<Font> macSupplier;

    public FontKind(Supplier<Font> supplier) {
        this.linuxSupplier = supplier;
        this.winSupplier = supplier;
        this.macSupplier = supplier;
    }

    public FontKind(Supplier<Font> linuxSupplier, Supplier<Font> winSupplier, Supplier<Font> macSupplier) {
        this.linuxSupplier = linuxSupplier;
        this.winSupplier = winSupplier;
        this.macSupplier = macSupplier;
    }

    public Supplier<Font> getSupplier() {
        if (OSUtil.isMacPlatform()) {
            return this.macSupplier;
        }
        if (OSUtil.isWindowsPlatform()) {
            return this.winSupplier;
        }
        return this.linuxSupplier;
    }
}

