/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.views;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.input.MouseButton;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.TilePane;
import javafx.scene.layout.VBox;
import org.tizen.ecp.EmulatorControlPanel;
import org.tizen.ecp.about.About;
import org.tizen.ecp.device.DeviceManager;
import org.tizen.ecp.dialog.ButtonType;
import org.tizen.ecp.dialog.Dialog;
import org.tizen.ecp.interfaces.IPageChanged;
import org.tizen.ecp.resources.FontKind;
import org.tizen.ecp.resources.Fonts;
import org.tizen.ecp.resources.ImageKind;
import org.tizen.ecp.resources.Images;
import org.tizen.ecp.resources.StringResources;
import org.tizen.ecp.utils.ECPFXMLLoader;
import org.tizen.ecp.utils.LogUtil;
import org.tizen.ecp.views.ECPPageNavigator;
import org.tizen.ecp.views.card.ECPCardPane;

public class ECPMainAction
implements Initializable {
    private static Logger logger = LogUtil.getECPLogger(ECPMainAction.class).getLogger();
    @FXML
    private Button btnAbout;
    @FXML
    private AnchorPane rootAnchor;
    @FXML
    private TilePane tilePane;
    @FXML
    private TilePane borderPane;
    @FXML
    private StackPane stackPane;
    @FXML
    private ImageView ecpBackground;
    @FXML
    private Label ecpTitle;
    @FXML
    private Label tizenTitle;
    @FXML
    private Pane fxNavigatorBar;
    @FXML
    private Button fxPreviousBtn;
    @FXML
    private Button fxNextBtn;
    @FXML
    private HBox fxNavigatorPane;
    ECPPageNavigator pageNavigator;
    StackPane pane;
    private double tileWidth = 0.0;
    private double tileHeight = 0.0;
    private final List<Pane> cardPanes = new ArrayList<Pane>();
    int wCount;
    int hCount;
    ChangeListener<Number> tileSizeListener = new ChangeListener<Number>(){

        public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
            int pageCount = 0;
            ECPMainAction.this.wCount = (int)(ECPMainAction.this.tilePane.getWidth() / ECPMainAction.this.tileWidth);
            ECPMainAction.this.hCount = (int)(ECPMainAction.this.tilePane.getHeight() / ECPMainAction.this.tileHeight);
            int viewCount = ECPMainAction.this.wCount * ECPMainAction.this.hCount;
            if (viewCount != 0) {
                pageCount = ECPMainAction.this.cardPanes.size() / viewCount + (ECPMainAction.this.cardPanes.size() % viewCount != 0 ? 1 : 0);
                ECPMainAction.this.pageNavigator.setItem(pageCount, 0);
            } else {
                ECPMainAction.this.pageNavigator.setItem(1, 0);
            }
        }
    };
    private boolean pressed = false;
    private double posX = 0.0;
    private double posY = 0.0;
    private static final int DRAG_DIST = 100;

    public void initialize(URL location, ResourceBundle resources) {
        try {
            String width = EmulatorControlPanel.getECPProperty().getPropertyString("card.width");
            this.tileWidth = width != null ? Double.parseDouble(width) : 161.0;
            String height = EmulatorControlPanel.getECPProperty().getPropertyString("card.height");
            this.tileHeight = height != null ? Double.parseDouble(height) : 171.0;
        }
        catch (Exception e) {
            logger.log(Level.FINE, "Property file does not contain card size", e);
            e.printStackTrace();
            this.tileWidth = 161.0;
            this.tileHeight = 171.0;
        }
        this.btnAbout.setGraphic((Node)Images.getImageView(ImageKind.EMULATOR_INFO_NOR));
        GridPane.setMargin((Node)this.btnAbout, (Insets)new Insets(0.0, 20.0, 20.0, 0.0));
        this.ecpTitle.setFont(Fonts.get(FontKind.FONT_37_BOLD));
        this.tizenTitle.setFont(Fonts.get(FontKind.FONT_13));
        List<String> devices = DeviceManager.getInstance().getDeviceList();
        for (String device : devices) {
            ECPCardPane ecpPane = DeviceManager.getInstance().getDevice(device);
            if (ecpPane == null) continue;
            this.cardPanes.add(ecpPane.createView());
            ecpPane.onCreate();
        }
        this.tilePane.getChildren().addAll(this.cardPanes);
        this.tilePane.widthProperty().addListener(this.tileSizeListener);
        this.tilePane.heightProperty().addListener(this.tileSizeListener);
        this.ecpBackground.setImage(Images.getImageView(ImageKind.ECP_TOP_BG).getImage());
        this.fxNavigatorBar.getStylesheets().add((Object)this.getClass().getResource("resources/navigator.css").toExternalForm());
        this.fxPreviousBtn.getStyleClass().addAll((Object[])new String[]{"navigator-button", "previous-button"});
        this.fxNextBtn.getStyleClass().addAll((Object[])new String[]{"navigator-button", "next-button"});
        this.pageNavigator = new ECPPageNavigator((Pane)this.fxNavigatorPane, this.fxPreviousBtn, this.fxNextBtn);
        this.pageNavigator.setItem(1, 0);
        this.pageNavigator.addPageChangedListener(new IPageChanged(){

            @Override
            public void pageChangedListener(int page, int selected) {
                int wCount = (int)(ECPMainAction.this.tilePane.getWidth() / ECPMainAction.this.tileWidth);
                int hCount = (int)(ECPMainAction.this.tilePane.getHeight() / ECPMainAction.this.tileHeight);
                int viewCount = wCount * hCount;
                ECPMainAction.this.tilePane.getChildren().clear();
                ECPMainAction.this.borderPane.getChildren().clear();
                for (int i = 0; i < ECPMainAction.this.cardPanes.size(); ++i) {
                    if (i < viewCount * selected || i >= viewCount * (selected + 1)) continue;
                    AnchorPane border = new AnchorPane();
                    border.setStyle("-fx-background-color: #acacac;");
                    ECPMainAction.this.borderPane.getChildren().add((Object)border);
                    Pane pane = (Pane)ECPMainAction.this.cardPanes.get(i);
                    TilePane.setMargin((Node)pane, (Insets)new Insets(0.0, 1.0, 1.0, 0.0));
                    ECPMainAction.this.tilePane.getChildren().add((Object)pane);
                }
            }
        });
        this.stackPane.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                KeyCode keyCode = event.getCode();
                int currentIndex = ECPMainAction.this.findFocusedCardIndex();
                switch (keyCode) {
                    case PAGE_DOWN: {
                        if (!ECPMainAction.this.pageNavigator.nextPage()) break;
                        ECPMainAction.this.setFocus(currentIndex);
                        break;
                    }
                    case PAGE_UP: {
                        if (!ECPMainAction.this.pageNavigator.prevPage()) break;
                        ECPMainAction.this.setFocus(currentIndex);
                        break;
                    }
                    case LEFT: {
                        ECPMainAction.this.changeFocus(Direction.LEFT);
                        event.consume();
                        break;
                    }
                    case RIGHT: {
                        ECPMainAction.this.changeFocus(Direction.RIGHT);
                        event.consume();
                        break;
                    }
                    case UP: {
                        ECPMainAction.this.changeFocus(Direction.UP);
                        event.consume();
                        break;
                    }
                    case DOWN: {
                        ECPMainAction.this.changeFocus(Direction.DOWN);
                        event.consume();
                        break;
                    }
                }
            }
        });
    }

    private void changeFocus(Direction direction) {
        Node nextCard = this.findNextCard(direction);
        if (nextCard != null) {
            nextCard.requestFocus();
            return;
        }
        if (direction == Direction.LEFT) {
            if (this.pageNavigator.prevPage()) {
                this.setFocus(this.tilePane.getChildren().size() - 1);
            }
        } else if (direction == Direction.RIGHT && this.pageNavigator.nextPage()) {
            this.setFocus(0);
        }
    }

    private void setFocus(int focusIndex) {
        int cardNum = this.tilePane.getChildren().size();
        if (focusIndex < cardNum && focusIndex >= 0) {
            ((Node)this.tilePane.getChildren().get(focusIndex)).requestFocus();
        } else if (focusIndex >= cardNum) {
            ((Node)this.tilePane.getChildren().get(cardNum - 1)).requestFocus();
        }
    }

    private Node findNextCard(Direction direction) {
        int index = this.findFocusedCardIndex();
        if (direction == Direction.LEFT) {
            --index;
        } else if (direction == Direction.RIGHT) {
            ++index;
        } else if (direction == Direction.UP) {
            index -= this.wCount;
        } else if (direction == Direction.DOWN) {
            index += this.wCount;
        }
        if (index >= 0 && index < this.tilePane.getChildren().size()) {
            return (Node)this.tilePane.getChildren().get(index);
        }
        return null;
    }

    private int findFocusedCardIndex() {
        int index = 0;
        for (int i = 0; i < this.tilePane.getChildren().size(); ++i) {
            if (!((Node)this.tilePane.getChildren().get(i)).isFocused()) continue;
            index = i;
            break;
        }
        return index;
    }

    @FXML
    void clickPreviousBtn(ActionEvent event) {
        this.pageNavigator.prevPage();
    }

    @FXML
    void clickNextBtn(ActionEvent event) {
        this.pageNavigator.nextPage();
    }

    @FXML
    public void tileMouseEvent(MouseEvent event) {
        if (event.getButton() != MouseButton.PRIMARY) {
            return;
        }
        if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.pressed = true;
            this.posX = event.getSceneX();
            this.posY = event.getSceneY();
        } else if (event.getEventType() == MouseEvent.MOUSE_RELEASED && this.pressed) {
            double diffX = event.getSceneX() - this.posX;
            double diffY = event.getSceneY() - this.posY;
            if (diffX < -100.0) {
                this.pageNavigator.nextPage();
            } else if (diffX > 100.0) {
                this.pageNavigator.prevPage();
            } else if (diffY < -100.0) {
                this.pageNavigator.nextPage();
            } else if (diffY > 100.0) {
                this.pageNavigator.prevPage();
            }
            this.pressed = false;
        }
        if (event.getEventType() == MouseEvent.MOUSE_CLICKED && this.rootAnchor.getChildren().size() > 1) {
            this.rootAnchor.getChildren().remove(1);
        }
    }

    @FXML
    void clickAboutButton(ActionEvent event) {
        Dialog dialog = new Dialog();
        dialog.setTitle("About Emulator Control Panel");
        dialog.addButonType(ButtonType.CLOSE);
        ECPFXMLLoader loader = new ECPFXMLLoader(this.getClass().getResource("/org/tizen/ecp/about/AboutView.fxml"), new Object[0]);
        VBox content = null;
        try {
            content = (VBox)loader.load();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
        if (content == null) {
            About about = About.getInstance();
            String contents = "Version: " + about.getAboutVersion() + StringResources.NEW_LINE + "Build time: " + about.getBuildTime() + " (GMT)" + StringResources.NEW_LINE + "Git version: " + about.getGitVersion() + StringResources.NEW_LINE + "Workspace path: " + about.getWorkspacePath() + StringResources.NEW_LINE + "Package version: " + about.getEcpVersion();
            dialog.setContentText(contents);
        } else {
            AnchorPane pane = new AnchorPane();
            pane.getChildren().add((Object)content);
            AnchorPane.setLeftAnchor((Node)content, (Double)-1.0);
            AnchorPane.setRightAnchor((Node)content, (Double)-1.0);
            AnchorPane.setTopAnchor((Node)content, (Double)-1.0);
            dialog.getDialogPane().setContent((Node)pane);
            content.autosize();
        }
        dialog.setResizable(false);
        dialog.showAndWait();
    }

    @FXML
    public void aboutButtonMouseEvent(MouseEvent event) {
        if (event.getEventType() == MouseEvent.MOUSE_ENTERED) {
            this.btnAbout.setGraphic((Node)Images.getImageView(ImageKind.EMULATOR_INFO_OVER));
        } else if (event.getEventType() == MouseEvent.MOUSE_PRESSED) {
            this.btnAbout.setGraphic((Node)Images.getImageView(ImageKind.EMULATOR_INFO_PRESS));
        } else {
            this.btnAbout.setGraphic((Node)Images.getImageView(ImageKind.EMULATOR_INFO_NOR));
        }
    }

    static enum Direction {
        LEFT,
        RIGHT,
        UP,
        DOWN;

    }
}

