/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.utils;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tizen.ecp.utils.ECPFormatter;
import org.tizen.ecp.utils.FilePath;

public class LogUtil {
    private static FileHandler fileHandler;
    private static boolean isInit;
    private static Map<Class<?>, LogUtil> loggerMap;
    private Logger logger;

    private LogUtil(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public static void setLevel(Level level) {
        if (null != fileHandler) {
            fileHandler.setLevel(level);
        }
    }

    public static void init(ECPLogLevel logLevel, boolean append) throws IOException {
        if (!isInit) {
            Path logFile = FilePath.getInstance().getDataLogFile();
            if (logFile == null) {
                return;
            }
            if (Files.notExists(logFile, new LinkOption[0])) {
                try {
                    Files.createDirectories(logFile.getParent(), new FileAttribute[0]);
                    if (Files.createFile(logFile, new FileAttribute[0]) == null) {
                        return;
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
            fileHandler = new FileHandler(logFile.toString(), append);
            fileHandler.setEncoding("UTF-8");
            fileHandler.setFormatter(new ECPFormatter());
            fileHandler.setLevel(logLevel.level());
            isInit = true;
        }
    }

    public static void end() {
        loggerMap.clear();
        fileHandler.close();
    }

    public static <T> LogUtil getECPLogger(Class<T> clazz) {
        String name = null;
        name = null == clazz ? LogUtil.class.getName() : clazz.getName();
        LogUtil ECPLogger = loggerMap.get(clazz);
        if (null != ECPLogger) {
            return ECPLogger;
        }
        Logger logger = Logger.getLogger(name);
        if (logger == null) {
            logger = Logger.getAnonymousLogger();
        }
        if (fileHandler == null) {
            ConsoleHandler console = new ConsoleHandler();
            logger.addHandler(console);
            logger.setLevel(Level.SEVERE);
        } else {
            logger.addHandler(fileHandler);
            logger.setLevel(fileHandler.getLevel());
        }
        logger.setUseParentHandlers(false);
        LogUtil sLogger = new LogUtil(logger);
        loggerMap.put(clazz, sLogger);
        return sLogger;
    }

    static {
        loggerMap = new HashMap();
    }

    public static enum ECPLogLevel {
        ERROR(Level.SEVERE, "error"),
        WARN(Level.WARNING, "warn"),
        DEBUG(Level.INFO, "debug"),
        TRACE(Level.FINE, "trace");

        private Level level;
        private String value;

        private ECPLogLevel(Level level, String value) {
            this.level = level;
            this.value = value;
        }

        public Level level() {
            return this.level;
        }

        public String value() {
            return this.value;
        }
    }
}

