/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.sock;

import com.google.protobuf.CodedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.sock.MessageQueue;
import org.tizen.ecp.sock.SocketClient;

public class SocketReceive
implements Runnable {
    @Override
    public void run() {
        SocketClient client = SocketClient.getInstance();
        DataInputStream in = client.getInputStream();
        int size = 0;
        try {
            while ((size = in.readInt()) > 0 && client.isRunning() && !client.getSocket().isClosed()) {
                this.read_data(size, in);
            }
        }
        catch (EOFException e) {
            client.disconnect();
        }
        catch (IOException e) {
            client.disconnect();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read_data(int size, DataInputStream in) throws IOException {
        CodedInputStream codedIn = null;
        int available = in.available();
        if (size <= available) {
            byte[] buff = new byte[size];
            int read = in.read(buff);
            if (read > size) {
                return;
            }
            codedIn = CodedInputStream.newInstance((byte[])buff);
            if (codedIn != null) {
                Ecs.Master msg = Ecs.Master.parseFrom(codedIn);
                MessageQueue messageQueue = MessageQueue.getInstance();
                synchronized (messageQueue) {
                    MessageQueue.getInstance().QueueMsg(msg);
                }
            }
        }
    }
}

