/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.kohsuke.args4j.spi.SubCommand;
import org.kohsuke.args4j.spi.SubCommands;
import org.tizen.cli.monitor.KeyCodeCLI;
import org.tizen.cli.monitor.TizenEmulatorHMP;
import org.tizen.cli.monitor.TizenEmulatorHelp;
import org.tizen.cli.monitor.TizenEmulatorQMP;
import org.tizen.cli.utils.ArgsUtil;
import org.tizen.cli.utils.EmulatorDevice;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.DynamicLoader;
import org.tizen.ecp.ECPInfo;
import org.tizen.ecp.VMInfo;
import org.tizen.ecp.ecpinfo.xmls.DeviceType;

public class CLIManager {
    private List<EmulatorDevice> devices = new ArrayList<EmulatorDevice>();
    private EmulatorDevice device = null;
    private static CLIManager instance = new CLIManager();
    private HashMap<String, Class<?>> classMap = new HashMap();
    private HashMap<Class<?>, Object> instanceMap = new HashMap();
    private boolean sessionMode = false;

    public CLIManager() {
        this.classMap.put("org.tizen.cli.monitor.TizenEmulatorHelp", TizenEmulatorHelp.class);
        this.classMap.put("org.tizen.cli.monitor.TizenEmulatorHMP", TizenEmulatorHMP.class);
        this.classMap.put("org.tizen.cli.monitor.TizenEmulatorQMP", TizenEmulatorQMP.class);
        this.classMap.put("org.tizen.cli.monitor.KeyCodeCLI", KeyCodeCLI.class);
        this.instanceMap.put(TizenEmulatorHelp.class, new TizenEmulatorHelp());
        this.instanceMap.put(TizenEmulatorHMP.class, new TizenEmulatorHMP());
        this.instanceMap.put(TizenEmulatorQMP.class, new TizenEmulatorQMP());
        this.instanceMap.put(KeyCodeCLI.class, new KeyCodeCLI());
    }

    public static CLIManager getInstance() {
        return instance;
    }

    public void addInfo(String vmname, String profile, String version, int port) {
        EmulatorDevice dev = new EmulatorDevice(vmname, port, profile, version);
        this.devices.add(dev);
        VMInfo.getInstance().initialize(vmname, port, version, profile);
    }

    public List<EmulatorDevice> getDevices() {
        return this.devices;
    }

    public void setSelectedDevice(EmulatorDevice device) {
        this.device = device;
    }

    public EmulatorDevice getSelectedDevice() {
        return this.device;
    }

    public void setSessionMode(boolean session) {
        this.sessionMode = session;
    }

    public boolean getSessionMode() {
        return this.sessionMode;
    }

    public DeviceType findDevice(String device) {
        List deviceList = ECPInfo.getInstance().getDevice();
        if (deviceList == null) {
            return null;
        }
        for (DeviceType d : deviceList) {
            String name = d.getCLICommand();
            if (name == null || name.isEmpty() || !name.equals(device)) continue;
            return d;
        }
        return ECPInfo.getInstance().getExtCLIDevice(device);
    }

    public void loadClass() {
        List devices = ECPInfo.getInstance().getDevice();
        if (devices == null) {
            return;
        }
        Class<?> dClass = null;
        String prof = ECPInfo.getInstance().getParentProfile();
        for (DeviceType dev : devices) {
            String impl = dev.getCLIImpl();
            if ((impl == null || impl.isEmpty()) && prof != null) {
                dev = ECPInfo.getInstance().getExtDevice(dev.getName());
                if (dev == null) continue;
                impl = dev.getCLIImpl();
            }
            if (impl == null) continue;
            try {
                dClass = DynamicLoader.getClassLoader().loadClass(impl);
            }
            catch (ClassNotFoundException e) {
                OutputUtil.printError("CLIManager - ClassNotFound: " + impl);
            }
            if (dClass == null) continue;
            this.classMap.put(impl, dClass);
            for (Field f : dClass.getDeclaredFields()) {
                SubCommands scmds = f.getAnnotation(SubCommands.class);
                if (scmds == null) continue;
                for (SubCommand scmd : scmds.value()) {
                    if (scmd == null) continue;
                    try {
                        dClass = DynamicLoader.getClassLoader().loadClass(scmd.impl().getCanonicalName());
                    }
                    catch (ClassNotFoundException e) {
                        OutputUtil.printError("CLIManager - ClassNotFound: " + impl);
                        continue;
                    }
                    this.classMap.put(scmd.impl().getCanonicalName(), dClass);
                }
            }
        }
    }

    public Class<?> tryLoadClass(String className) {
        Class<?> dClass = null;
        try {
            dClass = DynamicLoader.getClassLoader().loadClass(className);
        }
        catch (ClassNotFoundException e) {
            OutputUtil.printError("CLIManager - ClassNotFound: " + className);
        }
        return dClass;
    }

    public Class<?> getClass(String className) {
        OutputUtil.debug("CLIManager - getClass requested: " + className);
        return this.classMap.get(className);
    }

    public Object instantiate(Class<?> loadClass) throws InstantiationException, IllegalAccessException {
        Object object = null;
        if (this.instanceMap.containsKey(loadClass)) {
            OutputUtil.debug("instanceMap has the key: " + loadClass.getCanonicalName());
            return this.instanceMap.get(loadClass);
        }
        object = loadClass.newInstance();
        this.instanceMap.put(loadClass, object);
        return object;
    }

    public Object getInstantiateClass(String className) throws InstantiationException, IllegalAccessException {
        Class<?> cname = this.getClass(className);
        if (cname == null) {
            cname = this.tryLoadClass(className);
        }
        return this.instantiate(cname);
    }

    public Collection<Object> getClassInstances() {
        return this.instanceMap.values();
    }

    public int checkTarget(String[] args) {
        if (this.devices == null || this.devices.size() <= 0) {
            return 17;
        }
        if (ArgsUtil.isTargetOptionSpecified(args)) {
            String targetSpecified = ArgsUtil.getTargetValueSpecified(args);
            OutputUtil.debug("targetSpecified : " + targetSpecified);
            for (EmulatorDevice dev : this.devices) {
                String name = dev.getVmName();
                String target = dev.getTarget();
                OutputUtil.debug("comparing name : " + name + ", target : " + target);
                if ((name == null || !name.equals(targetSpecified)) && (target == null || !target.equals(targetSpecified))) continue;
                this.device = dev;
            }
            if (this.device == null) {
                return 18;
            }
        } else if (this.devices.size() == 1) {
            this.device = this.devices.get(0);
        } else {
            OutputUtil.debug("getDevice: " + this.devices.size());
            return 19;
        }
        return 0;
    }
}

