/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.utils;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;

class ECPFormatter
extends Formatter {
    private SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd-HH:mm:ss");
    private String lineSeparator = System.getProperty("line.separator");

    ECPFormatter() {
    }

    @Override
    public String format(LogRecord record) {
        StringBuilder builder = new StringBuilder();
        builder.append("[");
        builder.append(record.getLevel().toString());
        builder.append(":");
        String formattedDate = this.simpleDateFormat.format(new Date(record.getMillis()));
        builder.append(formattedDate);
        builder.append(":");
        if (null != record.getSourceClassName()) {
            String sourceClassName = record.getSourceClassName();
            String[] split = sourceClassName.split("\\.");
            builder.append(split[split.length - 1]);
        } else {
            builder.append(record.getLoggerName());
        }
        if (null != record.getSourceMethodName()) {
            builder.append(".");
            builder.append(record.getSourceMethodName());
        }
        builder.append("] ");
        String message = this.formatMessage(record);
        builder.append(message);
        builder.append(this.lineSeparator);
        if (null != record.getThrown()) {
            try {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                record.getThrown().printStackTrace(pw);
                pw.close();
                builder.append(sw.toString());
            }
            catch (Exception ex) {
                System.err.println(ex.getMessage());
            }
        }
        return builder.toString();
    }
}

