/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.cli.monitor;

import com.google.protobuf.GeneratedMessage;
import org.kohsuke.args4j.Argument;
import org.tizen.cli.AbstractEmulatorCLI;
import org.tizen.cli.CLIConstants;
import org.tizen.cli.string.CliMessages;
import org.tizen.cli.utils.OutputUtil;
import org.tizen.ecp.msg.genmsg.ecs.Ecs;
import org.tizen.ecp.resources.StringResources;
import org.tizen.ecp.sock.EventMgr;
import org.tizen.ecp.sock.ILsn;
import org.tizen.ecp.sock.MessageSender;
import org.tizen.ecp.sock.SocketClient;

public class KeyCodeCLI
extends AbstractEmulatorCLI {
    private static final String PRESS = CliMessages.getString("KeyCodeCLI.0");
    private static final String RELEASE = CliMessages.getString("KeyCodeCLI.1");
    @Argument(index=0)
    String code;
    @Argument(index=1)
    String press;
    private boolean isPeriod = false;
    private int retCount = 0;

    public KeyCodeCLI() {
        this.messageType = "input";
        this.help = CLIConstants.STRING_USAGE + "ecp-cli" + CliMessages.getString("KeyCodeCLI.3") + CLIConstants.STRING_TARGET + StringResources.NEW_LINE + StringResources.NEW_LINE + CLIConstants.HELP_COMMAND_ARGS + OutputUtil.getFormatList(CliMessages.getString("KeyCodeCLI.4")) + OutputUtil.getFormatList(CliMessages.getString("KeyCodeCLI.5")) + OutputUtil.getFormatList(CliMessages.getString("KeyCodeCLI.6"));
    }

    private int getNumber(String number) {
        int intNum = -1;
        try {
            intNum = Integer.parseInt(number);
        }
        catch (NumberFormatException e) {
            return intNum;
        }
        return intNum;
    }

    private void sendReq(int action) {
        MessageSender.getInstance().sendDeviceReq(CliMessages.getString("KeyCodeCLI.7"), 0, action, "" + this.code);
    }

    @Override
    public int execute() {
        int ret = 0;
        this.running = true;
        if (this.messageType != null) {
            EventMgr.getInstance().AddLsn(this.messageType, (ILsn)this);
        }
        if (!SocketClient.getInstance().getGuestStatus()) {
            OutputUtil.printError(CLIConstants.ERR_DESC_EMULATOR_NOT_READY);
            return 28;
        }
        ret = this.executeKeyCode();
        if (this.messageType != null) {
            EventMgr.getInstance().RemoveLsn(this.messageType, (ILsn)this);
        }
        if (this.timerExpired) {
            OutputUtil.printError(CLIConstants.ERR_DESC_NO_RESPONSE);
            return 129;
        }
        if (ret != 0) {
            return ret;
        }
        return this.returnValue;
    }

    private int executeKeyCode() {
        int checkKeyCode = this.getNumber(this.code);
        if (checkKeyCode < 0) {
            OutputUtil.printHelpError(CLIConstants.ERR_DESC_NO_PROPER_ARGS, this.help);
            return 25;
        }
        int period = 0;
        if (this.press == null || this.press.isEmpty()) {
            this.isPeriod = true;
            this.sendReq(1);
            this.sendReq(2);
        } else {
            period = this.getNumber(this.press);
            if (period >= 0) {
                this.isPeriod = true;
                this.sendReq(1);
                try {
                    Thread.sleep(period);
                }
                catch (InterruptedException e) {
                    OutputUtil.printError(CLIConstants.ERR_DESC_INTERRUPTED);
                    return 4;
                }
                this.sendReq(2);
            } else if (this.press.toLowerCase().equals(PRESS)) {
                this.sendReq(1);
            } else if (this.press.toLowerCase().equals(RELEASE)) {
                this.sendReq(2);
            } else {
                OutputUtil.printHelpError(CLIConstants.ERR_DESC_NO_PROPER_ARGS, this.help);
                return 25;
            }
        }
        this.startRunning();
        return 0;
    }

    @Override
    public void OnEventProcPB(String eventname, GeneratedMessage param) {
        if (param instanceof Ecs.DeviceAns) {
            Ecs.DeviceAns ijans = (Ecs.DeviceAns)param;
            int result = ijans.getErrcode();
            if (result != 0) {
                this.returnValue = 128;
                OutputUtil.printFail();
                this.stopRunning();
            } else {
                ++this.retCount;
                if (this.isPeriod && this.retCount == 2 || !this.isPeriod) {
                    OutputUtil.printOK();
                    this.retCount = 0;
                    this.stopRunning();
                }
            }
        }
    }

    @Override
    public void printHelp() {
        OutputUtil.println(this.help);
    }
}

