/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.dialog.shortcut;

import java.net.URL;
import java.util.List;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.ListView;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.util.Callback;
import org.tizen.ecp.EmulatorControlPanel;
import org.tizen.ecp.dialog.ButtonType;
import org.tizen.ecp.dialog.Dialog;
import org.tizen.ecp.dialog.shortcut.CardListCell;
import org.tizen.ecp.dialog.shortcut.ListCellData;
import org.tizen.ecp.views.card.ECPCardPane;

public class ShortcutSelectionDialog {
    private static final URL LISTVIEW_CSS = EmulatorControlPanel.class.getResource("/org/tizen/ecp/dialog/shortcut/selectionDialog.css");
    private static int CONTENT_HEIGHT = 100;
    private static int CONTENT_WIDTH = 300;
    private static int DIALOG_MIN_HEIGHT = 150;
    private static final String TITLE = "Select an item";
    private final List<ECPCardPane> cardList;
    private ListView<ListCellData> listView;
    private boolean isCancel = true;

    public ShortcutSelectionDialog(List<ECPCardPane> cardList) {
        this.cardList = cardList;
    }

    public ECPCardPane open() {
        final Dialog<ECPCardPane> dialog = new Dialog<ECPCardPane>();
        ObservableList listViewItems = FXCollections.observableArrayList();
        for (ECPCardPane card : this.cardList) {
            listViewItems.add((Object)new ListCellData(card.getTitle()));
        }
        this.listView = new ListView();
        this.listView.setItems(listViewItems);
        this.listView.setCellFactory(CardListCell.extractor());
        this.listView.getStylesheets().add((Object)LISTVIEW_CSS.toExternalForm());
        final String shortcut = this.cardList.get(0).getShortcut();
        this.listView.setOnKeyPressed((EventHandler)new EventHandler<KeyEvent>(){

            public void handle(KeyEvent event) {
                KeyCode keyCode = event.getCode();
                switch (keyCode) {
                    case ENTER: 
                    case SPACE: {
                        ShortcutSelectionDialog.this.isCancel = false;
                        dialog.close();
                        break;
                    }
                    case ESCAPE: {
                        ShortcutSelectionDialog.this.isCancel = true;
                        dialog.close();
                    }
                    default: {
                        if (!event.isAltDown() || !shortcut.equals(keyCode.getName().toLowerCase())) break;
                        ShortcutSelectionDialog.this.moveNext();
                    }
                }
            }
        });
        this.listView.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<ListCellData>(){

            public void changed(ObservableValue<? extends ListCellData> observable, ListCellData oldData, ListCellData newData) {
                if (newData == null) {
                    return;
                }
                for (ListCellData cellData : ShortcutSelectionDialog.this.listView.getItems()) {
                    if (cellData.equals(newData)) {
                        cellData.getIsSelect().set(true);
                        continue;
                    }
                    cellData.getIsSelect().set(false);
                }
            }
        });
        this.listView.getSelectionModel().select(0);
        AnchorPane pane = new AnchorPane();
        pane.setPrefSize((double)CONTENT_WIDTH, (double)CONTENT_HEIGHT);
        pane.getChildren().add(this.listView);
        AnchorPane.setLeftAnchor(this.listView, (Double)0.0);
        AnchorPane.setRightAnchor(this.listView, (Double)0.0);
        AnchorPane.setTopAnchor(this.listView, (Double)0.0);
        AnchorPane.setBottomAnchor(this.listView, (Double)0.0);
        dialog.getDialogPane().setContent((Node)pane);
        dialog.setTitle(TITLE);
        dialog.setResizable(true);
        dialog.setMinSize(CONTENT_WIDTH, DIALOG_MIN_HEIGHT);
        dialog.getDialogPane().addButonType(ButtonType.OK);
        dialog.getDialogPane().addButonType(ButtonType.CANCEL);
        dialog.setResultConverter(new Callback<ButtonType, ECPCardPane>(){

            public ECPCardPane call(ButtonType param) {
                if (param == ButtonType.CANCEL && ShortcutSelectionDialog.this.isCancel) {
                    return null;
                }
                ListCellData selectedItem = (ListCellData)ShortcutSelectionDialog.this.listView.getSelectionModel().getSelectedItem();
                for (ECPCardPane card : ShortcutSelectionDialog.this.cardList) {
                    if (!card.getTitle().equals(selectedItem.getTitle())) continue;
                    return card;
                }
                return null;
            }
        });
        this.listView.requestFocus();
        return (ECPCardPane)dialog.showAndWait();
    }

    private void moveNext() {
        int listSize;
        int currentIndex = this.listView.getSelectionModel().getSelectedIndex();
        if (currentIndex + 1 < (listSize = this.listView.getItems().size())) {
            this.listView.getSelectionModel().selectNext();
        } else if (currentIndex + 1 == listSize) {
            this.listView.getSelectionModel().selectPrevious();
        }
    }
}

