/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp.control;

import java.text.DecimalFormat;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.control.Slider;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.tizen.ecp.control.SpinnerArrowButton;
import org.tizen.ecp.control.TizenSliderSkin;
import org.tizen.ecp.control.TizenTextField;
import org.tizen.ecp.resources.ImageKind;
import org.tizen.ecp.resources.Images;

public class TizenSpinner
extends HBox {
    private SpinnerArrowButton decrementButton;
    private SpinnerArrowButton incrementButton;
    private Slider slider;
    private TizenTextField textField;
    private boolean isInteger = true;
    private DecimalFormat format = new DecimalFormat("0");
    private BooleanProperty editable = new SimpleBooleanProperty((Object)this, "editableProp"){

        protected void invalidated() {
            TizenSpinner.this.textField.setEditable(TizenSpinner.this.editable.get());
        }
    };

    public TizenSpinner() {
        this(0, 100, 0, 1);
    }

    public TizenSpinner(double min, double max, double initialValue) {
        this(min, max, initialValue, 1.0);
    }

    public TizenSpinner(double min, double max, double initialValue, double amountToStepBy) {
        this.makeTizenSpinner();
        this.isInteger = false;
        this.format = new DecimalFormat("#0.0");
        this.initialize(min, max, initialValue, amountToStepBy);
    }

    public TizenSpinner(int min, int max, int initialValue) {
        this(min, max, initialValue, 1);
    }

    public TizenSpinner(int min, int max, int initialValue, int amountToStepBy) {
        this.makeTizenSpinner();
        this.initialize(min, max, initialValue, amountToStepBy);
    }

    private void initialize(double min, double max, double initialValue, double amountToStepBy) {
        if (min > max) {
            min = max;
        }
        if (initialValue < min) {
            initialValue = min;
        }
        if (initialValue > max) {
            initialValue = max;
        }
        if (amountToStepBy < 0.0) {
            amountToStepBy = 1.0;
        }
        this.slider.setMin(min);
        this.slider.setMax(max);
        this.slider.setValue(initialValue);
        this.slider.setBlockIncrement(amountToStepBy);
        this.textField.setText(this.format.format(initialValue));
        int len = this.format.format(max).length();
        if (min >= 0.0) {
            this.textField.setMatchStr(this.isInteger ? "[0-9]" : "[0-9.]");
            this.textField.setMaxLen(len);
        } else {
            this.textField.setMatchStr(this.isInteger ? "[0-9-]" : "[0-9-.]");
            this.textField.setMaxLen(len + 1);
        }
    }

    private void makeTizenSpinner() {
        this.getStyleClass().add((Object)"tizen-spinner");
        this.decrementButton = new SpinnerArrowButton(Images.getImageView(ImageKind.ZOOM_BTN_LEFT_NOR), Images.getImageView(ImageKind.ZOOM_BTN_LEFT_NOR), Images.getImageView(ImageKind.ZOOM_BTN_LEFT_SEL));
        this.incrementButton = new SpinnerArrowButton(Images.getImageView(ImageKind.ZOOM_BTN_RIGHT_NOR), Images.getImageView(ImageKind.ZOOM_BTN_RIGHT_NOR), Images.getImageView(ImageKind.ZOOM_BTN_RIGHT_SEL));
        this.slider = new Slider();
        this.slider.setSkin((Skin)new TizenSliderSkin(this.slider));
        this.slider.getStyleClass().add((Object)"spinner-slider");
        this.textField = new TizenTextField();
        this.textField.setPrefWidth(50.0);
        this.addListener();
        this.getChildren().add((Object)this.decrementButton);
        this.getChildren().add((Object)this.slider);
        this.getChildren().add((Object)this.incrementButton);
        this.getChildren().add((Object)this.textField);
        HBox.setMargin((Node)this.slider, (Insets)new Insets(12.0, 0.0, 0.0, 0.0));
        HBox.setMargin((Node)this.textField, (Insets)new Insets(0.0, 0.0, 0.0, 10.0));
        HBox.setHgrow((Node)this.slider, (Priority)Priority.ALWAYS);
    }

    private void addListener() {
        this.textField.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                String text = TizenSpinner.this.textField.getText();
                double value = Double.valueOf(text);
                if (value < TizenSpinner.this.slider.getMin()) {
                    value = TizenSpinner.this.slider.getMin();
                } else if (value > TizenSpinner.this.slider.getMax()) {
                    value = TizenSpinner.this.slider.getMax();
                }
                if (TizenSpinner.this.isInteger) {
                    TizenSpinner.this.slider.setValue((double)((int)value));
                } else if (TizenSpinner.this.slider.getValue() == value) {
                    TizenSpinner.this.textField.setText(TizenSpinner.this.format.format(value));
                } else {
                    TizenSpinner.this.slider.setValue(value);
                }
            }
        });
        this.slider.valueProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                TizenSpinner.this.textField.setText(TizenSpinner.this.format.format(newValue));
            }
        });
        this.decrementButton.setOnMouseClick((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                TizenSpinner.this.slider.decrement();
            }
        });
        this.decrementButton.setOnActionEvent((EventHandler<? super ActionEvent>)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                TizenSpinner.this.slider.decrement();
            }
        });
        this.incrementButton.setOnMouseClick((EventHandler<? super MouseEvent>)new EventHandler<MouseEvent>(){

            public void handle(MouseEvent event) {
                TizenSpinner.this.slider.increment();
            }
        });
        this.incrementButton.setOnActionEvent((EventHandler<? super ActionEvent>)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                TizenSpinner.this.slider.increment();
            }
        });
    }

    public BooleanProperty editableProperty() {
        return this.editable;
    }

    public boolean isEditable() {
        return this.editable.get();
    }

    public void setEditable(boolean value) {
        this.editable.set(value);
    }

    public TizenTextField getEditor() {
        return this.textField;
    }

    public DecimalFormat getFormat() {
        return this.format;
    }

    public void setFormat(DecimalFormat format) {
        this.format = format;
        this.textField.setText(format.format(this.slider.getValue()));
        int len = format.format(this.slider.getMax()).length();
        if (this.slider.getMin() >= 0.0) {
            this.textField.setMaxLen(len);
        } else {
            this.textField.setMaxLen(len + 1);
        }
    }

    public void decrement() {
        this.slider.decrement();
    }

    public void decrement(int steps) {
        for (int i = 0; i < steps; ++i) {
            this.slider.decrement();
        }
    }

    public double getValue() {
        try {
            return Double.parseDouble(this.format.format(this.slider.getValue()));
        }
        catch (NullPointerException | NumberFormatException e) {
            return 0.0;
        }
    }

    public void setValue(double value) {
        this.slider.setValue(value);
    }

    public DoubleProperty valueProperty() {
        return this.slider.valueProperty();
    }

    public void increment() {
        this.slider.increment();
    }

    public void increment(int steps) {
        for (int i = 0; i < steps; ++i) {
            this.slider.increment();
        }
    }
}

