/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.ecp;

import java.nio.file.Path;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.tizen.ecp.ecpinfo.xmls.BaseInformationType;
import org.tizen.ecp.ecpinfo.xmls.DeviceType;
import org.tizen.ecp.ecpinfo.xmls.DevicesType;
import org.tizen.ecp.ecpinfo.xmls.ECPConfiguration;
import org.tizen.ecp.ecpinfo.xmls.ExtensionType;
import org.tizen.ecp.utils.FilePath;
import org.tizen.ecp.utils.JaxbUtil;

public class ECPInfo {
    private static ECPInfo instance = new ECPInfo();
    ECPConfiguration configuration = null;
    ECPConfiguration extConf = null;

    public static ECPInfo getInstance() {
        return instance;
    }

    public void initialize(Path ecpInfoPath) throws JAXBException {
        JAXBElement<?> element = JaxbUtil.unmarshal(ecpInfoPath, ECPConfiguration.class);
        this.configuration = (ECPConfiguration)element.getValue();
        String prof = this.getParentProfile();
        if (prof == null || this.getParentVersion() == null) {
            return;
        }
        Path extPath = FilePath.getInstance().getParentXMLPath();
        if (extPath != null) {
            ECPInfo.getInstance().initializeExt(extPath);
        }
    }

    public void initializeExt(Path ecpExtPath) throws JAXBException {
        JAXBElement<?> element = JaxbUtil.unmarshal(ecpExtPath, ECPConfiguration.class);
        this.extConf = (ECPConfiguration)element.getValue();
    }

    public ECPConfiguration getConfiguration() {
        return this.configuration;
    }

    public BaseInformationType getBaseInfo() {
        if (this.configuration == null) {
            return null;
        }
        return this.configuration.getBaseInformation();
    }

    public DevicesType getDevices() {
        if (this.configuration == null) {
            return null;
        }
        return this.configuration.getDevices();
    }

    public List<DeviceType> getDevice() {
        DevicesType devices = this.getDevices();
        if (devices == null) {
            return null;
        }
        return devices.getDevice();
    }

    public DeviceType getExtDevice(String name) {
        if (this.extConf == null || this.extConf.getDevices() == null || name == null) {
            return null;
        }
        List<DeviceType> device = this.extConf.getDevices().getDevice();
        for (DeviceType dev : device) {
            if (!name.equals(dev.getName())) continue;
            return dev;
        }
        return null;
    }

    public DeviceType getExtCLIDevice(String name) {
        if (this.extConf == null || this.extConf.getDevices() == null || name == null) {
            return null;
        }
        List<DeviceType> device = this.extConf.getDevices().getDevice();
        for (DeviceType dev : device) {
            if (!name.equals(dev.getCLICommand())) continue;
            return dev;
        }
        return null;
    }

    public ExtensionType getParent() {
        BaseInformationType ext = this.getBaseInfo();
        if (ext == null) {
            return null;
        }
        return ext.getExtension();
    }

    public String getParentVersion() {
        ExtensionType type = this.getParent();
        if (type == null) {
            return null;
        }
        return type.getVersion();
    }

    public String getParentProfile() {
        ExtensionType type = this.getParent();
        if (type == null) {
            return null;
        }
        return type.getProfile();
    }
}

